/*
 * Decompiled with CFR 0.152.
 */
package io.openapiparser.converter;

import io.openapiparser.Factory;
import io.openapiparser.converter.PropertyConverter;
import io.openapiparser.converter.TypeMismatchException;
import io.openapiparser.converter.Types;
import io.openapiparser.schema.Bucket;
import java.net.URI;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ObjectNullableConverter<@UnknownKeyFor T>
implements PropertyConverter<T> {
    private final @UnknownKeyFor @NonNull @Initialized URI uri;
    private final @UnknownKeyFor @NonNull @Initialized Factory<T> factory;

    public ObjectNullableConverter(@UnknownKeyFor @NonNull @Initialized URI uri, @UnknownKeyFor @NonNull @Initialized Factory<T> factory) {
        this.uri = uri;
        this.factory = factory;
    }

    public @Nullable T convert(@UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized Object value, @UnknownKeyFor @NonNull @Initialized String location) {
        Bucket bucket = this.getBucket(value, location);
        if (bucket == null) {
            return null;
        }
        return this.factory.create(bucket);
    }

    private @Nullable @UnknownKeyFor @Initialized Bucket getBucket(@Nullable @UnknownKeyFor @Initialized Object value, @UnknownKeyFor @NonNull @Initialized String location) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Map)) {
            throw new TypeMismatchException(location, Map.class);
        }
        return new Bucket(this.uri, location, Types.asMap((Object)value));
    }
}

