/*
 * Decompiled with CFR 0.152.
 */
package io.openapiparser.model.v30;

import io.openapiparser.Context;
import io.openapiparser.Properties;
import io.openapiparser.model.v30.Example;
import io.openapiparser.model.v30.Extensions;
import io.openapiparser.model.v30.MediaType;
import io.openapiparser.model.v30.Reference;
import io.openapiparser.model.v30.Schema;
import io.openapiparser.schema.Bucket;
import io.openapiparser.support.Required;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Parameter
extends Properties
implements Reference,
Extensions {
    public Parameter(@UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized Bucket bucket) {
        super(context, bucket);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isRef() {
        return this.hasProperty("$ref");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getRef() {
        return this.getStringOrThrow("$ref");
    }

    public @UnknownKeyFor @NonNull @Initialized Parameter getRefObject() {
        return this.getRefObjectOrThrow(Parameter.class);
    }

    @Required
    public @UnknownKeyFor @NonNull @Initialized String getName() {
        return this.getStringOrThrow("name");
    }

    @Required
    public @UnknownKeyFor @NonNull @Initialized String getIn() {
        return this.getStringOrThrow("in");
    }

    public @Nullable @UnknownKeyFor @Initialized String getDescription() {
        return this.getStringOrNull("description");
    }

    public @UnknownKeyFor @NonNull @Initialized Boolean getRequired() {
        return this.getBooleanOrDefault("required", false);
    }

    public @UnknownKeyFor @NonNull @Initialized Boolean getDeprecated() {
        return this.getBooleanOrDefault("deprecated", false);
    }

    public @UnknownKeyFor @NonNull @Initialized Boolean getAllowEmptyValue() {
        return this.getBooleanOrDefault("allowEmptyValue", false);
    }

    public @UnknownKeyFor @NonNull @Initialized String getStyle() {
        String in;
        String style = this.getStringOrNull("style");
        if (style != null) {
            return style;
        }
        switch (in = this.getIn()) {
            case "query": 
            case "cookie": {
                return "form";
            }
        }
        return "simple";
    }

    public @UnknownKeyFor @NonNull @Initialized Boolean getExplode() {
        Boolean explode = this.getBooleanOrNull("explode");
        if (explode != null) {
            return explode;
        }
        String style = this.getStyle();
        return "form".equals(style);
    }

    public @UnknownKeyFor @NonNull @Initialized Boolean getAllowReserved() {
        return this.getBooleanOrDefault("allowReserved", false);
    }

    public @Nullable @UnknownKeyFor @Initialized Schema getSchema() {
        return this.getObjectOrNull("schema", Schema.class);
    }

    public @Nullable @UnknownKeyFor @Initialized Object getExample() {
        return this.getRawValue("example");
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Example> getExamples() {
        return this.getMapObjectsOrEmpty("examples", Example.class);
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized MediaType> getContent() {
        return this.getMapObjectsOrEmpty("content", MediaType.class);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> getExtensions() {
        return super.getExtensions();
    }
}

