/*
 * Decompiled with CFR 0.152.
 */
package io.openapiparser.model.v31;

import io.openapiparser.Context;
import io.openapiparser.Properties;
import io.openapiparser.converter.NoValueException;
import io.openapiparser.model.v31.Discriminator;
import io.openapiparser.model.v31.Extensions;
import io.openapiparser.model.v31.ExternalDocumentation;
import io.openapiparser.model.v31.Reference;
import io.openapiparser.model.v31.Xml;
import io.openapiparser.schema.Bucket;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Schema
extends Properties
implements Reference,
Extensions {
    public Schema(@UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized Bucket bucket) {
        super(context, bucket);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isRef() {
        return this.hasProperty("$ref");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getRef() {
        return this.getStringOrThrow("$ref");
    }

    public @UnknownKeyFor @NonNull @Initialized Schema getRefObject() {
        return this.getRefObjectOrThrow(Schema.class);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized String getSummary() {
        return this.getStringOrNull("summary");
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized String getDescription() {
        return this.getStringOrNull("description");
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Schema> getAllOf() {
        return this.getObjectsOrEmpty("allOf", Schema.class);
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Schema> getAnyOf() {
        return this.getObjectsOrEmpty("anyOf", Schema.class);
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Schema> getOneOf() {
        return this.getObjectsOrEmpty("oneOf", Schema.class);
    }

    public @Nullable @UnknownKeyFor @Initialized Schema getNot() {
        return this.getObjectOrNull("not", Schema.class);
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Schema> getPrefixItems() {
        return this.getObjectsOrEmpty("prefixItems", Schema.class);
    }

    public @Nullable @UnknownKeyFor @Initialized Schema getItems() {
        return this.getObjectOrNull("items", Schema.class);
    }

    public @Nullable @UnknownKeyFor @Initialized Schema getContains() {
        return this.getObjectOrNull("contains", Schema.class);
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Schema> getProperties() {
        return this.getMapObjectsOrEmpty("properties", Schema.class);
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Schema> getPatternProperties() {
        return this.getMapObjectsOrEmpty("patternProperties", Schema.class);
    }

    public @Nullable @UnknownKeyFor @Initialized Schema getAdditionalProperties() {
        return this.getObjectOrNull("additionalProperties", Schema.class);
    }

    public @Nullable @UnknownKeyFor @Initialized Schema getPropertyNames() {
        return this.getObjectOrNull("propertyNames", Schema.class);
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> getType() {
        Object value = this.getRawValue("type");
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof String) {
            return Collections.singletonList(this.getStringOrThrow("type"));
        }
        if (value instanceof Collection) {
            Collection<String> types = this.getStringsOrEmpty("type");
            return types.stream().map(t -> t == null ? "null" : t).collect(Collectors.toList());
        }
        throw new NoValueException("todo");
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized Collection<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> getEnum() {
        return this.getStringsOrNull("enum");
    }

    public @Nullable @UnknownKeyFor @Initialized String getConst() {
        return this.getStringOrNull("const");
    }

    public @Nullable @UnknownKeyFor @Initialized Number getMultipleOf() {
        return this.getNumberOrNull("multipleOf");
    }

    public @Nullable @UnknownKeyFor @Initialized Number getMaximum() {
        return this.getNumberOrNull("maximum");
    }

    public @UnknownKeyFor @NonNull @Initialized Boolean getExclusiveMaximum() {
        return this.getBooleanOrDefault("exclusiveMaximum", false);
    }

    public @Nullable @UnknownKeyFor @Initialized Number getMinimum() {
        return this.getNumberOrNull("minimum");
    }

    public @UnknownKeyFor @NonNull @Initialized Boolean getExclusiveMinimum() {
        return this.getBooleanOrDefault("exclusiveMinimum", false);
    }

    public @Nullable @UnknownKeyFor @Initialized Number getMaxLength() {
        return this.getNumberOrNull("maxLength");
    }

    public @Nullable @UnknownKeyFor @Initialized Number getMinLength() {
        return this.getNumberOrNull("minLength");
    }

    public @Nullable @UnknownKeyFor @Initialized String getPattern() {
        return this.getStringOrNull("pattern");
    }

    public @Nullable @UnknownKeyFor @Initialized Integer getMaxItems() {
        return this.getIntegerOrNull("maxItems");
    }

    public @UnknownKeyFor @NonNull @Initialized Integer getMinItems() {
        return this.getIntegerOrDefault("minItems", 0);
    }

    public @UnknownKeyFor @NonNull @Initialized Boolean getUniqueItems() {
        return this.getBooleanOrDefault("uniqueItems", false);
    }

    public @Nullable @UnknownKeyFor @Initialized Integer getMaxContains() {
        return this.getIntegerOrNull("maxContains");
    }

    public @UnknownKeyFor @NonNull @Initialized Integer getMinContains() {
        return this.getIntegerOrDefault("minContains", 1);
    }

    public @Nullable @UnknownKeyFor @Initialized Integer getMaxProperties() {
        return this.getIntegerOrNull("maxProperties");
    }

    public @UnknownKeyFor @NonNull @Initialized Integer getMinProperties() {
        return this.getIntegerOrDefault("minProperties", 0);
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> getRequired() {
        return this.getStringsOrEmpty("required");
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> getDependentRequired() {
        return this.getMapSetStringsOrEmpty("dependentRequired");
    }

    public @Nullable @UnknownKeyFor @Initialized String getFormat() {
        return this.getStringOrNull("format");
    }

    public @Nullable @UnknownKeyFor @Initialized String getTitle() {
        return this.getStringOrNull("title");
    }

    public @Nullable @UnknownKeyFor @Initialized Object getDefault() {
        return this.getRawValue("default");
    }

    public @UnknownKeyFor @NonNull @Initialized Boolean getDeprecated() {
        return this.getBooleanOrDefault("deprecated", false);
    }

    public @UnknownKeyFor @NonNull @Initialized Boolean getReadOnly() {
        return this.getBooleanOrDefault("readOnly", false);
    }

    public @UnknownKeyFor @NonNull @Initialized Boolean getWriteOnly() {
        return this.getBooleanOrDefault("writeOnly", false);
    }

    public @Nullable @UnknownKeyFor @Initialized Discriminator getDiscriminator() {
        return this.getObjectOrNull("discriminator", Discriminator.class);
    }

    public @Nullable @UnknownKeyFor @Initialized Xml getXml() {
        return this.getObjectOrNull("xml", Xml.class);
    }

    public @Nullable @UnknownKeyFor @Initialized ExternalDocumentation getExternalDocs() {
        return this.getObjectOrNull("externalDocs", ExternalDocumentation.class);
    }

    @Deprecated
    public @Nullable @UnknownKeyFor @Initialized Object getExample() {
        return this.getRawValue("example");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> getExtensions() {
        return super.getExtensions();
    }
}

