/*
 * Decompiled with CFR 0.152.
 */
package io.openapiparser.converter;

import io.openapiparser.Factory;
import io.openapiparser.converter.ObjectNotNullConverter;
import io.openapiprocessor.jsonschema.converter.PropertyConverter;
import io.openapiprocessor.jsonschema.converter.Types;
import io.openapiprocessor.jsonschema.schema.JsonPointer;
import io.openapiprocessor.jsonschema.schema.Scope;
import io.openapiprocessor.jsonschema.support.Nullness;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ObjectsOrEmptyConverter<@UnknownKeyFor T>
implements PropertyConverter<Collection<T>> {
    private final @UnknownKeyFor @NonNull @Initialized ObjectNotNullConverter<T> converter;

    public ObjectsOrEmptyConverter(@UnknownKeyFor @NonNull @Initialized Scope scope, @UnknownKeyFor @NonNull @Initialized Factory<T> factory) {
        this.converter = new ObjectNotNullConverter<T>(scope, factory);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable @UnknownKeyFor @Initialized Collection<T> convert(@UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized Object value, @UnknownKeyFor @NonNull @Initialized String location) {
        @NonNull Collection objects = (Collection)Types.convertOrNull((String)location, (Object)value, Collection.class);
        if (objects == null) {
            return Collections.emptyList();
        }
        JsonPointer parentPointer = JsonPointer.from((String)location);
        ArrayList<T> result = new ArrayList<T>();
        int index = 0;
        for (Object item : objects) {
            T itemObject = this.create(name, item, this.getIndexLocation(parentPointer, index));
            result.add(itemObject);
            ++index;
        }
        return Collections.unmodifiableCollection(result);
    }

    private T create(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Object item, @UnknownKeyFor @NonNull @Initialized String location) {
        return (T)Nullness.nonNull(this.converter.convert(name, item, location));
    }

    private @UnknownKeyFor @NonNull @Initialized String getIndexLocation(@UnknownKeyFor @NonNull @Initialized JsonPointer parent, @UnknownKeyFor @NonNull @Initialized int index) {
        return parent.getJsonPointer(String.valueOf(index));
    }
}

