/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.spring.processor;

import io.openapiprocessor.core.converter.ApiConverter;
import io.openapiprocessor.core.converter.ApiOptions;
import io.openapiprocessor.core.converter.OptionsConverter;
import io.openapiprocessor.core.framework.Framework;
import io.openapiprocessor.core.framework.FrameworkAnnotations;
import io.openapiprocessor.core.model.Api;
import io.openapiprocessor.core.parser.OpenApi;
import io.openapiprocessor.core.parser.OpenApiParser;
import io.openapiprocessor.core.writer.Identifier;
import io.openapiprocessor.core.writer.SourceFormatter;
import io.openapiprocessor.core.writer.WriterFactory;
import io.openapiprocessor.core.writer.java.ApiWriter;
import io.openapiprocessor.core.writer.java.BeanValidationFactory;
import io.openapiprocessor.core.writer.java.DataTypeWriter;
import io.openapiprocessor.core.writer.java.DataTypeWriterBase;
import io.openapiprocessor.core.writer.java.DataTypeWriterPojo;
import io.openapiprocessor.core.writer.java.DataTypeWriterRecord;
import io.openapiprocessor.core.writer.java.DefaultImportFilter;
import io.openapiprocessor.core.writer.java.GeneratedInfo;
import io.openapiprocessor.core.writer.java.GeneratedWriter;
import io.openapiprocessor.core.writer.java.GeneratedWriterImpl;
import io.openapiprocessor.core.writer.java.GoogleFormatter;
import io.openapiprocessor.core.writer.java.IdentifierOptions;
import io.openapiprocessor.core.writer.java.ImportFilter;
import io.openapiprocessor.core.writer.java.InterfaceDataTypeWriter;
import io.openapiprocessor.core.writer.java.InterfaceWriter;
import io.openapiprocessor.core.writer.java.JavaDocWriter;
import io.openapiprocessor.core.writer.java.JavaIdentifier;
import io.openapiprocessor.core.writer.java.MethodWriter;
import io.openapiprocessor.core.writer.java.StringEnumWriter;
import io.openapiprocessor.core.writer.java.ValidationWriter;
import io.openapiprocessor.spring.processor.ProcessingException;
import io.openapiprocessor.spring.processor.SpringFramework;
import io.openapiprocessor.spring.processor.SpringFrameworkAnnotations;
import io.openapiprocessor.spring.writer.java.AdditionalEnumWriter;
import io.openapiprocessor.spring.writer.java.MappingAnnotationWriter;
import io.openapiprocessor.spring.writer.java.ParameterAnnotationWriter;
import io.openapiprocessor.spring.writer.java.SpringWriterFactory;
import java.time.OffsetDateTime;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u000b\u0012\u0002\b\u00030\nH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00102\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u000b\u0012\u0002\b\u00030\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/openapiprocessor/spring/processor/SpringProcessor;", "", "()V", "log", "Lorg/slf4j/Logger;", "testMode", "", "convertOptions", "Lio/openapiprocessor/core/converter/ApiOptions;", "processorOptions", "", "", "createGeneratedInfo", "Lio/openapiprocessor/core/writer/java/GeneratedInfo;", "options", "enableTestMode", "", "run", "", "openapi-processor-spring"})
public final class SpringProcessor {
    @NotNull
    private final Logger log;
    private boolean testMode;

    public SpringProcessor() {
        Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.log = logger;
    }

    public final void run(@NotNull Map<String, ?> processorOptions) {
        Intrinsics.checkNotNullParameter(processorOptions, (String)"processorOptions");
        try {
            OpenApiParser parser = new OpenApiParser();
            OpenApi openapi = parser.parse(processorOptions);
            if (processorOptions.get("showWarnings") != null) {
                openapi.printWarnings();
            }
            SpringFramework framework = new SpringFramework();
            SpringFrameworkAnnotations annotations = new SpringFrameworkAnnotations();
            ApiOptions options = this.convertOptions(processorOptions);
            JavaIdentifier identifier = new JavaIdentifier(new IdentifierOptions(options.getIdentifierWordBreakFromDigitToLetter()));
            ApiConverter cv = new ApiConverter(options, (Identifier)identifier, (Framework)framework);
            Api api = cv.convert(openapi);
            SpringWriterFactory writerFactory = new SpringWriterFactory(options);
            GeneratedInfo generatedInfo = this.createGeneratedInfo(options);
            GeneratedWriterImpl generatedWriter = new GeneratedWriterImpl(generatedInfo, options);
            ValidationWriter validationWriter = new ValidationWriter(options, null, 2, null);
            BeanValidationFactory beanValidations = new BeanValidationFactory(options);
            JavaDocWriter javaDocWriter = new JavaDocWriter((Identifier)identifier);
            GoogleFormatter formatter = new GoogleFormatter();
            ApiWriter writer2 = new ApiWriter(options, (GeneratedWriter)generatedWriter, validationWriter, new InterfaceWriter(options, (GeneratedWriter)generatedWriter, new MethodWriter(options, (Identifier)identifier, (io.openapiprocessor.core.writer.java.MappingAnnotationWriter)new MappingAnnotationWriter(annotations), (io.openapiprocessor.core.writer.java.ParameterAnnotationWriter)new ParameterAnnotationWriter(annotations), beanValidations, javaDocWriter), (FrameworkAnnotations)annotations, beanValidations, (ImportFilter)new DefaultImportFilter()), (DataTypeWriter)(Intrinsics.areEqual((Object)options.getModelType(), (Object)"record") ? (DataTypeWriterBase)new DataTypeWriterRecord(options, (Identifier)identifier, (GeneratedWriter)generatedWriter, beanValidations, javaDocWriter) : (DataTypeWriterBase)new DataTypeWriterPojo(options, (Identifier)identifier, (GeneratedWriter)generatedWriter, beanValidations, javaDocWriter)), new StringEnumWriter(options, (Identifier)identifier, (GeneratedWriter)generatedWriter), new InterfaceDataTypeWriter(options, (GeneratedWriter)generatedWriter, javaDocWriter), CollectionsKt.listOf((Object)new Function3<ApiOptions, SourceFormatter, WriterFactory, Unit>((Object)new AdditionalEnumWriter()){

                public final void invoke(@NotNull ApiOptions p0, @NotNull SourceFormatter p1, @NotNull WriterFactory p2) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                    ((AdditionalEnumWriter)this.receiver).write(p0, p1, p2);
                }
            }), (SourceFormatter)formatter, (WriterFactory)writerFactory);
            writer2.write(api);
        }
        catch (Exception ex) {
            this.log.error("processing failed!", (Throwable)ex);
            throw new ProcessingException(ex);
        }
    }

    private final GeneratedInfo createGeneratedInfo(ApiOptions options) {
        String version = "2024.1";
        String date = OffsetDateTime.now().toString();
        if (!options.getGeneratedDate()) {
            date = null;
        }
        if (this.testMode) {
            version = "test";
            date = null;
        }
        return new GeneratedInfo("openapi-processor-spring", version, date, null, 8, null);
    }

    public final void enableTestMode() {
        this.testMode = true;
    }

    private final ApiOptions convertOptions(Map<String, ?> processorOptions) {
        OptionsConverter optionsConverter = new OptionsConverter(false, 1, null);
        Intrinsics.checkNotNull(processorOptions, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
        ApiOptions options = optionsConverter.convertOptions(processorOptions);
        options.validate();
        return options;
    }
}

