/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.spring.processor;

import io.openapiprocessor.api.v2.OpenApiProcessor;
import io.openapiprocessor.api.v2.OpenApiProcessorVersion;
import io.openapiprocessor.api.v2.Version;
import io.openapiprocessor.core.version.GitHubVersionException;
import io.openapiprocessor.core.version.GitHubVersionProvider;
import io.openapiprocessor.spring.processor.SpringProcessor;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0006H\u0016J\u001a\u0010\u0010\u001a\u00020\u00112\u0010\u0010\u0012\u001a\f\u0012\u0004\u0012\u00020\r\u0012\u0002\b\u00030\u0013H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/openapiprocessor/spring/processor/SpringServiceV2;", "Lio/openapiprocessor/api/v2/OpenApiProcessor;", "Lio/openapiprocessor/api/v2/OpenApiProcessorVersion;", "provider", "Lio/openapiprocessor/core/version/GitHubVersionProvider;", "testMode", "", "(Lio/openapiprocessor/core/version/GitHubVersionProvider;Z)V", "log", "Lorg/slf4j/Logger;", "getLatestVersion", "Lio/openapiprocessor/api/v2/Version;", "getName", "", "getVersion", "hasNewerVersion", "run", "", "processorOptions", "", "openapi-processor-spring"})
public final class SpringServiceV2
implements OpenApiProcessor,
OpenApiProcessorVersion {
    @NotNull
    private final GitHubVersionProvider provider;
    private final boolean testMode;
    @NotNull
    private final Logger log;

    public SpringServiceV2(@NotNull GitHubVersionProvider provider, boolean testMode) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.provider = provider;
        this.testMode = testMode;
        Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.log = logger;
    }

    public /* synthetic */ SpringServiceV2(GitHubVersionProvider gitHubVersionProvider, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            gitHubVersionProvider = new GitHubVersionProvider("openapi-processor-spring");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        this(gitHubVersionProvider, bl);
    }

    @NotNull
    public String getName() {
        return "spring";
    }

    public void run(@NotNull Map<String, ?> processorOptions) {
        Intrinsics.checkNotNullParameter(processorOptions, (String)"processorOptions");
        SpringProcessor processor = new SpringProcessor();
        if (this.testMode) {
            processor.enableTestMode();
        }
        processor.run(processorOptions);
    }

    @NotNull
    public String getVersion() {
        return "2024.1";
    }

    @NotNull
    public Version getLatestVersion() {
        return (Version)this.provider.getVersion();
    }

    public boolean hasNewerVersion() {
        try {
            String version = this.getVersion();
            Version latest = this.getLatestVersion();
            if (latest.getName().compareTo(version) > 0) {
                this.log.info("openapi-processor-spring version " + latest.getName() + " is available! I'm version " + version + ".");
                return true;
            }
            return false;
        }
        catch (GitHubVersionException ex) {
            return false;
        }
    }

    public SpringServiceV2() {
        this(null, false, 3, null);
    }
}

