/*
 * Decompiled with CFR 0.152.
 */
package io.openapitools.hal;

import io.openapitools.hal.HALProperty;
import io.openapitools.jackson.dataformat.hal.annotation.EmbeddedResource;
import io.openapitools.jackson.dataformat.hal.annotation.Link;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContext;
import io.swagger.models.Model;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

public class HALModelConverter
implements ModelConverter {
    public Model resolve(Type type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        Model model = null;
        if (chain.hasNext()) {
            model = chain.next().resolve(type, context, chain);
        }
        if (model != null && model.getProperties() != null) {
            HashMap<HALReservedProperty, ObjectProperty> properties = new HashMap<HALReservedProperty, ObjectProperty>();
            HashSet<String> originalProperties = new HashSet<String>();
            for (Map.Entry entry : model.getProperties().entrySet()) {
                if (!(entry.getValue() instanceof HALProperty)) continue;
                HALProperty property = (HALProperty)entry.getValue();
                if (!properties.containsKey((Object)property.getHALType())) {
                    properties.put(property.getHALType(), new ObjectProperty());
                }
                String name = property.getSpecificName().isEmpty() ? property.getName() : property.getSpecificName();
                ((ObjectProperty)properties.get((Object)property.getHALType())).property(name, property.getProperty());
                originalProperties.add((String)entry.getKey());
            }
            for (Map.Entry entry : properties.entrySet()) {
                model.getProperties().put(((HALReservedProperty)((Object)entry.getKey())).getName(), (Property)entry.getValue());
            }
            for (String propertyName : originalProperties) {
                model.getProperties().remove(propertyName);
            }
        }
        return model;
    }

    public Property resolveProperty(Type type, ModelConverterContext context, Annotation[] annotations, Iterator<ModelConverter> chain) {
        Property property = null;
        if (chain.hasNext()) {
            property = chain.next().resolveProperty(type, context, annotations, chain);
        }
        if (property != null && !(property instanceof HALProperty) && annotations != null) {
            for (Annotation annotation : annotations) {
                Optional<HALReservedProperty> rp = HALReservedProperty.valueOf(annotation.annotationType());
                if (!rp.isPresent()) continue;
                return new HALProperty(rp.get(), rp.get().getValue(annotation), property);
            }
        }
        return property;
    }

    public static enum HALReservedProperty {
        LINKS("_links", Link.class),
        EMBEDDED("_embedded", EmbeddedResource.class);

        private final String name;
        private final Class<? extends Annotation> annotation;
        private final Method valueMethod;

        private HALReservedProperty(String name, Class<? extends Annotation> annotation) {
            this.name = name;
            this.annotation = annotation;
            try {
                this.valueMethod = annotation.getDeclaredMethod("value", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        public String getName() {
            return this.name;
        }

        public String getValue(Annotation annotation) {
            try {
                return (String)this.valueMethod.invoke((Object)annotation, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException("Unable to get default value from annotation", e);
            }
        }

        public static Optional<HALReservedProperty> valueOf(Class<? extends Annotation> annotation) {
            for (HALReservedProperty rp : HALReservedProperty.values()) {
                if (!rp.annotation.equals(annotation)) continue;
                return Optional.of(rp);
            }
            return Optional.empty();
        }
    }
}

