/*
 * Decompiled with CFR 0.152.
 */
package io.openapitools.hal;

import io.openapitools.hal.EmbeddedNameFunction;
import io.openapitools.hal.HALResourceType;
import io.openapitools.hal.LinkNameFunction;
import io.openapitools.jackson.dataformat.hal.annotation.EmbeddedResource;
import io.openapitools.jackson.dataformat.hal.annotation.Link;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.function.BiFunction;

public class HALAnnotation<T extends Annotation> {
    public static final HALAnnotation<Link> LINKS = new HALAnnotation<Link>("_links", Link.class, new LinkNameFunction());
    public static final HALAnnotation<EmbeddedResource> EMBEDDED = new HALAnnotation<EmbeddedResource>("_embedded", EmbeddedResource.class, new EmbeddedNameFunction());
    private final String name;
    private final Class<T> annotation;
    private final BiFunction<HALResourceType, T, Optional<String>> nameFunction;

    private HALAnnotation(String name, Class<T> annotation, BiFunction<HALResourceType, T, Optional<String>> nameFunction) {
        this.name = name;
        this.annotation = annotation;
        this.nameFunction = nameFunction;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getAnnotation() {
        return this.annotation;
    }

    public String deriveName(HALResourceType parent, T annotation, String property) {
        Optional<String> name = this.nameFunction.apply(parent, (HALResourceType)annotation);
        return name.orElse(property);
    }
}

