/*
 * Decompiled with CFR 0.152.
 */
package io.openapitools.hal;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.util.Annotations;
import io.openapitools.jackson.dataformat.hal.annotation.Resource;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Optional;

public class HALResourceType {
    private final BeanDescription description;

    public HALResourceType(BeanDescription description) {
        this.description = description;
    }

    public boolean isHALResource() {
        return this.description.getClassAnnotations().has(Resource.class);
    }

    public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationClass) {
        Annotations annotations = this.description.getClassAnnotations();
        if (annotations.has(annotationClass)) {
            return Optional.of(annotations.get(annotationClass));
        }
        return Optional.empty();
    }

    public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationClass, String property) {
        Optional<Annotation> annotation = this.description.findProperties().stream().filter(p -> property.equals(p.getName())).map(p -> p.getField().getAnnotation(annotationClass)).filter(Objects::nonNull).findAny();
        if (annotation.isPresent()) {
            return annotation;
        }
        return this.description.findProperties().stream().filter(p -> property.equals(p.getName())).map(p -> p.getGetter().getAnnotation(annotationClass)).filter(Objects::nonNull).findAny();
    }
}

