/*
 * Decompiled with CFR 0.152.
 */
package io.openapitools.swagger.config;

import io.openapitools.swagger.config.SwaggerInfo;
import io.openapitools.swagger.config.SwaggerServer;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.Parameter;

public class SwaggerConfig {
    @Parameter
    private List<SwaggerServer> servers = Collections.emptyList();
    @Parameter
    private SwaggerInfo info;
    @Parameter
    private File descriptionFile;

    public OpenAPI createSwaggerModel() {
        OpenAPI spec = new OpenAPI();
        this.servers.forEach(s -> spec.addServersItem(s.createServerModel()));
        if (this.info != null) {
            spec.setInfo(this.info.createInfoModel());
        }
        if (this.descriptionFile != null) {
            if (spec.getInfo() == null) {
                spec.setInfo(new Info());
            }
            try {
                spec.getInfo().setDescription(Files.readAllLines(this.descriptionFile.toPath()).stream().collect(Collectors.joining("\n")));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read descriptor file " + this.descriptionFile, e);
            }
        }
        return spec;
    }
}

