/*
 * Decompiled with CFR 0.152.
 */
package io.openapitools.swagger;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.io.IOException;

public enum OutputFormat {
    JSON(new JSONWriter()),
    YAML(new YAMLWriter());

    private final SwaggerWriter writer;

    private OutputFormat(SwaggerWriter writer) {
        this.writer = writer;
    }

    public void write(OpenAPI swagger, File file, boolean prettyPrint) throws IOException {
        this.writer.write(swagger, file, prettyPrint);
    }

    @FunctionalInterface
    static interface SwaggerWriter {
        public void write(OpenAPI var1, File var2, boolean var3) throws IOException;
    }

    static class JSONWriter
    implements SwaggerWriter {
        JSONWriter() {
        }

        @Override
        public void write(OpenAPI swagger, File file, boolean prettyPrint) throws IOException {
            ObjectMapper mapper = Json.mapper();
            if (prettyPrint) {
                mapper.enable(SerializationFeature.INDENT_OUTPUT);
            }
            mapper.writeValue(file, (Object)swagger);
        }
    }

    static class YAMLWriter
    implements SwaggerWriter {
        YAMLWriter() {
        }

        @Override
        public void write(OpenAPI swagger, File file, boolean prettyPrint) throws IOException {
            Yaml.mapper().writeValue(file, (Object)swagger);
        }
    }
}

