/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.trace;

import io.grpc.Context;
import io.opencensus.common.Scope;
import io.opencensus.trace.Span;
import io.opencensus.trace.unsafe.ContextUtils;

final class CurrentSpanUtils {
    private CurrentSpanUtils() {
    }

    static Span getCurrentSpan() {
        return (Span)ContextUtils.CONTEXT_SPAN_KEY.get();
    }

    static Scope withSpan(Span span, boolean endSpan) {
        return new ScopeInSpan(span, endSpan);
    }

    private static final class ScopeInSpan
    implements Scope {
        private final Context origContext;
        private final Span span;
        private boolean endSpan;

        ScopeInSpan(Span span, boolean endSpan) {
            this.span = span;
            this.endSpan = endSpan;
            this.origContext = Context.current().withValue(ContextUtils.CONTEXT_SPAN_KEY, (Object)span).attach();
        }

        @Override
        public void close() {
            Context.current().detach(this.origContext);
            if (this.endSpan) {
                this.span.end();
            }
        }
    }
}

