/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.http.jaxrs;

import io.opencensus.contrib.http.HttpClientHandler;
import io.opencensus.contrib.http.HttpExtractor;
import io.opencensus.contrib.http.HttpRequestContext;
import io.opencensus.contrib.http.jaxrs.JaxrsClientExtractor;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.propagation.TextFormat;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.ext.Provider;

@Provider
public class JaxrsClientFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private static final String OPENCENSUS_CONTEXT = "opencensus.context";
    private static final TextFormat.Setter<ClientRequestContext> SETTER = new TextFormat.Setter<ClientRequestContext>(){

        public void put(ClientRequestContext carrier, String key, String value) {
            carrier.getHeaders().putSingle((Object)key, (Object)value);
        }
    };
    private final HttpClientHandler<ClientRequestContext, ClientResponseContext, ClientRequestContext> handler;

    public JaxrsClientFilter() {
        this(new JaxrsClientExtractor(), Tracing.getPropagationComponent().getTraceContextFormat());
    }

    public JaxrsClientFilter(HttpExtractor<ClientRequestContext, ClientResponseContext> extractor, TextFormat propagationFormat) {
        this.handler = new HttpClientHandler(Tracing.getTracer(), extractor, propagationFormat, SETTER);
    }

    public void filter(ClientRequestContext requestContext) {
        HttpRequestContext context = this.handler.handleStart(null, (Object)requestContext, (Object)requestContext);
        requestContext.setProperty(OPENCENSUS_CONTEXT, (Object)context);
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) {
        HttpRequestContext context = (HttpRequestContext)requestContext.getProperty(OPENCENSUS_CONTEXT);
        this.handler.handleEnd(context, (Object)requestContext, (Object)responseContext, null);
    }
}

