/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.http.jaxrs;

import io.opencensus.contrib.http.HttpExtractor;
import io.opencensus.contrib.http.jaxrs.ExtendedContainerRequest;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import javax.ws.rs.Path;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ResourceInfo;

public class JaxrsContainerExtractor
extends HttpExtractor<ExtendedContainerRequest, ContainerResponseContext> {
    @Nullable
    public String getRoute(ExtendedContainerRequest request) {
        return JaxrsContainerExtractor.resolveRoute(request.getResourceInfo());
    }

    @Nullable
    public String getUrl(ExtendedContainerRequest request) {
        return request.getRequestContext().getUriInfo().getRequestUri().toString();
    }

    @Nullable
    public String getHost(ExtendedContainerRequest request) {
        return request.getRequestContext().getHeaderString("host");
    }

    @Nullable
    public String getMethod(ExtendedContainerRequest request) {
        return request.getRequestContext().getMethod();
    }

    @Nullable
    public String getPath(ExtendedContainerRequest request) {
        return request.getRequestContext().getUriInfo().getPath();
    }

    @Nullable
    public String getUserAgent(ExtendedContainerRequest request) {
        return request.getRequestContext().getHeaderString("user-agent");
    }

    public int getStatusCode(@Nullable ContainerResponseContext response) {
        return response != null ? response.getStatus() : 0;
    }

    @Nullable
    private static String resolveRoute(ResourceInfo info) {
        Method m;
        StringBuilder path = new StringBuilder();
        Class c = info.getResourceClass();
        if (c != null && c.isAnnotationPresent(Path.class)) {
            Path p = c.getAnnotation(Path.class);
            path.append(p.value());
        }
        if ((m = info.getResourceMethod()) != null && m.isAnnotationPresent(Path.class)) {
            Path p = m.getAnnotation(Path.class);
            if (!JaxrsContainerExtractor.endsWithSlash(path) && !p.value().startsWith("/")) {
                path.append("/");
            }
            if (JaxrsContainerExtractor.endsWithSlash(path) && p.value().startsWith("/")) {
                path.deleteCharAt(path.lastIndexOf("/"));
            }
            path.append(p.value());
        }
        return path.length() == 0 ? null : path.toString();
    }

    private static boolean endsWithSlash(StringBuilder path) {
        return path.lastIndexOf("/") == path.length() - 1;
    }
}

