/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.http.jaxrs;

import io.opencensus.common.Scope;
import io.opencensus.contrib.http.HttpExtractor;
import io.opencensus.contrib.http.HttpRequestContext;
import io.opencensus.contrib.http.HttpServerHandler;
import io.opencensus.contrib.http.jaxrs.ExtendedContainerRequest;
import io.opencensus.contrib.http.jaxrs.JaxrsContainerExtractor;
import io.opencensus.contrib.http.jaxrs.Metrics;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.propagation.TextFormat;
import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;

@Metrics
@Provider
@Priority(value=4900)
public class JaxrsContainerFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final String CONTEXT_PROPERTY = "opencensus.context";
    private static final String SPAN_PROPERTY = "opencensus.span";
    private static final TextFormat.Getter<ContainerRequestContext> GETTER = new TextFormat.Getter<ContainerRequestContext>(){

        public String get(ContainerRequestContext request, String key) {
            return request.getHeaderString(key);
        }
    };
    private final HttpServerHandler<ExtendedContainerRequest, ContainerResponseContext, ContainerRequestContext> handler;
    @Context
    private ResourceInfo info;

    public JaxrsContainerFilter() {
        this(new JaxrsContainerExtractor(), Tracing.getPropagationComponent().getTraceContextFormat(), true);
    }

    public JaxrsContainerFilter(HttpExtractor<ExtendedContainerRequest, ContainerResponseContext> extractor, TextFormat propagationFormat, Boolean publicEndpoint) {
        this.handler = new HttpServerHandler(Tracing.getTracer(), extractor, propagationFormat, GETTER, publicEndpoint);
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        ExtendedContainerRequest extendedRequest = new ExtendedContainerRequest(requestContext, this.info);
        HttpRequestContext context = this.handler.handleStart((Object)requestContext, (Object)extendedRequest);
        requestContext.setProperty(CONTEXT_PROPERTY, (Object)context);
        if (requestContext.getLength() > 0) {
            this.handler.handleMessageReceived(context, (long)requestContext.getLength());
        }
        requestContext.setProperty(SPAN_PROPERTY, (Object)Tracing.getTracer().withSpan(this.handler.getSpanFromContext(context)));
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        HttpRequestContext context = (HttpRequestContext)requestContext.getProperty(CONTEXT_PROPERTY);
        if (context == null) {
            return;
        }
        Scope scope = (Scope)requestContext.getProperty(SPAN_PROPERTY);
        if (scope != null) {
            scope.close();
        }
        if (responseContext.getLength() > 0) {
            this.handler.handleMessageSent(context, (long)responseContext.getLength());
        }
        ExtendedContainerRequest extendedRequest = new ExtendedContainerRequest(requestContext, this.info);
        this.handler.handleEnd(context, (Object)extendedRequest, (Object)responseContext, null);
    }
}

