/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.http.jetty.client;

import com.google.common.annotations.VisibleForTesting;
import io.opencensus.contrib.http.HttpClientHandler;
import io.opencensus.contrib.http.HttpRequestContext;
import io.opencensus.trace.Span;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;

public final class HttpRequestListener
implements Request.Listener,
Response.ContentListener,
Response.CompleteListener {
    private final Span parent;
    @VisibleForTesting
    final HttpClientHandler<Request, Response, Request> handler;
    @Nullable
    @VisibleForTesting
    HttpRequestContext context;

    HttpRequestListener(Span parent, HttpClientHandler<Request, Response, Request> handler) {
        this.parent = parent;
        this.handler = handler;
        this.context = null;
    }

    public void onComplete(Result result) {
        if (this.context == null) {
            return;
        }
        if (result != null) {
            this.handler.handleEnd(this.context, (Object)result.getRequest(), (Object)result.getResponse(), result.getFailure());
        } else {
            this.handler.handleEnd(this.context, null, null, null);
        }
    }

    public void onBegin(Request request) {
        this.context = this.handler.handleStart(this.parent, (Object)request, (Object)request);
    }

    public void onContent(Request request, ByteBuffer content) {
        if (this.context != null) {
            this.handler.handleMessageSent(this.context, (long)content.capacity());
        }
    }

    public void onContent(Response response, ByteBuffer content) {
        if (this.context != null) {
            this.handler.handleMessageReceived(this.context, (long)content.capacity());
        }
    }

    public void onCommit(Request request) {
    }

    public void onFailure(Request request, Throwable failure) {
    }

    public void onHeaders(Request request) {
    }

    public void onQueued(Request request) {
    }

    public void onSuccess(Request request) {
    }
}

