/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.http.jetty.client;

import com.google.common.annotations.VisibleForTesting;
import io.opencensus.contrib.http.HttpClientHandler;
import io.opencensus.contrib.http.HttpExtractor;
import io.opencensus.contrib.http.jetty.client.HttpRequestListener;
import io.opencensus.contrib.http.jetty.client.OcJettyHttpClientExtractor;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.propagation.TextFormat;
import java.net.URI;
import javax.annotation.Nullable;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public final class OcJettyHttpClient
extends HttpClient {
    private static final TextFormat.Setter<Request> setter = new TextFormat.Setter<Request>(){

        public void put(Request carrier, String key, String value) {
            carrier.header(key, value);
        }
    };
    private static final Tracer tracer = Tracing.getTracer();
    @VisibleForTesting
    final HttpClientHandler<Request, Response, Request> handler;

    public OcJettyHttpClient() {
        this.handler = OcJettyHttpClient.buildHandler(null, null);
    }

    public OcJettyHttpClient(HttpClientTransport transport, SslContextFactory sslContextFactory, @Nullable HttpExtractor<Request, Response> extractor, @Nullable TextFormat propagator) {
        super(transport, sslContextFactory);
        this.handler = OcJettyHttpClient.buildHandler(extractor, propagator);
    }

    private static HttpClientHandler<Request, Response, Request> buildHandler(@Nullable HttpExtractor<Request, Response> extractor, @Nullable TextFormat propagator) {
        if (extractor == null) {
            extractor = new OcJettyHttpClientExtractor();
        }
        if (propagator == null) {
            propagator = Tracing.getPropagationComponent().getTraceContextFormat();
        }
        return new HttpClientHandler(Tracing.getTracer(), (HttpExtractor)extractor, propagator, setter);
    }

    public Request newRequest(URI uri) {
        Request request = super.newRequest(uri);
        HttpRequestListener listener = new HttpRequestListener(tracer.getCurrentSpan(), this.handler);
        request.listener((Request.Listener)listener);
        request.onComplete((Response.CompleteListener)listener);
        request.onResponseContent((Response.ContentListener)listener);
        return request;
    }
}

