/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.http.jetty.client;

import io.opencensus.contrib.http.HttpExtractor;
import java.net.MalformedURLException;
import javax.annotation.Nullable;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;

final class OcJettyHttpClientExtractor
extends HttpExtractor<Request, Response> {
    OcJettyHttpClientExtractor() {
    }

    public String getHost(Request request) {
        return request.getHost();
    }

    public String getMethod(Request request) {
        return request.getMethod();
    }

    public String getPath(Request request) {
        return request.getPath();
    }

    public String getUserAgent(Request request) {
        return request.getHeaders().get("User-Agent");
    }

    public int getStatusCode(@Nullable Response response) {
        if (response != null) {
            return response.getStatus();
        }
        return 0;
    }

    public String getRoute(Request request) {
        return "";
    }

    public String getUrl(Request request) {
        try {
            return request.getURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            return "";
        }
    }
}

