/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.resource.util;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.opencensus.contrib.resource.util.GcpMetadataConfig;
import io.opencensus.resource.Resource;
import java.util.LinkedHashMap;

public class K8sResource {
    public static final String TYPE = "k8s";
    public static final String CLUSTER_NAME_KEY = "k8s.cluster.name";
    public static final String NAMESPACE_NAME_KEY = "k8s.namespace.name";
    public static final String POD_NAME_KEY = "k8s.pod.name";

    public static Resource create(String clusterName, String namespace, String podName) {
        LinkedHashMap<String, Object> labels = new LinkedHashMap<String, Object>();
        labels.put(CLUSTER_NAME_KEY, Preconditions.checkNotNull((Object)clusterName, (Object)"clusterName"));
        labels.put(NAMESPACE_NAME_KEY, Preconditions.checkNotNull((Object)namespace, (Object)"namespace"));
        labels.put(POD_NAME_KEY, Preconditions.checkNotNull((Object)podName, (Object)"podName"));
        return Resource.create((String)TYPE, labels);
    }

    static Resource detect() {
        return K8sResource.create(GcpMetadataConfig.getClusterName(), (String)MoreObjects.firstNonNull((Object)System.getenv("NAMESPACE"), (Object)""), (String)MoreObjects.firstNonNull((Object)System.getenv("HOSTNAME"), (Object)""));
    }

    private K8sResource() {
    }
}

