/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.stats.stackdriver;

import com.google.api.Distribution;
import com.google.api.LabelDescriptor;
import com.google.api.Metric;
import com.google.api.MetricDescriptor;
import com.google.api.MonitoredResource;
import com.google.cloud.MetadataConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.monitoring.v3.Point;
import com.google.monitoring.v3.TimeInterval;
import com.google.monitoring.v3.TimeSeries;
import com.google.monitoring.v3.TypedValue;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import io.opencensus.common.Function;
import io.opencensus.common.Functions;
import io.opencensus.common.Timestamp;
import io.opencensus.contrib.exemplar.util.AttachmentValueSpanContext;
import io.opencensus.contrib.resource.util.ResourceUtils;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import io.opencensus.metrics.data.AttachmentValue;
import io.opencensus.metrics.data.Exemplar;
import io.opencensus.metrics.export.Distribution;
import io.opencensus.metrics.export.MetricDescriptor;
import io.opencensus.metrics.export.Summary;
import io.opencensus.metrics.export.TimeSeries;
import io.opencensus.metrics.export.Value;
import io.opencensus.resource.Resource;
import io.opencensus.trace.SpanContext;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class StackdriverExportUtils {
    @VisibleForTesting
    static final String OPENCENSUS_TASK = "opencensus_task";
    @VisibleForTesting
    static final String OPENCENSUS_TASK_DESCRIPTION = "Opencensus task identifier";
    @VisibleForTesting
    static final String STACKDRIVER_PROJECT_ID_KEY = "project_id";
    @VisibleForTesting
    static final String DEFAULT_DISPLAY_NAME_PREFIX = "OpenCensus/";
    @VisibleForTesting
    static final String CUSTOM_METRIC_DOMAIN = "custom.googleapis.com/";
    @VisibleForTesting
    static final String CUSTOM_OPENCENSUS_DOMAIN = "custom.googleapis.com/opencensus/";
    @VisibleForTesting
    static final int MAX_BATCH_EXPORT_SIZE = 200;
    private static final String K8S_CONTAINER = "k8s_container";
    private static final String GCP_GCE_INSTANCE = "gce_instance";
    private static final String AWS_EC2_INSTANCE = "aws_ec2_instance";
    private static final String GLOBAL = "global";
    @VisibleForTesting
    static final String AWS_REGION_VALUE_PREFIX = "aws:";
    private static final Logger logger = Logger.getLogger(StackdriverExportUtils.class.getName());
    private static final String OPENCENSUS_TASK_VALUE_DEFAULT = StackdriverExportUtils.generateDefaultTaskValue();
    private static final Map<String, String> GCP_RESOURCE_MAPPING = StackdriverExportUtils.getGcpResourceLabelsMappings();
    private static final Map<String, String> K8S_RESOURCE_MAPPING = StackdriverExportUtils.getK8sResourceLabelsMappings();
    private static final Map<String, String> AWS_RESOURCE_MAPPING = StackdriverExportUtils.getAwsResourceLabelsMappings();
    @VisibleForTesting
    static final LabelKey PERCENTILE_LABEL_KEY = LabelKey.create((String)"percentile", (String)"the value at a given percentile of a distribution");
    @VisibleForTesting
    static final String SNAPSHOT_SUFFIX_PERCENTILE = "_summary_snapshot_percentile";
    @VisibleForTesting
    static final String SUMMARY_SUFFIX_COUNT = "_summary_count";
    @VisibleForTesting
    static final String SUMMARY_SUFFIX_SUM = "_summary_sum";
    @Nullable
    private static volatile String cachedProjectIdForExemplar = null;
    @VisibleForTesting
    static final String EXEMPLAR_ATTACHMENT_TYPE_STRING = "type.googleapis.com/google.protobuf.StringValue";
    @VisibleForTesting
    static final String EXEMPLAR_ATTACHMENT_TYPE_SPAN_CONTEXT = "type.googleapis.com/google.monitoring.v3.SpanContext";
    private static final Function<Double, TypedValue> typedValueDoubleFunction = new Function<Double, TypedValue>(){

        public TypedValue apply(Double arg) {
            TypedValue.Builder builder = TypedValue.newBuilder();
            builder.setDoubleValue(arg.doubleValue());
            return builder.build();
        }
    };
    private static final Function<Long, TypedValue> typedValueLongFunction = new Function<Long, TypedValue>(){

        public TypedValue apply(Long arg) {
            TypedValue.Builder builder = TypedValue.newBuilder();
            builder.setInt64Value(arg.longValue());
            return builder.build();
        }
    };
    private static final Function<io.opencensus.metrics.export.Distribution, TypedValue> typedValueDistributionFunction = new Function<io.opencensus.metrics.export.Distribution, TypedValue>(){

        public TypedValue apply(io.opencensus.metrics.export.Distribution arg) {
            TypedValue.Builder builder = TypedValue.newBuilder();
            return builder.setDistributionValue(StackdriverExportUtils.createDistribution(arg)).build();
        }
    };
    private static final Function<Summary, TypedValue> typedValueSummaryFunction = new Function<Summary, TypedValue>(){

        public TypedValue apply(Summary arg) {
            TypedValue.Builder builder = TypedValue.newBuilder();
            return builder.build();
        }
    };
    private static final Function<Distribution.BucketOptions.ExplicitOptions, Distribution.BucketOptions> bucketOptionsExplicitFunction = new Function<Distribution.BucketOptions.ExplicitOptions, Distribution.BucketOptions>(){

        public Distribution.BucketOptions apply(Distribution.BucketOptions.ExplicitOptions arg) {
            Distribution.BucketOptions.Builder builder = Distribution.BucketOptions.newBuilder();
            Distribution.BucketOptions.Explicit.Builder explicitBuilder = Distribution.BucketOptions.Explicit.newBuilder();
            explicitBuilder.addBounds(0.0);
            explicitBuilder.addAllBounds((Iterable)arg.getBucketBoundaries());
            builder.setExplicitBuckets(explicitBuilder.build());
            return builder.build();
        }
    };

    private static String generateDefaultTaskValue() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        if (jvmName.indexOf(64) < 1) {
            String hostname = "localhost";
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                logger.log(Level.INFO, "Unable to get the hostname.", e);
            }
            return "java-" + new SecureRandom().nextInt() + "@" + hostname;
        }
        return "java-" + jvmName;
    }

    static com.google.api.MetricDescriptor createMetricDescriptor(MetricDescriptor metricDescriptor, String projectId, String domain, String displayNamePrefix) {
        MetricDescriptor.Builder builder = com.google.api.MetricDescriptor.newBuilder();
        String type = StackdriverExportUtils.generateType(metricDescriptor.getName(), domain);
        builder.setName("projects/" + projectId + "/metricDescriptors/" + type);
        builder.setType(type);
        builder.setDescription(metricDescriptor.getDescription());
        builder.setDisplayName(StackdriverExportUtils.createDisplayName(metricDescriptor.getName(), displayNamePrefix));
        for (LabelKey labelKey : metricDescriptor.getLabelKeys()) {
            builder.addLabels(StackdriverExportUtils.createLabelDescriptor(labelKey));
        }
        builder.addLabels(LabelDescriptor.newBuilder().setKey(OPENCENSUS_TASK).setDescription(OPENCENSUS_TASK_DESCRIPTION).setValueType(LabelDescriptor.ValueType.STRING).build());
        builder.setUnit(metricDescriptor.getUnit());
        builder.setMetricKind(StackdriverExportUtils.createMetricKind(metricDescriptor.getType()));
        builder.setValueType(StackdriverExportUtils.createValueType(metricDescriptor.getType()));
        return builder.build();
    }

    private static String generateType(String metricName, String domain) {
        return domain + metricName;
    }

    private static String createDisplayName(String metricName, String displayNamePrefix) {
        return displayNamePrefix + metricName;
    }

    @VisibleForTesting
    static LabelDescriptor createLabelDescriptor(LabelKey labelKey) {
        LabelDescriptor.Builder builder = LabelDescriptor.newBuilder();
        builder.setKey(labelKey.getKey());
        builder.setDescription(labelKey.getDescription());
        builder.setValueType(LabelDescriptor.ValueType.STRING);
        return builder.build();
    }

    @VisibleForTesting
    static MetricDescriptor.MetricKind createMetricKind(MetricDescriptor.Type type) {
        if (type == MetricDescriptor.Type.GAUGE_INT64 || type == MetricDescriptor.Type.GAUGE_DOUBLE) {
            return MetricDescriptor.MetricKind.GAUGE;
        }
        if (type == MetricDescriptor.Type.CUMULATIVE_INT64 || type == MetricDescriptor.Type.CUMULATIVE_DOUBLE || type == MetricDescriptor.Type.CUMULATIVE_DISTRIBUTION) {
            return MetricDescriptor.MetricKind.CUMULATIVE;
        }
        return MetricDescriptor.MetricKind.UNRECOGNIZED;
    }

    @VisibleForTesting
    static MetricDescriptor.ValueType createValueType(MetricDescriptor.Type type) {
        if (type == MetricDescriptor.Type.CUMULATIVE_DOUBLE || type == MetricDescriptor.Type.GAUGE_DOUBLE) {
            return MetricDescriptor.ValueType.DOUBLE;
        }
        if (type == MetricDescriptor.Type.GAUGE_INT64 || type == MetricDescriptor.Type.CUMULATIVE_INT64) {
            return MetricDescriptor.ValueType.INT64;
        }
        if (type == MetricDescriptor.Type.GAUGE_DISTRIBUTION || type == MetricDescriptor.Type.CUMULATIVE_DISTRIBUTION) {
            return MetricDescriptor.ValueType.DISTRIBUTION;
        }
        return MetricDescriptor.ValueType.UNRECOGNIZED;
    }

    static List<com.google.monitoring.v3.TimeSeries> createTimeSeriesList(io.opencensus.metrics.export.Metric metric, MonitoredResource monitoredResource, String domain, String projectId) {
        ArrayList timeSeriesList = Lists.newArrayList();
        MetricDescriptor metricDescriptor = metric.getMetricDescriptor();
        if (!projectId.equals(cachedProjectIdForExemplar)) {
            cachedProjectIdForExemplar = projectId;
        }
        TimeSeries.Builder shared = com.google.monitoring.v3.TimeSeries.newBuilder();
        shared.setMetricKind(StackdriverExportUtils.createMetricKind(metricDescriptor.getType()));
        shared.setResource(monitoredResource);
        shared.setValueType(StackdriverExportUtils.createValueType(metricDescriptor.getType()));
        for (TimeSeries timeSeries : metric.getTimeSeriesList()) {
            TimeSeries.Builder builder = shared.clone();
            builder.setMetric(StackdriverExportUtils.createMetric(metricDescriptor, timeSeries.getLabelValues(), domain));
            Timestamp startTimeStamp = timeSeries.getStartTimestamp();
            for (io.opencensus.metrics.export.Point point : timeSeries.getPoints()) {
                builder.addPoints(StackdriverExportUtils.createPoint(point, startTimeStamp));
            }
            timeSeriesList.add(builder.build());
        }
        return timeSeriesList;
    }

    @VisibleForTesting
    static Metric createMetric(MetricDescriptor metricDescriptor, List<LabelValue> labelValues, String domain) {
        Metric.Builder builder = Metric.newBuilder();
        builder.setType(StackdriverExportUtils.generateType(metricDescriptor.getName(), domain));
        HashMap stringTagMap = Maps.newHashMap();
        List labelKeys = metricDescriptor.getLabelKeys();
        for (int i = 0; i < labelValues.size(); ++i) {
            String value = labelValues.get(i).getValue();
            if (value == null) continue;
            stringTagMap.put(((LabelKey)labelKeys.get(i)).getKey(), value);
        }
        stringTagMap.put(OPENCENSUS_TASK, OPENCENSUS_TASK_VALUE_DEFAULT);
        builder.putAllLabels((Map)stringTagMap);
        return builder.build();
    }

    @VisibleForTesting
    static Point createPoint(io.opencensus.metrics.export.Point point, @Nullable Timestamp startTimestamp) {
        TimeInterval.Builder timeIntervalBuilder = TimeInterval.newBuilder();
        timeIntervalBuilder.setEndTime(StackdriverExportUtils.convertTimestamp(point.getTimestamp()));
        if (startTimestamp != null) {
            timeIntervalBuilder.setStartTime(StackdriverExportUtils.convertTimestamp(startTimestamp));
        }
        Point.Builder builder = Point.newBuilder();
        builder.setInterval(timeIntervalBuilder.build());
        builder.setValue(StackdriverExportUtils.createTypedValue(point.getValue()));
        return builder.build();
    }

    @VisibleForTesting
    static TypedValue createTypedValue(Value value) {
        return (TypedValue)value.match(typedValueDoubleFunction, typedValueLongFunction, typedValueDistributionFunction, typedValueSummaryFunction, Functions.throwIllegalArgumentException());
    }

    @VisibleForTesting
    static Distribution createDistribution(io.opencensus.metrics.export.Distribution distribution) {
        Distribution.Builder builder = Distribution.newBuilder().setBucketOptions(StackdriverExportUtils.createBucketOptions(distribution.getBucketOptions())).setCount(distribution.getCount()).setMean(distribution.getCount() == 0L ? 0.0 : distribution.getSum() / (double)distribution.getCount()).setSumOfSquaredDeviation(distribution.getSumOfSquaredDeviations());
        StackdriverExportUtils.setBucketCountsAndExemplars(distribution.getBuckets(), builder);
        return builder.build();
    }

    @VisibleForTesting
    static Distribution.BucketOptions createBucketOptions(@Nullable Distribution.BucketOptions bucketOptions) {
        Distribution.BucketOptions.Builder builder = Distribution.BucketOptions.newBuilder();
        if (bucketOptions == null) {
            return builder.build();
        }
        return (Distribution.BucketOptions)bucketOptions.match(bucketOptionsExplicitFunction, Functions.throwIllegalArgumentException());
    }

    private static void setBucketCountsAndExemplars(List<Distribution.Bucket> buckets, Distribution.Builder builder) {
        builder.addBucketCounts(0L);
        for (Distribution.Bucket bucket : buckets) {
            builder.addBucketCounts(bucket.getCount());
            Exemplar exemplar = bucket.getExemplar();
            if (exemplar == null) continue;
            builder.addExemplars(StackdriverExportUtils.toProtoExemplar(exemplar));
        }
    }

    private static Distribution.Exemplar toProtoExemplar(Exemplar exemplar) {
        Distribution.Exemplar.Builder builder = Distribution.Exemplar.newBuilder().setValue(exemplar.getValue()).setTimestamp(StackdriverExportUtils.convertTimestamp(exemplar.getTimestamp()));
        SpanContext spanContext = null;
        for (Map.Entry attachment : exemplar.getAttachments().entrySet()) {
            String key = (String)attachment.getKey();
            AttachmentValue value = (AttachmentValue)attachment.getValue();
            if ("SpanContext".equals(key)) {
                spanContext = ((AttachmentValueSpanContext)value).getSpanContext();
                continue;
            }
            builder.addAttachments(StackdriverExportUtils.toProtoStringAttachment(value));
        }
        if (spanContext != null && cachedProjectIdForExemplar != null) {
            com.google.monitoring.v3.SpanContext protoSpanContext = StackdriverExportUtils.toProtoSpanContext(spanContext, cachedProjectIdForExemplar);
            builder.addAttachments(StackdriverExportUtils.toProtoSpanContextAttachment(protoSpanContext));
        }
        return builder.build();
    }

    private static Any toProtoStringAttachment(AttachmentValue attachmentValue) {
        return Any.newBuilder().setTypeUrl(EXEMPLAR_ATTACHMENT_TYPE_STRING).setValue(ByteString.copyFromUtf8((String)attachmentValue.getValue())).build();
    }

    private static Any toProtoSpanContextAttachment(com.google.monitoring.v3.SpanContext protoSpanContext) {
        return Any.newBuilder().setTypeUrl(EXEMPLAR_ATTACHMENT_TYPE_SPAN_CONTEXT).setValue(protoSpanContext.toByteString()).build();
    }

    private static com.google.monitoring.v3.SpanContext toProtoSpanContext(SpanContext spanContext, String projectId) {
        String spanName = String.format("projects/%s/traces/%s/spans/%s", projectId, spanContext.getTraceId().toLowerBase16(), spanContext.getSpanId().toLowerBase16());
        return com.google.monitoring.v3.SpanContext.newBuilder().setSpanName(spanName).build();
    }

    @VisibleForTesting
    static void setCachedProjectIdForExemplar(@Nullable String projectId) {
        cachedProjectIdForExemplar = projectId;
    }

    @VisibleForTesting
    static com.google.protobuf.Timestamp convertTimestamp(Timestamp censusTimestamp) {
        if (censusTimestamp.getSeconds() < 0L) {
            return com.google.protobuf.Timestamp.newBuilder().build();
        }
        return com.google.protobuf.Timestamp.newBuilder().setSeconds(censusTimestamp.getSeconds()).setNanos(censusTimestamp.getNanos()).build();
    }

    static MonitoredResource getDefaultResource() {
        Resource autoDetectedResource;
        MonitoredResource.Builder builder = MonitoredResource.newBuilder();
        if (MetadataConfig.getProjectId() != null) {
            builder.putLabels(STACKDRIVER_PROJECT_ID_KEY, MetadataConfig.getProjectId());
        }
        if ((autoDetectedResource = ResourceUtils.detectResource()) == null || autoDetectedResource.getType() == null) {
            builder.setType(GLOBAL);
            return builder.build();
        }
        StackdriverExportUtils.setResourceForBuilder(builder, autoDetectedResource);
        return builder.build();
    }

    @VisibleForTesting
    static void setResourceForBuilder(MonitoredResource.Builder builder, Resource autoDetectedResource) {
        String type = autoDetectedResource.getType();
        if (type == null) {
            return;
        }
        String sdType = GLOBAL;
        Map<String, String> mappings = null;
        if ("host".equals(type)) {
            String provider = (String)autoDetectedResource.getLabels().get("cloud.provider");
            if ("gcp".equals(provider)) {
                sdType = GCP_GCE_INSTANCE;
                mappings = GCP_RESOURCE_MAPPING;
            } else if ("aws".equals(provider)) {
                sdType = AWS_EC2_INSTANCE;
                mappings = AWS_RESOURCE_MAPPING;
            }
        } else if ("container".equals(type)) {
            sdType = K8S_CONTAINER;
            mappings = K8S_RESOURCE_MAPPING;
        }
        builder.setType(sdType);
        if (GLOBAL.equals(sdType) || mappings == null) {
            return;
        }
        Map resLabels = autoDetectedResource.getLabels();
        for (Map.Entry<String, String> entry : mappings.entrySet()) {
            if (entry.getValue() == null || !resLabels.containsKey(entry.getValue())) continue;
            String resourceLabelKey = entry.getKey();
            String resourceLabelValue = (String)resLabels.get(entry.getValue());
            if (AWS_EC2_INSTANCE.equals(sdType) && "region".equals(resourceLabelKey)) {
                resourceLabelValue = AWS_REGION_VALUE_PREFIX + resourceLabelValue;
            }
            builder.putLabels(resourceLabelKey, resourceLabelValue);
        }
    }

    @VisibleForTesting
    static List<io.opencensus.metrics.export.Metric> convertSummaryMetric(io.opencensus.metrics.export.Metric summaryMetric) {
        ArrayList metricsList = Lists.newArrayList();
        final ArrayList<TimeSeries> percentileTimeSeries = new ArrayList<TimeSeries>();
        final ArrayList<TimeSeries> summaryCountTimeSeries = new ArrayList<TimeSeries>();
        final ArrayList<TimeSeries> summarySumTimeSeries = new ArrayList<TimeSeries>();
        for (final TimeSeries timeSeries : summaryMetric.getTimeSeriesList()) {
            final ArrayList labelValuesWithPercentile = new ArrayList(timeSeries.getLabelValues());
            final Timestamp timeSeriesTimestamp = timeSeries.getStartTimestamp();
            for (io.opencensus.metrics.export.Point point : timeSeries.getPoints()) {
                final Timestamp pointTimestamp = point.getTimestamp();
                point.getValue().match(Functions.returnNull(), Functions.returnNull(), Functions.returnNull(), (Function)new Function<Summary, Void>(){

                    public Void apply(Summary summary) {
                        Double sum;
                        Long count = summary.getCount();
                        if (count != null) {
                            StackdriverExportUtils.createTimeSeries(timeSeries.getLabelValues(), Value.longValue((long)count), pointTimestamp, timeSeriesTimestamp, summaryCountTimeSeries);
                        }
                        if ((sum = summary.getSum()) != null) {
                            StackdriverExportUtils.createTimeSeries(timeSeries.getLabelValues(), Value.doubleValue((double)sum), pointTimestamp, timeSeriesTimestamp, summarySumTimeSeries);
                        }
                        Summary.Snapshot snapshot = summary.getSnapshot();
                        for (Summary.Snapshot.ValueAtPercentile valueAtPercentile : snapshot.getValueAtPercentiles()) {
                            labelValuesWithPercentile.add(LabelValue.create((String)(valueAtPercentile.getPercentile() + "")));
                            StackdriverExportUtils.createTimeSeries(labelValuesWithPercentile, Value.doubleValue((double)valueAtPercentile.getValue()), pointTimestamp, null, percentileTimeSeries);
                            labelValuesWithPercentile.remove(labelValuesWithPercentile.size() - 1);
                        }
                        return null;
                    }
                }, Functions.returnNull());
            }
        }
        if (summaryCountTimeSeries.size() > 0) {
            StackdriverExportUtils.addMetric(metricsList, MetricDescriptor.create((String)(summaryMetric.getMetricDescriptor().getName() + SUMMARY_SUFFIX_COUNT), (String)summaryMetric.getMetricDescriptor().getDescription(), (String)"1", (MetricDescriptor.Type)MetricDescriptor.Type.CUMULATIVE_INT64, (List)summaryMetric.getMetricDescriptor().getLabelKeys()), summaryCountTimeSeries);
        }
        if (summarySumTimeSeries.size() > 0) {
            StackdriverExportUtils.addMetric(metricsList, MetricDescriptor.create((String)(summaryMetric.getMetricDescriptor().getName() + SUMMARY_SUFFIX_SUM), (String)summaryMetric.getMetricDescriptor().getDescription(), (String)summaryMetric.getMetricDescriptor().getUnit(), (MetricDescriptor.Type)MetricDescriptor.Type.CUMULATIVE_DOUBLE, (List)summaryMetric.getMetricDescriptor().getLabelKeys()), summarySumTimeSeries);
        }
        ArrayList<LabelKey> labelKeys = new ArrayList<LabelKey>(summaryMetric.getMetricDescriptor().getLabelKeys());
        labelKeys.add(PERCENTILE_LABEL_KEY);
        StackdriverExportUtils.addMetric(metricsList, MetricDescriptor.create((String)(summaryMetric.getMetricDescriptor().getName() + SNAPSHOT_SUFFIX_PERCENTILE), (String)summaryMetric.getMetricDescriptor().getDescription(), (String)summaryMetric.getMetricDescriptor().getUnit(), (MetricDescriptor.Type)MetricDescriptor.Type.GAUGE_DOUBLE, labelKeys), percentileTimeSeries);
        return metricsList;
    }

    private static void addMetric(List<io.opencensus.metrics.export.Metric> metricsList, MetricDescriptor metricDescriptor, List<TimeSeries> timeSeriesList) {
        metricsList.add(io.opencensus.metrics.export.Metric.create((MetricDescriptor)metricDescriptor, timeSeriesList));
    }

    private static void createTimeSeries(List<LabelValue> labelValues, Value value, Timestamp pointTimestamp, @Nullable Timestamp timeSeriesTimestamp, List<TimeSeries> timeSeriesList) {
        timeSeriesList.add(TimeSeries.createWithOnePoint(labelValues, (io.opencensus.metrics.export.Point)io.opencensus.metrics.export.Point.create((Value)value, (Timestamp)pointTimestamp), (Timestamp)timeSeriesTimestamp));
    }

    private static Map<String, String> getGcpResourceLabelsMappings() {
        LinkedHashMap<String, String> resourceLabels = new LinkedHashMap<String, String>();
        resourceLabels.put(STACKDRIVER_PROJECT_ID_KEY, STACKDRIVER_PROJECT_ID_KEY);
        resourceLabels.put("instance_id", "host.id");
        resourceLabels.put("zone", "cloud.zone");
        return Collections.unmodifiableMap(resourceLabels);
    }

    private static Map<String, String> getK8sResourceLabelsMappings() {
        LinkedHashMap<String, String> resourceLabels = new LinkedHashMap<String, String>();
        resourceLabels.put(STACKDRIVER_PROJECT_ID_KEY, STACKDRIVER_PROJECT_ID_KEY);
        resourceLabels.put("location", "cloud.zone");
        resourceLabels.put("instance_id", "host.id");
        resourceLabels.put("cluster_name", "k8s.cluster.name");
        resourceLabels.put("namespace_name", "k8s.namespace.name");
        resourceLabels.put("pod_name", "k8s.pod.name");
        resourceLabels.put("container_name", "container.name");
        return Collections.unmodifiableMap(resourceLabels);
    }

    private static Map<String, String> getAwsResourceLabelsMappings() {
        LinkedHashMap<String, String> resourceLabels = new LinkedHashMap<String, String>();
        resourceLabels.put(STACKDRIVER_PROJECT_ID_KEY, STACKDRIVER_PROJECT_ID_KEY);
        resourceLabels.put("instance_id", "host.id");
        resourceLabels.put("region", "cloud.region");
        resourceLabels.put("aws_account", "cloud.account.id");
        return Collections.unmodifiableMap(resourceLabels);
    }

    private StackdriverExportUtils() {
    }

    static String exceptionMessage(Throwable e) {
        return e.getMessage() != null ? e.getMessage() : e.getClass().getName();
    }

    static String getDomain(@Nullable String metricNamePrefix) {
        String domain = Strings.isNullOrEmpty((String)metricNamePrefix) ? CUSTOM_OPENCENSUS_DOMAIN : (!metricNamePrefix.endsWith("/") ? metricNamePrefix + '/' : metricNamePrefix);
        return domain;
    }

    static String getDisplayNamePrefix(@Nullable String metricNamePrefix) {
        if (metricNamePrefix == null) {
            return DEFAULT_DISPLAY_NAME_PREFIX;
        }
        if (!metricNamePrefix.endsWith("/") && !metricNamePrefix.isEmpty()) {
            metricNamePrefix = metricNamePrefix + '/';
        }
        return metricNamePrefix;
    }
}

