/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.stats.stackdriver;

import com.google.api.MonitoredResource;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.cloud.monitoring.v3.MetricServiceSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.opencensus.common.Duration;
import io.opencensus.exporter.metrics.util.IntervalMetricReader;
import io.opencensus.exporter.metrics.util.MetricExporter;
import io.opencensus.exporter.metrics.util.MetricReader;
import io.opencensus.exporter.stats.stackdriver.CreateMetricDescriptorExporter;
import io.opencensus.exporter.stats.stackdriver.CreateTimeSeriesExporter;
import io.opencensus.exporter.stats.stackdriver.StackdriverExportUtils;
import io.opencensus.exporter.stats.stackdriver.StackdriverStatsConfiguration;
import io.opencensus.metrics.Metrics;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class StackdriverStatsExporter {
    @VisibleForTesting
    static final Object monitor = new Object();
    @Nullable
    @GuardedBy(value="monitor")
    private static StackdriverStatsExporter instance = null;
    private static final String EXPORTER_SPAN_NAME = "ExportMetricsToStackdriver";
    private static final String USER_AGENT_KEY = "user-agent";
    private static final String USER_AGENT = "opencensus-java/0.20.0";
    private static final HeaderProvider OPENCENSUS_USER_AGENT_HEADER_PROVIDER = FixedHeaderProvider.create((String[])new String[]{"user-agent", "opencensus-java/0.20.0"});
    @VisibleForTesting
    static final Duration DEFAULT_INTERVAL = Duration.create((long)60L, (int)0);
    private static final MonitoredResource DEFAULT_RESOURCE = StackdriverExportUtils.getDefaultResource();
    private final IntervalMetricReader intervalMetricReader;

    private StackdriverStatsExporter(String projectId, MetricServiceClient metricServiceClient, Duration exportInterval, MonitoredResource monitoredResource, @Nullable String metricNamePrefix) {
        IntervalMetricReader.Options.Builder intervalMetricReaderOptionsBuilder = IntervalMetricReader.Options.builder();
        if (exportInterval != null) {
            intervalMetricReaderOptionsBuilder.setExportInterval(exportInterval);
        }
        this.intervalMetricReader = IntervalMetricReader.create((MetricExporter)new CreateMetricDescriptorExporter(projectId, metricServiceClient, metricNamePrefix, new CreateTimeSeriesExporter(projectId, metricServiceClient, monitoredResource, metricNamePrefix)), (MetricReader)MetricReader.create((MetricReader.Options)MetricReader.Options.builder().setMetricProducerManager(Metrics.getExportComponent().getMetricProducerManager()).setSpanName(EXPORTER_SPAN_NAME).build()), (IntervalMetricReader.Options)intervalMetricReaderOptionsBuilder.build());
    }

    @Deprecated
    public static void createAndRegisterWithCredentialsAndProjectId(Credentials credentials, String projectId, Duration exportInterval) throws IOException {
        Preconditions.checkNotNull((Object)credentials, (Object)"credentials");
        Preconditions.checkNotNull((Object)projectId, (Object)"projectId");
        Preconditions.checkNotNull((Object)exportInterval, (Object)"exportInterval");
        StackdriverStatsExporter.createInternal(credentials, projectId, exportInterval, null, null);
    }

    @Deprecated
    public static void createAndRegisterWithProjectId(String projectId, Duration exportInterval) throws IOException {
        Preconditions.checkNotNull((Object)projectId, (Object)"projectId");
        Preconditions.checkNotNull((Object)exportInterval, (Object)"exportInterval");
        StackdriverStatsExporter.createInternal(null, projectId, exportInterval, null, null);
    }

    public static void createAndRegister(StackdriverStatsConfiguration configuration) throws IOException {
        Preconditions.checkNotNull((Object)configuration, (Object)"configuration");
        StackdriverStatsExporter.createInternal(configuration.getCredentials(), configuration.getProjectId(), configuration.getExportInterval(), configuration.getMonitoredResource(), configuration.getMetricNamePrefix());
    }

    public static void createAndRegister() throws IOException {
        StackdriverStatsExporter.createInternal(null, null, null, null, null);
    }

    @Deprecated
    public static void createAndRegister(Duration exportInterval) throws IOException {
        Preconditions.checkNotNull((Object)exportInterval, (Object)"exportInterval");
        StackdriverStatsExporter.createInternal(null, null, exportInterval, null, null);
    }

    @Deprecated
    public static void createAndRegisterWithProjectIdAndMonitoredResource(String projectId, Duration exportInterval, MonitoredResource monitoredResource) throws IOException {
        Preconditions.checkNotNull((Object)projectId, (Object)"projectId");
        Preconditions.checkNotNull((Object)exportInterval, (Object)"exportInterval");
        Preconditions.checkNotNull((Object)monitoredResource, (Object)"monitoredResource");
        StackdriverStatsExporter.createInternal(null, projectId, exportInterval, monitoredResource, null);
    }

    @Deprecated
    public static void createAndRegisterWithMonitoredResource(Duration exportInterval, MonitoredResource monitoredResource) throws IOException {
        Preconditions.checkNotNull((Object)exportInterval, (Object)"exportInterval");
        Preconditions.checkNotNull((Object)monitoredResource, (Object)"monitoredResource");
        StackdriverStatsExporter.createInternal(null, null, exportInterval, monitoredResource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createInternal(@Nullable Credentials credentials, @Nullable String projectId, @Nullable Duration exportInterval, @Nullable MonitoredResource monitoredResource, @Nullable String metricNamePrefix) throws IOException {
        projectId = projectId == null ? StackdriverStatsExporter.castNonNull(ServiceOptions.getDefaultProjectId()) : projectId;
        Object object = monitor;
        synchronized (object) {
            Preconditions.checkState((instance == null ? 1 : 0) != 0, (Object)"Stackdriver stats exporter is already created.");
            instance = new StackdriverStatsExporter(projectId, StackdriverStatsExporter.createMetricServiceClient(credentials), exportInterval == null ? DEFAULT_INTERVAL : exportInterval, monitoredResource == null ? DEFAULT_RESOURCE : monitoredResource, metricNamePrefix);
        }
    }

    private static <T> T castNonNull(@Nullable T arg) {
        return arg;
    }

    @GuardedBy(value="monitor")
    @VisibleForTesting
    static MetricServiceClient createMetricServiceClient(@Nullable Credentials credentials) throws IOException {
        MetricServiceSettings.Builder settingsBuilder = (MetricServiceSettings.Builder)MetricServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)InstantiatingGrpcChannelProvider.newBuilder().setHeaderProvider(OPENCENSUS_USER_AGENT_HEADER_PROVIDER).build());
        if (credentials != null) {
            settingsBuilder.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)credentials));
        }
        return MetricServiceClient.create((MetricServiceSettings)settingsBuilder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void unsafeResetExporter() {
        Object object = monitor;
        synchronized (object) {
            if (instance != null) {
                StackdriverStatsExporter.instance.intervalMetricReader.stop();
            }
            instance = null;
        }
    }
}

