/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.stats.stackdriver;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.common.collect.ImmutableSet;
import com.google.monitoring.v3.CreateMetricDescriptorRequest;
import com.google.monitoring.v3.ProjectName;
import io.opencensus.exporter.metrics.util.MetricExporter;
import io.opencensus.exporter.stats.stackdriver.StackdriverExportUtils;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import io.opencensus.metrics.export.Metric;
import io.opencensus.metrics.export.MetricDescriptor;
import io.opencensus.trace.Span;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class CreateMetricDescriptorExporter
extends MetricExporter {
    private static final Tracer tracer = Tracing.getTracer();
    private static final Logger logger = Logger.getLogger(CreateMetricDescriptorExporter.class.getName());
    private static final ImmutableSet<String> SUPPORTED_EXTERNAL_DOMAINS = ImmutableSet.of((Object)"custom.googleapis.com", (Object)"external.googleapis.com");
    private static final String GOOGLE_APIS_DOMAIN_SUFFIX = "googleapis.com";
    private final String projectId;
    private final ProjectName projectName;
    private final MetricServiceClient metricServiceClient;
    private final String domain;
    private final String displayNamePrefix;
    private final Map<String, MetricDescriptor> registeredMetricDescriptors = new LinkedHashMap<String, MetricDescriptor>();
    private final Map<LabelKey, LabelValue> constantLabels;
    private final MetricExporter nextExporter;

    CreateMetricDescriptorExporter(String projectId, MetricServiceClient metricServiceClient, @Nullable String metricNamePrefix, Map<LabelKey, LabelValue> constantLabels, MetricExporter nextExporter) {
        this.projectId = projectId;
        this.projectName = ProjectName.newBuilder().setProject(projectId).build();
        this.metricServiceClient = metricServiceClient;
        this.domain = StackdriverExportUtils.getDomain(metricNamePrefix);
        this.displayNamePrefix = StackdriverExportUtils.getDisplayNamePrefix(metricNamePrefix);
        this.constantLabels = constantLabels;
        this.nextExporter = nextExporter;
    }

    private boolean registerMetricDescriptor(MetricDescriptor metricDescriptor) {
        String metricName = metricDescriptor.getName();
        MetricDescriptor existingMetricDescriptor = this.registeredMetricDescriptors.get(metricName);
        if (existingMetricDescriptor != null) {
            if (existingMetricDescriptor.equals(metricDescriptor)) {
                return true;
            }
            logger.log(Level.WARNING, "A different metric with the same name is already registered: " + existingMetricDescriptor);
            return false;
        }
        this.registeredMetricDescriptors.put(metricName, metricDescriptor);
        if (CreateMetricDescriptorExporter.isBuiltInMetric(metricName)) {
            return true;
        }
        Span span = tracer.getCurrentSpan();
        span.addAnnotation("Create Stackdriver Metric.");
        com.google.api.MetricDescriptor stackDriverMetricDescriptor = StackdriverExportUtils.createMetricDescriptor(metricDescriptor, this.projectId, this.domain, this.displayNamePrefix, this.constantLabels);
        CreateMetricDescriptorRequest request = CreateMetricDescriptorRequest.newBuilder().setName(this.projectName.toString()).setMetricDescriptor(stackDriverMetricDescriptor).build();
        try {
            this.metricServiceClient.createMetricDescriptor(request);
            span.addAnnotation("Finish creating MetricDescriptor.");
            return true;
        }
        catch (ApiException e) {
            logger.log(Level.WARNING, "ApiException thrown when creating MetricDescriptor.", e);
            span.setStatus(Status.CanonicalCode.valueOf((String)e.getStatusCode().getCode().name()).toStatus().withDescription("ApiException thrown when creating MetricDescriptor: " + StackdriverExportUtils.exceptionMessage(e)));
            return false;
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Exception thrown when creating MetricDescriptor.", e);
            span.setStatus(Status.UNKNOWN.withDescription("Exception thrown when creating MetricDescriptor: " + StackdriverExportUtils.exceptionMessage(e)));
            return false;
        }
    }

    public void export(Collection<Metric> metrics) {
        ArrayList<Metric> registeredMetrics = new ArrayList<Metric>(metrics.size());
        for (Metric metric : metrics) {
            MetricDescriptor metricDescriptor = metric.getMetricDescriptor();
            if (metricDescriptor.getType() == MetricDescriptor.Type.SUMMARY) {
                List<Metric> convertedMetrics = StackdriverExportUtils.convertSummaryMetric(metric);
                registeredMetrics.ensureCapacity(registeredMetrics.size() + convertedMetrics.size());
                for (Metric convertedMetric : convertedMetrics) {
                    if (!this.registerMetricDescriptor(convertedMetric.getMetricDescriptor())) continue;
                    registeredMetrics.add(convertedMetric);
                }
                continue;
            }
            if (!this.registerMetricDescriptor(metricDescriptor)) continue;
            registeredMetrics.add(metric);
        }
        this.nextExporter.export(registeredMetrics);
    }

    private static boolean isBuiltInMetric(String metricName) {
        int domainIndex = metricName.indexOf(47);
        if (domainIndex < 0) {
            return false;
        }
        String metricDomain = metricName.substring(0, domainIndex);
        if (!metricDomain.endsWith(GOOGLE_APIS_DOMAIN_SUFFIX)) {
            return false;
        }
        return !SUPPORTED_EXTERNAL_DOMAINS.contains((Object)metricDomain);
    }
}

