/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.stats.stackdriver;

import com.google.api.MonitoredResource;
import com.google.auth.Credentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.monitoring.v3.stub.MetricServiceStub;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.opencensus.common.Duration;
import io.opencensus.exporter.stats.stackdriver.AutoValue_StackdriverStatsConfiguration;
import io.opencensus.exporter.stats.stackdriver.StackdriverExportUtils;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class StackdriverStatsConfiguration {
    static final Duration DEFAULT_INTERVAL = Duration.create((long)60L, (int)0);
    static final MonitoredResource DEFAULT_RESOURCE = StackdriverExportUtils.getDefaultResource();
    static final String DEFAULT_PROJECT_ID = Strings.nullToEmpty((String)ServiceOptions.getDefaultProjectId());
    static final Duration DEFAULT_DEADLINE = Duration.create((long)60L, (int)0);

    StackdriverStatsConfiguration() {
    }

    @Nullable
    public abstract Credentials getCredentials();

    public abstract String getProjectId();

    public abstract Duration getExportInterval();

    public abstract MonitoredResource getMonitoredResource();

    @Nullable
    public abstract String getMetricNamePrefix();

    public abstract Map<LabelKey, LabelValue> getConstantLabels();

    public abstract Duration getDeadline();

    @Nullable
    public abstract MetricServiceStub getMetricServiceStub();

    public static Builder builder() {
        return new AutoValue_StackdriverStatsConfiguration.Builder().setProjectId(DEFAULT_PROJECT_ID).setConstantLabels(StackdriverExportUtils.DEFAULT_CONSTANT_LABELS).setExportInterval(DEFAULT_INTERVAL).setMonitoredResource(DEFAULT_RESOURCE).setDeadline(DEFAULT_DEADLINE);
    }

    public static abstract class Builder {
        @VisibleForTesting
        static final Duration ZERO = Duration.fromMillis((long)0L);

        Builder() {
        }

        public abstract Builder setCredentials(Credentials var1);

        public abstract Builder setProjectId(String var1);

        public abstract Builder setExportInterval(Duration var1);

        public abstract Builder setMonitoredResource(MonitoredResource var1);

        public abstract Builder setMetricNamePrefix(String var1);

        public abstract Builder setConstantLabels(Map<LabelKey, LabelValue> var1);

        public abstract Builder setDeadline(Duration var1);

        public abstract Builder setMetricServiceStub(MetricServiceStub var1);

        abstract String getProjectId();

        abstract Map<LabelKey, LabelValue> getConstantLabels();

        abstract Duration getDeadline();

        abstract StackdriverStatsConfiguration autoBuild();

        public StackdriverStatsConfiguration build() {
            this.setConstantLabels(Collections.unmodifiableMap(new LinkedHashMap<LabelKey, LabelValue>(this.getConstantLabels())));
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getProjectId()) ? 1 : 0) != 0, (Object)"Cannot find a project ID from either configurations or application default.");
            for (Map.Entry<LabelKey, LabelValue> constantLabel : this.getConstantLabels().entrySet()) {
                Preconditions.checkNotNull((Object)constantLabel.getKey(), (Object)"constant label key");
                Preconditions.checkNotNull((Object)constantLabel.getValue(), (Object)"constant label value");
            }
            Preconditions.checkArgument((this.getDeadline().compareTo(ZERO) > 0 ? 1 : 0) != 0, (Object)"Deadline must be positive.");
            return this.autoBuild();
        }
    }
}

