/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.stats.stackdriver;

import com.google.api.MonitoredResource;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.cloud.monitoring.v3.MetricServiceSettings;
import com.google.cloud.monitoring.v3.stub.MetricServiceStub;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.opencensus.exporter.metrics.util.IntervalMetricReader;
import io.opencensus.exporter.metrics.util.MetricExporter;
import io.opencensus.exporter.metrics.util.MetricReader;
import io.opencensus.exporter.stats.stackdriver.CreateMetricDescriptorExporter;
import io.opencensus.exporter.stats.stackdriver.CreateTimeSeriesExporter;
import io.opencensus.exporter.stats.stackdriver.StackdriverExportUtils;
import io.opencensus.exporter.stats.stackdriver.StackdriverStatsConfiguration;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import io.opencensus.metrics.Metrics;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.threeten.bp.Duration;

@ThreadSafe
public final class StackdriverStatsExporter {
    @VisibleForTesting
    static final Object monitor = new Object();
    @Nullable
    @GuardedBy(value="monitor")
    private static StackdriverStatsExporter instance = null;
    @Nullable
    @GuardedBy(value="monitor")
    private static MetricServiceClient metricServiceClient = null;
    private static final String EXPORTER_SPAN_NAME = "ExportMetricsToStackdriver";
    private static final String USER_AGENT_KEY = "user-agent";
    private static final String USER_AGENT = "opencensus-java/0.31.1";
    private static final HeaderProvider OPENCENSUS_USER_AGENT_HEADER_PROVIDER = FixedHeaderProvider.create((String[])new String[]{"user-agent", "opencensus-java/0.31.1"});
    private final IntervalMetricReader intervalMetricReader;

    private StackdriverStatsExporter(String projectId, MetricServiceClient metricServiceClient, io.opencensus.common.Duration exportInterval, MonitoredResource monitoredResource, @Nullable String metricNamePrefix, @Nullable String displayNamePrefix, Map<LabelKey, LabelValue> constantLabels) {
        IntervalMetricReader.Options.Builder intervalMetricReaderOptionsBuilder = IntervalMetricReader.Options.builder();
        intervalMetricReaderOptionsBuilder.setExportInterval(exportInterval);
        this.intervalMetricReader = IntervalMetricReader.create((MetricExporter)new CreateMetricDescriptorExporter(projectId, metricServiceClient, metricNamePrefix, displayNamePrefix, constantLabels, new CreateTimeSeriesExporter(projectId, metricServiceClient, monitoredResource, metricNamePrefix, constantLabels)), (MetricReader)MetricReader.create((MetricReader.Options)MetricReader.Options.builder().setMetricProducerManager(Metrics.getExportComponent().getMetricProducerManager()).setSpanName(EXPORTER_SPAN_NAME).build()), (IntervalMetricReader.Options)intervalMetricReaderOptionsBuilder.build());
    }

    @Deprecated
    public static void createAndRegisterWithCredentialsAndProjectId(Credentials credentials, String projectId, io.opencensus.common.Duration exportInterval) throws IOException {
        Preconditions.checkNotNull((Object)credentials, (Object)"credentials");
        Preconditions.checkNotNull((Object)projectId, (Object)"projectId");
        Preconditions.checkNotNull((Object)exportInterval, (Object)"exportInterval");
        StackdriverStatsExporter.createInternal(credentials, projectId, exportInterval, StackdriverStatsConfiguration.DEFAULT_RESOURCE, null, null, StackdriverExportUtils.DEFAULT_CONSTANT_LABELS, StackdriverStatsConfiguration.DEFAULT_DEADLINE, null);
    }

    @Deprecated
    public static void createAndRegisterWithProjectId(String projectId, io.opencensus.common.Duration exportInterval) throws IOException {
        Preconditions.checkNotNull((Object)projectId, (Object)"projectId");
        Preconditions.checkNotNull((Object)exportInterval, (Object)"exportInterval");
        StackdriverStatsExporter.createInternal(null, projectId, exportInterval, StackdriverStatsConfiguration.DEFAULT_RESOURCE, null, null, StackdriverExportUtils.DEFAULT_CONSTANT_LABELS, StackdriverStatsConfiguration.DEFAULT_DEADLINE, null);
    }

    public static void createAndRegister(StackdriverStatsConfiguration configuration) throws IOException {
        Preconditions.checkNotNull((Object)configuration, (Object)"configuration");
        StackdriverStatsExporter.createInternal(configuration.getCredentials(), configuration.getProjectId(), configuration.getExportInterval(), configuration.getMonitoredResource(), configuration.getMetricNamePrefix(), configuration.getDisplayNamePrefix(), configuration.getConstantLabels(), configuration.getDeadline(), configuration.getMetricServiceStub());
    }

    public static void createAndRegister() throws IOException {
        StackdriverStatsExporter.createAndRegister(StackdriverStatsConfiguration.builder().build());
    }

    @Deprecated
    public static void createAndRegister(io.opencensus.common.Duration exportInterval) throws IOException {
        Preconditions.checkNotNull((Object)exportInterval, (Object)"exportInterval");
        Preconditions.checkArgument((!StackdriverStatsConfiguration.DEFAULT_PROJECT_ID.isEmpty() ? 1 : 0) != 0, (Object)"Cannot find a project ID from application default.");
        StackdriverStatsExporter.createInternal(null, StackdriverStatsConfiguration.DEFAULT_PROJECT_ID, exportInterval, StackdriverStatsConfiguration.DEFAULT_RESOURCE, null, null, StackdriverExportUtils.DEFAULT_CONSTANT_LABELS, StackdriverStatsConfiguration.DEFAULT_DEADLINE, null);
    }

    @Deprecated
    public static void createAndRegisterWithProjectIdAndMonitoredResource(String projectId, io.opencensus.common.Duration exportInterval, MonitoredResource monitoredResource) throws IOException {
        Preconditions.checkNotNull((Object)projectId, (Object)"projectId");
        Preconditions.checkNotNull((Object)exportInterval, (Object)"exportInterval");
        Preconditions.checkNotNull((Object)monitoredResource, (Object)"monitoredResource");
        StackdriverStatsExporter.createInternal(null, projectId, exportInterval, monitoredResource, null, null, StackdriverExportUtils.DEFAULT_CONSTANT_LABELS, StackdriverStatsConfiguration.DEFAULT_DEADLINE, null);
    }

    @Deprecated
    public static void createAndRegisterWithMonitoredResource(io.opencensus.common.Duration exportInterval, MonitoredResource monitoredResource) throws IOException {
        Preconditions.checkNotNull((Object)exportInterval, (Object)"exportInterval");
        Preconditions.checkNotNull((Object)monitoredResource, (Object)"monitoredResource");
        Preconditions.checkArgument((!StackdriverStatsConfiguration.DEFAULT_PROJECT_ID.isEmpty() ? 1 : 0) != 0, (Object)"Cannot find a project ID from application default.");
        StackdriverStatsExporter.createInternal(null, StackdriverStatsConfiguration.DEFAULT_PROJECT_ID, exportInterval, monitoredResource, null, null, StackdriverExportUtils.DEFAULT_CONSTANT_LABELS, StackdriverStatsConfiguration.DEFAULT_DEADLINE, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createInternal(@Nullable Credentials credentials, String projectId, io.opencensus.common.Duration exportInterval, MonitoredResource monitoredResource, @Nullable String metricNamePrefix, @Nullable String displayNamePrefix, Map<LabelKey, LabelValue> constantLabels, io.opencensus.common.Duration deadline, @Nullable MetricServiceStub stub) throws IOException {
        Object object = monitor;
        synchronized (object) {
            Preconditions.checkState((instance == null ? 1 : 0) != 0, (Object)"Stackdriver stats exporter is already created.");
            MetricServiceClient client = stub == null ? (metricServiceClient = StackdriverStatsExporter.createMetricServiceClient(credentials, deadline)) : MetricServiceClient.create((MetricServiceStub)stub);
            instance = new StackdriverStatsExporter(projectId, client, exportInterval, monitoredResource, metricNamePrefix, displayNamePrefix, constantLabels);
        }
    }

    @GuardedBy(value="monitor")
    @VisibleForTesting
    static MetricServiceClient createMetricServiceClient(@Nullable Credentials credentials, io.opencensus.common.Duration deadline) throws IOException {
        MetricServiceSettings.Builder settingsBuilder = (MetricServiceSettings.Builder)MetricServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)InstantiatingGrpcChannelProvider.newBuilder().setHeaderProvider(OPENCENSUS_USER_AGENT_HEADER_PROVIDER).build());
        if (credentials != null) {
            settingsBuilder.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)credentials));
        }
        Duration stackdriverDuration = Duration.ofMillis((long)deadline.toMillis());
        settingsBuilder.createMetricDescriptorSettings().setSimpleTimeoutNoRetries(stackdriverDuration);
        settingsBuilder.createTimeSeriesSettings().setSimpleTimeoutNoRetries(stackdriverDuration);
        return MetricServiceClient.create((MetricServiceSettings)settingsBuilder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister() {
        Object object = monitor;
        synchronized (object) {
            if (instance != null) {
                StackdriverStatsExporter.instance.intervalMetricReader.stop();
            }
            instance = null;
            if (metricServiceClient != null) {
                metricServiceClient.close();
                metricServiceClient = null;
            }
        }
    }
}

