/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.trace;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.EvictingQueue;
import io.opencensus.common.Clock;
import io.opencensus.common.Timestamp;
import io.opencensus.implcore.internal.CheckerFrameworkUtils;
import io.opencensus.implcore.internal.TimestampConverter;
import io.opencensus.implcore.trace.internal.ConcurrentIntrusiveList;
import io.opencensus.trace.Annotation;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.EndSpanOptions;
import io.opencensus.trace.Link;
import io.opencensus.trace.MessageEvent;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.SpanId;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.config.TraceParams;
import io.opencensus.trace.export.SpanData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class RecordEventsSpanImpl
extends Span
implements ConcurrentIntrusiveList.Element<RecordEventsSpanImpl> {
    private static final Logger logger = Logger.getLogger(Tracer.class.getName());
    private static final EnumSet<Span.Options> RECORD_EVENTS_SPAN_OPTIONS = EnumSet.of(Span.Options.RECORD_EVENTS);
    @Nullable
    private final SpanId parentSpanId;
    @Nullable
    private final Boolean hasRemoteParent;
    private final TraceParams traceParams;
    private final StartEndHandler startEndHandler;
    private final String name;
    @Nullable
    private final Span.Kind kind;
    private final Clock clock;
    @Nullable
    private final TimestampConverter timestampConverter;
    private final long startNanoTime;
    @Nullable
    @GuardedBy(value="this")
    private AttributesWithCapacity attributes;
    @Nullable
    @GuardedBy(value="this")
    private TraceEvents<EventWithNanoTime<Annotation>> annotations;
    @Nullable
    @GuardedBy(value="this")
    private TraceEvents<EventWithNanoTime<MessageEvent>> messageEvents;
    @Nullable
    @GuardedBy(value="this")
    private TraceEvents<Link> links;
    @Nullable
    @GuardedBy(value="this")
    private Status status;
    @GuardedBy(value="this")
    private long endNanoTime;
    @GuardedBy(value="this")
    private boolean hasBeenEnded;
    @GuardedBy(value="this")
    private boolean sampleToLocalSpanStore;
    @Nullable
    private RecordEventsSpanImpl next = null;
    @Nullable
    private RecordEventsSpanImpl prev = null;

    @VisibleForTesting
    public static RecordEventsSpanImpl startSpan(SpanContext context, String name, @Nullable Span.Kind kind, @Nullable SpanId parentSpanId, @Nullable Boolean hasRemoteParent, TraceParams traceParams, StartEndHandler startEndHandler, @Nullable TimestampConverter timestampConverter, Clock clock) {
        RecordEventsSpanImpl span = new RecordEventsSpanImpl(context, name, kind, parentSpanId, hasRemoteParent, traceParams, startEndHandler, timestampConverter, clock);
        startEndHandler.onStart(span);
        return span;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status getStatus() {
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            return this.getStatusWithDefault();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEndNanoTime() {
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            return this.hasBeenEnded ? this.endNanoTime : this.clock.nowNanos();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLatencyNs() {
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            return this.hasBeenEnded ? this.endNanoTime - this.startNanoTime : this.clock.nowNanos() - this.startNanoTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getSampleToLocalSpanStore() {
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            Preconditions.checkState((boolean)this.hasBeenEnded, (Object)"Running span does not have the SampleToLocalSpanStore set.");
            return this.sampleToLocalSpanStore;
        }
    }

    @Nullable
    public Span.Kind getKind() {
        return this.kind;
    }

    @Nullable
    TimestampConverter getTimestampConverter() {
        return this.timestampConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpanData toSpanData() {
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            SpanData.Attributes attributesSpanData = this.attributes == null ? SpanData.Attributes.create(Collections.emptyMap(), (int)0) : SpanData.Attributes.create((Map)this.attributes, (int)this.attributes.getNumberOfDroppedAttributes());
            SpanData.TimedEvents annotationsSpanData = RecordEventsSpanImpl.createTimedEvents(this.getInitializedAnnotations(), this.timestampConverter);
            SpanData.TimedEvents messageEventsSpanData = RecordEventsSpanImpl.createTimedEvents(this.getInitializedNetworkEvents(), this.timestampConverter);
            SpanData.Links linksSpanData = this.links == null ? SpanData.Links.create(Collections.emptyList(), (int)0) : SpanData.Links.create(new ArrayList(((TraceEvents)this.links).events), (int)((TraceEvents)this.links).getNumberOfDroppedEvents());
            return SpanData.create((SpanContext)this.getContext(), (SpanId)this.parentSpanId, (Boolean)this.hasRemoteParent, (String)this.name, (Span.Kind)this.kind, (Timestamp)CheckerFrameworkUtils.castNonNull(this.timestampConverter).convertNanoTime(this.startNanoTime), (SpanData.Attributes)attributesSpanData, annotationsSpanData, messageEventsSpanData, (SpanData.Links)linksSpanData, null, (Status)(this.hasBeenEnded ? this.getStatusWithDefault() : null), this.hasBeenEnded ? CheckerFrameworkUtils.castNonNull(this.timestampConverter).convertNanoTime(this.endNanoTime) : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAttribute(String key, AttributeValue value) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkNotNull((Object)value, (Object)"value");
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling putAttributes() on an ended Span.");
                return;
            }
            this.getInitializedAttributes().putAttribute(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAttributes(Map<String, AttributeValue> attributes) {
        Preconditions.checkNotNull(attributes, (Object)"attributes");
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling putAttributes() on an ended Span.");
                return;
            }
            this.getInitializedAttributes().putAttributes(attributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotation(String description, Map<String, AttributeValue> attributes) {
        Preconditions.checkNotNull((Object)description, (Object)"description");
        Preconditions.checkNotNull(attributes, (Object)"attribute");
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling addAnnotation() on an ended Span.");
                return;
            }
            this.getInitializedAnnotations().addEvent(new EventWithNanoTime(this.clock.nowNanos(), Annotation.fromDescriptionAndAttributes((String)description, attributes)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotation(Annotation annotation) {
        Preconditions.checkNotNull((Object)annotation, (Object)"annotation");
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling addAnnotation() on an ended Span.");
                return;
            }
            this.getInitializedAnnotations().addEvent(new EventWithNanoTime(this.clock.nowNanos(), annotation));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageEvent(MessageEvent messageEvent) {
        Preconditions.checkNotNull((Object)messageEvent, (Object)"messageEvent");
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling addNetworkEvent() on an ended Span.");
                return;
            }
            this.getInitializedNetworkEvents().addEvent(new EventWithNanoTime(this.clock.nowNanos(), Preconditions.checkNotNull((Object)messageEvent, (Object)"networkEvent")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLink(Link link) {
        Preconditions.checkNotNull((Object)link, (Object)"link");
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling addLink() on an ended Span.");
                return;
            }
            this.getInitializedLinks().addEvent(link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(Status status) {
        Preconditions.checkNotNull((Object)status, (Object)"status");
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling setStatus() on an ended Span.");
                return;
            }
            this.status = status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(EndSpanOptions options) {
        Preconditions.checkNotNull((Object)options, (Object)"options");
        RecordEventsSpanImpl recordEventsSpanImpl = this;
        synchronized (recordEventsSpanImpl) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling end() on an ended Span.");
                return;
            }
            if (options.getStatus() != null) {
                this.status = options.getStatus();
            }
            this.sampleToLocalSpanStore = options.getSampleToLocalSpanStore();
            this.endNanoTime = this.clock.nowNanos();
            this.hasBeenEnded = true;
        }
        this.startEndHandler.onEnd(this);
    }

    @GuardedBy(value="this")
    private AttributesWithCapacity getInitializedAttributes() {
        if (this.attributes == null) {
            this.attributes = new AttributesWithCapacity(this.traceParams.getMaxNumberOfAttributes());
        }
        return this.attributes;
    }

    @GuardedBy(value="this")
    private TraceEvents<EventWithNanoTime<Annotation>> getInitializedAnnotations() {
        if (this.annotations == null) {
            this.annotations = new TraceEvents(this.traceParams.getMaxNumberOfAnnotations());
        }
        return this.annotations;
    }

    @GuardedBy(value="this")
    private TraceEvents<EventWithNanoTime<MessageEvent>> getInitializedNetworkEvents() {
        if (this.messageEvents == null) {
            this.messageEvents = new TraceEvents(this.traceParams.getMaxNumberOfMessageEvents());
        }
        return this.messageEvents;
    }

    @GuardedBy(value="this")
    private TraceEvents<Link> getInitializedLinks() {
        if (this.links == null) {
            this.links = new TraceEvents(this.traceParams.getMaxNumberOfLinks());
        }
        return this.links;
    }

    @GuardedBy(value="this")
    private Status getStatusWithDefault() {
        return this.status == null ? Status.OK : this.status;
    }

    private static <T> SpanData.TimedEvents<T> createTimedEvents(TraceEvents<EventWithNanoTime<T>> events, @Nullable TimestampConverter timestampConverter) {
        if (events == null) {
            return SpanData.TimedEvents.create(Collections.emptyList(), (int)0);
        }
        ArrayList<SpanData.TimedEvent> eventsList = new ArrayList<SpanData.TimedEvent>(((TraceEvents)events).events.size());
        for (EventWithNanoTime networkEvent : ((TraceEvents)events).events) {
            eventsList.add(networkEvent.toSpanDataTimedEvent(CheckerFrameworkUtils.castNonNull(timestampConverter)));
        }
        return SpanData.TimedEvents.create(eventsList, (int)((TraceEvents)events).getNumberOfDroppedEvents());
    }

    @Override
    @Nullable
    public RecordEventsSpanImpl getNext() {
        return this.next;
    }

    @Override
    public void setNext(@Nullable RecordEventsSpanImpl element) {
        this.next = element;
    }

    @Override
    @Nullable
    public RecordEventsSpanImpl getPrev() {
        return this.prev;
    }

    @Override
    public void setPrev(@Nullable RecordEventsSpanImpl element) {
        this.prev = element;
    }

    private RecordEventsSpanImpl(SpanContext context, String name, @Nullable Span.Kind kind, @Nullable SpanId parentSpanId, @Nullable Boolean hasRemoteParent, TraceParams traceParams, StartEndHandler startEndHandler, @Nullable TimestampConverter timestampConverter, Clock clock) {
        super(context, RECORD_EVENTS_SPAN_OPTIONS);
        this.parentSpanId = parentSpanId;
        this.hasRemoteParent = hasRemoteParent;
        this.name = name;
        this.kind = kind;
        this.traceParams = traceParams;
        this.startEndHandler = startEndHandler;
        this.clock = clock;
        this.hasBeenEnded = false;
        this.sampleToLocalSpanStore = false;
        this.timestampConverter = timestampConverter != null ? timestampConverter : TimestampConverter.now(clock);
        this.startNanoTime = clock.nowNanos();
    }

    private static final class EventWithNanoTime<T> {
        private final long nanoTime;
        private final T event;

        private EventWithNanoTime(long nanoTime, T event) {
            this.nanoTime = nanoTime;
            this.event = event;
        }

        private SpanData.TimedEvent<T> toSpanDataTimedEvent(TimestampConverter timestampConverter) {
            return SpanData.TimedEvent.create((Timestamp)timestampConverter.convertNanoTime(this.nanoTime), this.event);
        }
    }

    private static final class TraceEvents<T> {
        private int totalRecordedEvents = 0;
        private final EvictingQueue<T> events;

        private int getNumberOfDroppedEvents() {
            return this.totalRecordedEvents - this.events.size();
        }

        TraceEvents(int maxNumEvents) {
            this.events = EvictingQueue.create((int)maxNumEvents);
        }

        void addEvent(T event) {
            ++this.totalRecordedEvents;
            this.events.add(event);
        }
    }

    private static final class AttributesWithCapacity
    extends LinkedHashMap<String, AttributeValue> {
        private final int capacity;
        private int totalRecordedAttributes = 0;
        private static final long serialVersionUID = 42L;

        private AttributesWithCapacity(int capacity) {
            super(capacity + 1, 1.0f, true);
            this.capacity = capacity;
        }

        private void putAttribute(String key, AttributeValue value) {
            ++this.totalRecordedAttributes;
            this.put(key, value);
        }

        private void putAttributes(Map<String, AttributeValue> attributes) {
            this.totalRecordedAttributes += attributes.size();
            this.putAll(attributes);
        }

        private int getNumberOfDroppedAttributes() {
            return this.totalRecordedAttributes - this.size();
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, AttributeValue> eldest) {
            return this.size() > this.capacity;
        }
    }

    public static interface StartEndHandler {
        public void onStart(RecordEventsSpanImpl var1);

        public void onEnd(RecordEventsSpanImpl var1);
    }
}

