/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.stats;

import com.google.common.annotations.VisibleForTesting;
import io.opencensus.common.Function;
import io.opencensus.common.Functions;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import io.opencensus.metrics.data.AttachmentValue;
import io.opencensus.metrics.export.MetricDescriptor;
import io.opencensus.stats.Aggregation;
import io.opencensus.stats.Measure;
import io.opencensus.stats.View;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

final class MetricUtils {
    private static final Function<Object, MetricDescriptor.Type> TYPE_CUMULATIVE_DOUBLE_FUNCTION = Functions.returnConstant((Object)MetricDescriptor.Type.CUMULATIVE_DOUBLE);
    private static final Function<Object, MetricDescriptor.Type> TYPE_CUMULATIVE_INT64_FUNCTION = Functions.returnConstant((Object)MetricDescriptor.Type.CUMULATIVE_INT64);
    private static final Function<Object, MetricDescriptor.Type> TYPE_CUMULATIVE_DISTRIBUTION_FUNCTION = Functions.returnConstant((Object)MetricDescriptor.Type.CUMULATIVE_DISTRIBUTION);
    private static final Function<Object, MetricDescriptor.Type> TYPE_GAUGE_DOUBLE_FUNCTION = Functions.returnConstant((Object)MetricDescriptor.Type.GAUGE_DOUBLE);
    private static final Function<Object, MetricDescriptor.Type> TYPE_GAUGE_INT64_FUNCTION = Functions.returnConstant((Object)MetricDescriptor.Type.GAUGE_INT64);
    private static final Function<Object, MetricDescriptor.Type> TYPE_UNRECOGNIZED_FUNCTION = Functions.throwAssertionError();
    private static final Function<Aggregation, MetricDescriptor.Type> AGGREGATION_TYPE_DEFAULT_FUNCTION = new Function<Aggregation, MetricDescriptor.Type>(){

        public MetricDescriptor.Type apply(Aggregation arg) {
            if (arg instanceof Aggregation.Mean) {
                return MetricDescriptor.Type.CUMULATIVE_DOUBLE;
            }
            throw new AssertionError();
        }
    };

    @Nullable
    static MetricDescriptor viewToMetricDescriptor(View view) {
        if (view.getWindow() instanceof View.AggregationWindow.Interval) {
            return null;
        }
        ArrayList<LabelKey> labelKeys = new ArrayList<LabelKey>();
        for (TagKey tagKey : view.getColumns()) {
            labelKeys.add(LabelKey.create((String)tagKey.getName(), (String)""));
        }
        Measure measure = view.getMeasure();
        return MetricDescriptor.create((String)view.getName().asString(), (String)view.getDescription(), (String)measure.getUnit(), (MetricDescriptor.Type)MetricUtils.getType(measure, view.getAggregation()), labelKeys);
    }

    @VisibleForTesting
    static MetricDescriptor.Type getType(Measure measure, Aggregation aggregation) {
        return (MetricDescriptor.Type)aggregation.match(Functions.returnConstant((Object)measure.match(TYPE_CUMULATIVE_DOUBLE_FUNCTION, TYPE_CUMULATIVE_INT64_FUNCTION, TYPE_UNRECOGNIZED_FUNCTION)), TYPE_CUMULATIVE_INT64_FUNCTION, TYPE_CUMULATIVE_DISTRIBUTION_FUNCTION, Functions.returnConstant((Object)measure.match(TYPE_GAUGE_DOUBLE_FUNCTION, TYPE_GAUGE_INT64_FUNCTION, TYPE_UNRECOGNIZED_FUNCTION)), AGGREGATION_TYPE_DEFAULT_FUNCTION);
    }

    static List<LabelValue> tagValuesToLabelValues(List<TagValue> tagValues) {
        ArrayList<LabelValue> labelValues = new ArrayList<LabelValue>();
        for (TagValue tagValue : tagValues) {
            labelValues.add(LabelValue.create((String)(tagValue == null ? null : tagValue.asString())));
        }
        return labelValues;
    }

    static Map<String, String> toStringAttachments(Map<String, AttachmentValue> attachments) {
        HashMap<String, String> stringAttachments = new HashMap<String, String>();
        for (Map.Entry<String, AttachmentValue> entry : attachments.entrySet()) {
            stringAttachments.put(entry.getKey(), entry.getValue().getValue());
        }
        return stringAttachments;
    }

    private MetricUtils() {
    }
}

