/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.internal;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import io.opencensus.internal.EventQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class DisruptorEventQueue
implements EventQueue {
    private static final DisruptorEventQueue eventQueue = new DisruptorEventQueue();
    private final Disruptor<InstrumentationEvent> disruptor;
    private final RingBuffer<InstrumentationEvent> ringBuffer;

    private DisruptorEventQueue() {
        int bufferSize = 8192;
        this.disruptor = new Disruptor((EventFactory)new InstrumentationEventFactory(), 8192, (Executor)Executors.newSingleThreadExecutor(), ProducerType.MULTI, (WaitStrategy)new SleepingWaitStrategy());
        this.disruptor.handleEventsWith(new EventHandler[]{new InstrumentationEventHandler()});
        this.disruptor.start();
        this.ringBuffer = this.disruptor.getRingBuffer();
    }

    public static DisruptorEventQueue getInstance() {
        return eventQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(EventQueue.Entry entry) {
        long sequence = this.ringBuffer.next();
        try {
            InstrumentationEvent event = (InstrumentationEvent)this.ringBuffer.get(sequence);
            event.setEntry(entry);
        }
        finally {
            this.ringBuffer.publish(sequence);
        }
    }

    private static final class InstrumentationEventHandler
    implements EventHandler<InstrumentationEvent> {
        private InstrumentationEventHandler() {
        }

        public void onEvent(InstrumentationEvent event, long sequence, boolean endOfBatch) {
            event.getEntry().process();
        }
    }

    private static final class InstrumentationEventFactory
    implements EventFactory<InstrumentationEvent> {
        private InstrumentationEventFactory() {
        }

        public InstrumentationEvent newInstance() {
            return new InstrumentationEvent();
        }
    }

    private static final class InstrumentationEvent {
        private EventQueue.Entry entry = null;

        private InstrumentationEvent() {
        }

        void setEntry(EventQueue.Entry entry) {
            this.entry = entry;
        }

        EventQueue.Entry getEntry() {
            return this.entry;
        }
    }
}

