/*
 * Decompiled with CFR 0.152.
 */
package io.openim.android.sdk;

import androidx.collection.ArrayMap;
import io.openim.android.sdk.internal.log.LogcatHelper;
import io.openim.android.sdk.listener.BaseImpl;
import io.openim.android.sdk.listener.OnBase;
import io.openim.android.sdk.listener.OnConnListener;
import io.openim.android.sdk.listener.OnFileUploadProgressListener;
import io.openim.android.sdk.listener._ConnListener;
import io.openim.android.sdk.listener._FileUploadProgressListener;
import io.openim.android.sdk.manager.ConversationManager;
import io.openim.android.sdk.manager.FriendshipManager;
import io.openim.android.sdk.manager.GroupManager;
import io.openim.android.sdk.manager.MessageManager;
import io.openim.android.sdk.manager.OrganizationManager;
import io.openim.android.sdk.manager.SignalingManager;
import io.openim.android.sdk.manager.UserInfoManager;
import io.openim.android.sdk.manager.WorkMomentsManager;
import io.openim.android.sdk.utils.JsonUtil;
import io.openim.android.sdk.utils.ParamsUtil;
import open_im_sdk.Open_im_sdk;
import open_im_sdk_callback.Base;
import open_im_sdk_callback.SendMsgCallBack;

public class OpenIMClient {
    public ConversationManager conversationManager = new ConversationManager();
    public FriendshipManager friendshipManager = new FriendshipManager();
    public GroupManager groupManager = new GroupManager();
    public MessageManager messageManager = new MessageManager();
    public UserInfoManager userInfoManager = new UserInfoManager();
    public SignalingManager signalingManager = new SignalingManager();
    public WorkMomentsManager workMomentsManager = new WorkMomentsManager();
    public OrganizationManager organizationManager = new OrganizationManager();

    private OpenIMClient() {
    }

    public static OpenIMClient getInstance() {
        return Singleton.INSTANCE;
    }

    public boolean initSDK(String apiUrl, String wsUrl, String storageDir, int logLevel, String objectStorage, OnConnListener listener) {
        ArrayMap map = new ArrayMap();
        map.put("platform", 2);
        map.put("api_addr", apiUrl);
        map.put("ws_addr", wsUrl);
        map.put("data_dir", storageDir);
        map.put("log_level", logLevel);
        map.put("object_storage", objectStorage);
        boolean initialized = Open_im_sdk.initSDK((open_im_sdk_callback.OnConnListener)new _ConnListener(listener), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(map));
        LogcatHelper.logDInDebug(String.format("Initialization successful: %s", initialized));
        return initialized;
    }

    public void login(OnBase<String> base, String uid, String token) {
        Open_im_sdk.login((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)uid, (String)token);
    }

    public void logout(OnBase<String> base) {
        Open_im_sdk.logout((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID());
    }

    public long getLoginStatus() {
        return Open_im_sdk.getLoginStatus();
    }

    public void wakeUp(OnBase<String> base) {
        Open_im_sdk.wakeUp((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID());
    }

    public void uploadFile(OnFileUploadProgressListener listener, String path) {
        Open_im_sdk.uploadFile((SendMsgCallBack)new _FileUploadProgressListener(listener), (String)ParamsUtil.buildOperationID(), (String)path);
    }

    private static class Singleton {
        private static final OpenIMClient INSTANCE = new OpenIMClient();

        private Singleton() {
        }
    }
}

