/*
 * Decompiled with CFR 0.152.
 */
package io.openim.android.sdk.manager;

import androidx.collection.ArrayMap;
import io.openim.android.sdk.listener.BaseImpl;
import io.openim.android.sdk.listener.OnAdvanceMsgListener;
import io.openim.android.sdk.listener.OnBase;
import io.openim.android.sdk.listener.OnMessageKvInfoListener;
import io.openim.android.sdk.listener.OnMsgSendCallback;
import io.openim.android.sdk.listener._AdvanceMsgListener;
import io.openim.android.sdk.listener._CustomBusinessListener;
import io.openim.android.sdk.listener._MessageKvInfoListener;
import io.openim.android.sdk.listener._MsgSendProgressListener;
import io.openim.android.sdk.models.AdvancedMessage;
import io.openim.android.sdk.models.AtUserInfo;
import io.openim.android.sdk.models.FileElem;
import io.openim.android.sdk.models.KeyValue;
import io.openim.android.sdk.models.Message;
import io.openim.android.sdk.models.MessageTypeKeyMapping;
import io.openim.android.sdk.models.OfflinePushInfo;
import io.openim.android.sdk.models.PictureInfo;
import io.openim.android.sdk.models.RichMessage;
import io.openim.android.sdk.models.SearchParams;
import io.openim.android.sdk.models.SearchResult;
import io.openim.android.sdk.models.SoundElem;
import io.openim.android.sdk.models.TypeKeySetResult;
import io.openim.android.sdk.models.VideoElem;
import io.openim.android.sdk.utils.JsonUtil;
import io.openim.android.sdk.utils.ParamsUtil;
import java.util.List;
import open_im_sdk.Open_im_sdk;
import open_im_sdk_callback.Base;
import open_im_sdk_callback.OnAdvancedMsgListener;
import open_im_sdk_callback.OnCustomBusinessListener;
import open_im_sdk_callback.SendMsgCallBack;

public class MessageManager {
    public void setAdvancedMsgListener(OnAdvanceMsgListener listener) {
        Open_im_sdk.setAdvancedMsgListener((OnAdvancedMsgListener)new _AdvanceMsgListener(listener));
    }

    public void sendMessage(OnMsgSendCallback base, Message message, String recvUid, String recvGid, OfflinePushInfo offlinePushInfo) {
        Open_im_sdk.sendMessage((SendMsgCallBack)new _MsgSendProgressListener(base), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(message), (String)recvUid, (String)recvGid, (String)JsonUtil.toString(offlinePushInfo));
    }

    public void getHistoryMessageList(OnBase<List<Message>> base, String userID, String groupID, String conversationID, Message startMsg, int count) {
        ArrayMap map = new ArrayMap();
        map.put("userID", userID);
        map.put("groupID", groupID);
        map.put("conversationID", conversationID);
        if (null != startMsg) {
            map.put("startClientMsgID", startMsg.getClientMsgID());
        }
        map.put("count", count);
        Open_im_sdk.getHistoryMessageList((Base)BaseImpl.arrayBase(base, Message.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(map));
    }

    @Deprecated
    public void revokeMessage(OnBase<String> base, Message message) {
        Open_im_sdk.revokeMessage((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(message));
    }

    public void deleteMessageFromLocalStorage(OnBase<String> base, Message message) {
        Open_im_sdk.deleteMessageFromLocalStorage((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(message));
    }

    public void insertSingleMessageToLocalStorage(OnBase<String> base, Message message, String receiver, String sender) {
        Open_im_sdk.insertSingleMessageToLocalStorage((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(message), (String)receiver, (String)sender);
    }

    public void insertGroupMessageToLocalStorage(OnBase<String> base, Message message, String groupID, String senderID) {
        Open_im_sdk.insertGroupMessageToLocalStorage((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(message), (String)groupID, (String)senderID);
    }

    public void markC2CMessageAsRead(OnBase<String> base, String userID, List<String> messageIDList) {
        Open_im_sdk.markC2CMessageAsRead((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)userID, (String)JsonUtil.toString(messageIDList));
    }

    public void markGroupMessageAsRead(OnBase<String> base, String groupID, List<String> messageIDList) {
        Open_im_sdk.markGroupMessageAsRead((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)groupID, (String)JsonUtil.toString(messageIDList));
    }

    public void typingStatusUpdate(OnBase<String> base, String userID, String msgTip) {
        Open_im_sdk.typingStatusUpdate((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)userID, (String)msgTip);
    }

    public Message createTextMessage(String text) {
        return MessageManager.parse(Open_im_sdk.createTextMessage((String)ParamsUtil.buildOperationID(), (String)text));
    }

    public Message createTextAtMessage(String text, List<String> atUserIDList, List<AtUserInfo> atUserInfoList, Message quoteMessage) {
        return MessageManager.parse(Open_im_sdk.createTextAtMessage((String)ParamsUtil.buildOperationID(), (String)text, (String)JsonUtil.toString(atUserIDList), (String)JsonUtil.toString(atUserInfoList), (String)JsonUtil.toString(quoteMessage)));
    }

    public Message createImageMessage(String imagePath) {
        return MessageManager.parse(Open_im_sdk.createImageMessage((String)ParamsUtil.buildOperationID(), (String)imagePath));
    }

    public Message createImageMessageFromFullPath(String imagePath) {
        return MessageManager.parse(Open_im_sdk.createImageMessageFromFullPath((String)ParamsUtil.buildOperationID(), (String)imagePath));
    }

    public Message createSoundMessage(String soundPath, long duration) {
        return MessageManager.parse(Open_im_sdk.createSoundMessage((String)ParamsUtil.buildOperationID(), (String)soundPath, (long)duration));
    }

    public Message createSoundMessageFromFullPath(String soundPath, long duration) {
        return MessageManager.parse(Open_im_sdk.createSoundMessageFromFullPath((String)ParamsUtil.buildOperationID(), (String)soundPath, (long)duration));
    }

    public Message createVideoMessage(String videoPath, String videoType, long duration, String snapshotPath) {
        return MessageManager.parse(Open_im_sdk.createVideoMessage((String)ParamsUtil.buildOperationID(), (String)videoPath, (String)videoType, (long)duration, (String)snapshotPath));
    }

    public Message createVideoMessageFromFullPath(String videoPath, String videoType, long duration, String snapshotPath) {
        return MessageManager.parse(Open_im_sdk.createVideoMessageFromFullPath((String)ParamsUtil.buildOperationID(), (String)videoPath, (String)videoType, (long)duration, (String)snapshotPath));
    }

    public Message createFileMessage(String filePath, String fileName) {
        return MessageManager.parse(Open_im_sdk.createFileMessage((String)ParamsUtil.buildOperationID(), (String)filePath, (String)fileName));
    }

    public Message createFileMessageFromFullPath(String filePath, String fileName) {
        return MessageManager.parse(Open_im_sdk.createFileMessageFromFullPath((String)ParamsUtil.buildOperationID(), (String)filePath, (String)fileName));
    }

    public Message createMergerMessage(List<Message> messageList, String title, List<String> summaryList) {
        return MessageManager.parse(Open_im_sdk.createMergerMessage((String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(messageList), (String)title, (String)JsonUtil.toString(summaryList)));
    }

    public Message createForwardMessage(Message message) {
        return MessageManager.parse(Open_im_sdk.createForwardMessage((String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(message)));
    }

    public Message createLocationMessage(double latitude, double longitude, String description) {
        return MessageManager.parse(Open_im_sdk.createLocationMessage((String)ParamsUtil.buildOperationID(), (String)description, (double)longitude, (double)latitude));
    }

    public Message createCustomMessage(String data, String extension, String description) {
        return MessageManager.parse(Open_im_sdk.createCustomMessage((String)ParamsUtil.buildOperationID(), (String)data, (String)extension, (String)description));
    }

    public Message createQuoteMessage(String text, Message message) {
        return MessageManager.parse(Open_im_sdk.createQuoteMessage((String)ParamsUtil.buildOperationID(), (String)text, (String)JsonUtil.toString(message)));
    }

    public Message createCardMessage(String content) {
        return MessageManager.parse(Open_im_sdk.createCardMessage((String)ParamsUtil.buildOperationID(), (String)content));
    }

    public Message createFaceMessage(long index, String data) {
        return MessageManager.parse(Open_im_sdk.createFaceMessage((String)ParamsUtil.buildOperationID(), (long)index, (String)data));
    }

    public void clearC2CHistoryMessage(OnBase<String> base, String uid) {
        Open_im_sdk.clearC2CHistoryMessage((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)uid);
    }

    public void clearGroupHistoryMessage(OnBase<String> base, String gid) {
        Open_im_sdk.clearGroupHistoryMessage((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)gid);
    }

    public void searchLocalMessages(OnBase<SearchResult> base, String conversationID, List<String> keywordList, int keywordListMatchType, List<String> senderUserIDList, List<Integer> messageTypeList, int searchTimePosition, int searchTimePeriod, int pageIndex, int count) {
        ArrayMap map = new ArrayMap();
        map.put("conversationID", conversationID);
        map.put("keywordList", keywordList);
        map.put("keywordListMatchType", keywordListMatchType);
        map.put("senderUserIDList", senderUserIDList);
        map.put("messageTypeList", messageTypeList);
        map.put("searchTimePosition", searchTimePosition);
        map.put("searchTimePeriod", searchTimePeriod);
        map.put("pageIndex", pageIndex);
        map.put("count", count);
        Open_im_sdk.searchLocalMessages((Base)BaseImpl.objectBase(base, SearchResult.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(map));
    }

    public void deleteMessageFromLocalAndSvr(OnBase<String> base, Message message) {
        Open_im_sdk.deleteMessageFromLocalAndSvr((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(message));
    }

    public void deleteAllMsgFromLocal(OnBase<String> base) {
        Open_im_sdk.deleteAllMsgFromLocal((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID());
    }

    public void deleteAllMsgFromLocalAndSvr(OnBase<String> base) {
        Open_im_sdk.deleteAllMsgFromLocalAndSvr((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID());
    }

    public void markMessageAsReadByConID(OnBase<String> base, String conversationID, List<String> messageIDList) {
        Open_im_sdk.markMessageAsReadByConID((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)conversationID, (String)JsonUtil.toString(messageIDList));
    }

    public void clearC2CHistoryMessageFromLocalAndSvr(OnBase<String> base, String uid) {
        Open_im_sdk.clearC2CHistoryMessageFromLocalAndSvr((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)uid);
    }

    public void clearGroupHistoryMessageFromLocalAndSvr(OnBase<String> base, String gid) {
        Open_im_sdk.clearGroupHistoryMessageFromLocalAndSvr((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)gid);
    }

    public void getHistoryMessageListReverse(OnBase<List<Message>> base, String userID, String groupID, String conversationID, Message startMsg, int count) {
        ArrayMap map = new ArrayMap();
        map.put("userID", userID);
        map.put("groupID", groupID);
        map.put("conversationID", conversationID);
        if (null != startMsg) {
            map.put("startClientMsgID", startMsg.getClientMsgID());
        }
        map.put("count", count);
        Open_im_sdk.getHistoryMessageListReverse((Base)BaseImpl.arrayBase(base, Message.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(map));
    }

    public void revokeMessageV2(OnBase<String> base, Message message) {
        Open_im_sdk.newRevokeMessage((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(message));
    }

    public void getAdvancedHistoryMessageList(OnBase<AdvancedMessage> base, String userID, String groupID, String conversationID, int lastMinSeq, Message startMsg, int count) {
        ArrayMap map = new ArrayMap();
        map.put("userID", userID);
        map.put("groupID", groupID);
        map.put("conversationID", conversationID);
        map.put("lastMinSeq", lastMinSeq);
        if (null != startMsg) {
            map.put("startClientMsgID", startMsg.getClientMsgID());
        }
        map.put("count", count);
        Open_im_sdk.getAdvancedHistoryMessageList((Base)BaseImpl.objectBase(base, AdvancedMessage.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(map));
    }

    public void findMessageList(OnBase<SearchResult> base, List<SearchParams> searchParams) {
        Open_im_sdk.findMessageList((Base)BaseImpl.objectBase(base, SearchResult.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(searchParams));
    }

    public Message createAdvancedTextMessage(String text, List<RichMessage> richList) {
        return MessageManager.parse(Open_im_sdk.createAdvancedTextMessage((String)ParamsUtil.buildOperationID(), (String)text, (String)JsonUtil.toString(richList)));
    }

    public Message createAdvancedQuoteMessage(String text, Message message, List<RichMessage> richList) {
        return MessageManager.parse(Open_im_sdk.createAdvancedQuoteMessage((String)ParamsUtil.buildOperationID(), (String)text, (String)JsonUtil.toString(message), (String)JsonUtil.toString(richList)));
    }

    public void sendMessageNotOss(OnMsgSendCallback base, Message message, String recvUid, String recvGid, OfflinePushInfo offlinePushInfo) {
        Open_im_sdk.sendMessageNotOss((SendMsgCallBack)new _MsgSendProgressListener(base), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(message), (String)recvUid, (String)recvGid, (String)JsonUtil.toString(offlinePushInfo));
    }

    public Message createImageMessageByURL(PictureInfo sourcePicture, PictureInfo bigPicture, PictureInfo snapshotPicture) {
        return MessageManager.parse(Open_im_sdk.createImageMessageByURL((String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(sourcePicture), (String)JsonUtil.toString(bigPicture), (String)JsonUtil.toString(snapshotPicture)));
    }

    public Message createSoundMessageByURL(SoundElem soundElem) {
        return MessageManager.parse(Open_im_sdk.createSoundMessageByURL((String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(soundElem)));
    }

    public Message createVideoMessageByURL(VideoElem videoElem) {
        return MessageManager.parse(Open_im_sdk.createVideoMessageByURL((String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(videoElem)));
    }

    public Message createFileMessageByURL(FileElem fileElem) {
        return MessageManager.parse(Open_im_sdk.createFileMessageByURL((String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(fileElem)));
    }

    public void setCustomBusinessListener(io.openim.android.sdk.listener.OnCustomBusinessListener listener) {
        Open_im_sdk.setCustomBusinessListener((OnCustomBusinessListener)new _CustomBusinessListener(listener));
    }

    public void setMessageKvInfoListener(OnMessageKvInfoListener listener) {
        Open_im_sdk.setMessageKvInfoListener((open_im_sdk_callback.OnMessageKvInfoListener)new _MessageKvInfoListener(listener));
    }

    public void setMessageReactionExtensions(OnBase<List<TypeKeySetResult>> base, Message message, List<KeyValue> list) {
        Open_im_sdk.setMessageReactionExtensions((Base)BaseImpl.arrayBase(base, TypeKeySetResult.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(message), (String)JsonUtil.toString(list));
    }

    public void deleteMessageReactionExtensions(OnBase<List<TypeKeySetResult>> base, Message message, List<String> list) {
        Open_im_sdk.deleteMessageReactionExtensions((Base)BaseImpl.arrayBase(base, TypeKeySetResult.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(message), (String)JsonUtil.toString(list));
    }

    public void getMessageListReactionExtensions(OnBase<List<MessageTypeKeyMapping>> base, List<Message> messageList) {
        Open_im_sdk.getMessageListReactionExtensions((Base)BaseImpl.arrayBase(base, MessageTypeKeyMapping.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(messageList));
    }

    public void addMessageReactionExtensions(OnBase<List<TypeKeySetResult>> base, Message message, List<KeyValue> list) {
        Open_im_sdk.addMessageReactionExtensions((Base)BaseImpl.arrayBase(base, TypeKeySetResult.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(message), (String)JsonUtil.toString(list));
    }

    public void getMessageListSomeReactionExtensions(OnBase<List<MessageTypeKeyMapping>> base, List<Message> messageList, List<KeyValue> kvList) {
        Open_im_sdk.getMessageListSomeReactionExtensions((Base)BaseImpl.arrayBase(base, MessageTypeKeyMapping.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(messageList), (String)JsonUtil.toString(kvList));
    }

    static Message parse(String msg) {
        return JsonUtil.toObj(msg, Message.class);
    }
}

