/*
 * Decompiled with CFR 0.152.
 */
package io.openim.android.sdk.manager;

import io.openim.android.sdk.listener.BaseImpl;
import io.openim.android.sdk.listener.OnBase;
import io.openim.android.sdk.listener.OnConversationListener;
import io.openim.android.sdk.listener._ConversationListener;
import io.openim.android.sdk.models.ConversationInfo;
import io.openim.android.sdk.models.NotDisturbInfo;
import io.openim.android.sdk.utils.JsonUtil;
import io.openim.android.sdk.utils.ParamsUtil;
import java.util.Comparator;
import java.util.List;
import open_im_sdk.Open_im_sdk;
import open_im_sdk_callback.Base;

public class ConversationManager {
    public void setOnConversationListener(OnConversationListener listener) {
        Open_im_sdk.setConversationListener((open_im_sdk_callback.OnConversationListener)new _ConversationListener(listener));
    }

    public void getAllConversationList(OnBase<List<ConversationInfo>> base) {
        Open_im_sdk.getAllConversationList((Base)BaseImpl.arrayBase(base, ConversationInfo.class), (String)ParamsUtil.buildOperationID());
    }

    public void getConversationListSplit(OnBase<List<ConversationInfo>> base, long offset, long count) {
        Open_im_sdk.getConversationListSplit((Base)BaseImpl.arrayBase(base, ConversationInfo.class), (String)ParamsUtil.buildOperationID(), (long)offset, (long)count);
    }

    public void getOneConversation(OnBase<ConversationInfo> base, String sourceId, long sessionType) {
        Open_im_sdk.getOneConversation((Base)BaseImpl.objectBase(base, ConversationInfo.class), (String)ParamsUtil.buildOperationID(), (long)sessionType, (String)sourceId);
    }

    public void getMultipleConversation(OnBase<List<ConversationInfo>> base, List<String> conversationIDs) {
        Open_im_sdk.getMultipleConversation((Base)BaseImpl.arrayBase(base, ConversationInfo.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(conversationIDs));
    }

    public void deleteConversation(OnBase<String> base, String conversationID) {
        Open_im_sdk.deleteConversation((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)conversationID);
    }

    public void setConversationDraft(OnBase<String> base, String conversationID, String draftText) {
        Open_im_sdk.setConversationDraft((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)conversationID, (String)draftText);
    }

    public void pinConversation(OnBase<String> base, String conversationID, boolean isPinned) {
        Open_im_sdk.pinConversation((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)conversationID, (boolean)isPinned);
    }

    public void markGroupMessageHasRead(OnBase<String> base, String groupID) {
        Open_im_sdk.markGroupMessageHasRead((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)groupID);
    }

    public void getTotalUnreadMsgCount(OnBase<String> base) {
        Open_im_sdk.getTotalUnreadMsgCount((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID());
    }

    public String getConversationIDBySessionType(String sourceId, long sessionType) {
        return Open_im_sdk.getConversationIDBySessionType((String)sourceId, (long)sessionType);
    }

    public void setConversationRecvMessageOpt(OnBase<String> base, List<String> conversationIDs, long status) {
        Open_im_sdk.setConversationRecvMessageOpt((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(conversationIDs), (long)status);
    }

    public void getConversationRecvMessageOpt(OnBase<List<NotDisturbInfo>> base, List<String> conversationIDs) {
        Open_im_sdk.getConversationRecvMessageOpt((Base)BaseImpl.arrayBase(base, NotDisturbInfo.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(conversationIDs));
    }

    public void setOneConversationPrivateChat(OnBase<String> base, String conversionID, boolean isPrivate) {
        Open_im_sdk.setOneConversationPrivateChat((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)conversionID, (boolean)isPrivate);
    }

    public void deleteConversationFromLocalAndSvr(OnBase<String> base, String conversionID) {
        Open_im_sdk.deleteConversationFromLocalAndSvr((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)conversionID);
    }

    public void deleteAllConversationFromLocal(OnBase<String> base) {
        Open_im_sdk.deleteAllConversationFromLocal((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID());
    }

    public void resetConversationGroupAtType(OnBase<String> base, String conversationID) {
        Open_im_sdk.resetConversationGroupAtType((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)conversationID);
    }

    public String getAtAllTag() {
        return Open_im_sdk.getAtAllTag();
    }

    public void setGlobalRecvMessageOpt(OnBase<String> base, long status) {
        Open_im_sdk.setGlobalRecvMessageOpt((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (long)status);
    }

    public void setOneConversationBurnDuration(OnBase<String> base, String conversationID, int burnDuration) {
        Open_im_sdk.setOneConversationBurnDuration((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)conversationID, (int)burnDuration);
    }

    public Comparator<ConversationInfo> simpleComparator() {
        return (a, b) -> {
            if (a.isPinned() && b.isPinned() || !a.isPinned() && !b.isPinned()) {
                long aCompare = Math.max(a.getDraftTextTime(), a.getLatestMsgSendTime());
                long bCompare = Math.max(b.getDraftTextTime(), b.getLatestMsgSendTime());
                return Long.compare(bCompare, aCompare);
            }
            if (a.isPinned() && !b.isPinned()) {
                return -1;
            }
            return 1;
        };
    }
}

