/*
 * Decompiled with CFR 0.152.
 */
package io.openim.android.sdk.manager;

import android.util.ArrayMap;
import io.openim.android.sdk.listener.BaseImpl;
import io.openim.android.sdk.listener.OnBase;
import io.openim.android.sdk.listener.OnSignalingListener;
import io.openim.android.sdk.listener._SignalingListener;
import io.openim.android.sdk.models.MeetingInfoList;
import io.openim.android.sdk.models.RoomCallingInfo;
import io.openim.android.sdk.models.SignalingCertificate;
import io.openim.android.sdk.models.SignalingInfo;
import io.openim.android.sdk.utils.JsonUtil;
import io.openim.android.sdk.utils.ParamsUtil;
import java.util.List;
import java.util.Map;
import open_im_sdk.Open_im_sdk;
import open_im_sdk_callback.Base;

public class SignalingManager {
    public void setSignalingListener(OnSignalingListener listener) {
        Open_im_sdk.setSignalingListener((open_im_sdk_callback.OnSignalingListener)new _SignalingListener(listener));
    }

    public void signalingInvite(OnBase<SignalingCertificate> base, SignalingInfo info) {
        Open_im_sdk.signalingInvite((Base)BaseImpl.objectBase(base, SignalingCertificate.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(info));
    }

    public void signalingInviteInGroup(OnBase<SignalingCertificate> base, SignalingInfo info) {
        Open_im_sdk.signalingInviteInGroup((Base)BaseImpl.objectBase(base, SignalingCertificate.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(info));
    }

    public void signalingAccept(OnBase<SignalingCertificate> base, SignalingInfo info) {
        Open_im_sdk.signalingAccept((Base)BaseImpl.objectBase(base, SignalingCertificate.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(info));
    }

    public void signalingReject(OnBase<String> base, SignalingInfo info) {
        Open_im_sdk.signalingReject((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(info));
    }

    public void signalingCancel(OnBase<String> base, SignalingInfo info) {
        Open_im_sdk.signalingCancel((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(info));
    }

    public void signalingHungUp(OnBase<String> base, SignalingInfo info) {
        Open_im_sdk.signalingHungUp((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(info));
    }

    public void signalingGetRoomByGroupID(OnBase<RoomCallingInfo> base, String groupID) {
        Open_im_sdk.signalingGetRoomByGroupID((Base)BaseImpl.objectBase(base, RoomCallingInfo.class), (String)ParamsUtil.buildOperationID(), (String)groupID);
    }

    public void signalingGetTokenByRoomID(OnBase<SignalingCertificate> base, String roomID) {
        Open_im_sdk.signalingGetTokenByRoomID((Base)BaseImpl.objectBase(base, SignalingCertificate.class), (String)ParamsUtil.buildOperationID(), (String)roomID);
    }

    public void signalingUpdateMeetingInfo(OnBase<String> base, Map<String, Object> configure) {
        Open_im_sdk.signalingUpdateMeetingInfo((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(configure));
    }

    public void signalingCreateMeeting(OnBase<SignalingCertificate> base, String meetingName, String meetingHostUserID, long startTime, long duration, List<String> inviteeUserIDList, String ex) {
        ArrayMap map = new ArrayMap();
        map.put("meetingName", meetingName);
        map.put("meetingHostUserID", meetingHostUserID);
        map.put("startTime", startTime);
        map.put("meetingDuration", duration);
        map.put("inviteeUserIDList", inviteeUserIDList);
        map.put("ex", ex);
        Open_im_sdk.signalingCreateMeeting((Base)BaseImpl.objectBase(base, SignalingCertificate.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(map));
    }

    public void signalingJoinMeeting(OnBase<SignalingCertificate> base, String roomID, String meetingName, String participantNickname) {
        ArrayMap map = new ArrayMap();
        map.put("roomID", roomID);
        map.put("meetingName", meetingName);
        map.put("participantNickname", participantNickname);
        Open_im_sdk.signalingJoinMeeting((Base)BaseImpl.objectBase(base, SignalingCertificate.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(map));
    }

    public void signalingOperateStream(OnBase<String> base, String roomID, String streamType, String userID, boolean mute, boolean muteAll) {
        Open_im_sdk.signalingOperateStream((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)streamType, (String)roomID, (String)userID, (boolean)mute, (boolean)muteAll);
    }

    public void signalingGetMeetings(OnBase<MeetingInfoList> base) {
        Open_im_sdk.signalingGetMeetings((Base)BaseImpl.objectBase(base, MeetingInfoList.class), (String)ParamsUtil.buildOperationID());
    }

    public void signalingCloseRoom(OnBase<String> base, String roomID) {
        Open_im_sdk.signalingCloseRoom((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)roomID);
    }

    public void signalingSendCustomSignal(OnBase<String> base, String roomID, String customInfo) {
        Open_im_sdk.signalingSendCustomSignal((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)customInfo, (String)roomID);
    }

    public void getSignalingInvitationInfoStartApp(OnBase<SignalingInfo> callBack) {
        Open_im_sdk.getSignalingInvitationInfoStartApp((Base)BaseImpl.objectBase(callBack, SignalingInfo.class), (String)ParamsUtil.buildOperationID());
    }
}

