/*
 * Decompiled with CFR 0.152.
 */
package io.openim.android.sdk.manager;

import android.text.TextUtils;
import android.util.ArrayMap;
import io.openim.android.sdk.listener.BaseImpl;
import io.openim.android.sdk.listener.OnAdvanceMsgListener;
import io.openim.android.sdk.listener.OnBase;
import io.openim.android.sdk.listener.OnMessageKvInfoListener;
import io.openim.android.sdk.listener.OnMsgSendCallback;
import io.openim.android.sdk.listener._AdvanceMsgListener;
import io.openim.android.sdk.listener._CustomBusinessListener;
import io.openim.android.sdk.listener._MessageKvInfoListener;
import io.openim.android.sdk.listener._MsgSendProgressListener;
import io.openim.android.sdk.models.AdvancedMessage;
import io.openim.android.sdk.models.AtUserInfo;
import io.openim.android.sdk.models.CardElem;
import io.openim.android.sdk.models.FileElem;
import io.openim.android.sdk.models.GroupMembersInfo;
import io.openim.android.sdk.models.Message;
import io.openim.android.sdk.models.OfflinePushInfo;
import io.openim.android.sdk.models.PictureInfo;
import io.openim.android.sdk.models.RichMessage;
import io.openim.android.sdk.models.SearchParams;
import io.openim.android.sdk.models.SearchResult;
import io.openim.android.sdk.models.SoundElem;
import io.openim.android.sdk.models.VideoElem;
import io.openim.android.sdk.utils.CommonUtil;
import io.openim.android.sdk.utils.JsonUtil;
import io.openim.android.sdk.utils.ParamsUtil;
import java.util.List;
import open_im_sdk.Open_im_sdk;
import open_im_sdk_callback.Base;
import open_im_sdk_callback.OnAdvancedMsgListener;
import open_im_sdk_callback.OnCustomBusinessListener;
import open_im_sdk_callback.SendMsgCallBack;

public class MessageManager {
    private int lastMinSeq;
    private String lastConversationID;

    public void sendGroupMessageReadReceipt(String conversationID, List<String> clientMsgIDs, OnBase<String> callBack) {
        Open_im_sdk.sendGroupMessageReadReceipt((Base)BaseImpl.stringBase(callBack), (String)ParamsUtil.buildOperationID(), (String)conversationID, (String)JsonUtil.toString(clientMsgIDs));
    }

    public void getGroupMessageReaderList(String conversationID, String clientMsgID, int filter, int offset, int count, OnBase<List<GroupMembersInfo>> callBack) {
        Open_im_sdk.getGroupMessageReaderList((Base)BaseImpl.arrayBase(callBack, GroupMembersInfo.class), (String)ParamsUtil.buildOperationID(), (String)conversationID, (String)clientMsgID, (int)filter, (int)offset, (int)count);
    }

    public void setAdvancedMsgListener(OnAdvanceMsgListener listener) {
        Open_im_sdk.setAdvancedMsgListener((OnAdvancedMsgListener)new _AdvanceMsgListener(listener));
    }

    public void sendMessage(OnMsgSendCallback base, Message message, String recvUid, String recvGid, OfflinePushInfo offlinePushInfo) {
        Open_im_sdk.sendMessage((SendMsgCallBack)new _MsgSendProgressListener(base), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(message), (String)recvUid, (String)recvGid, (String)JsonUtil.toString(offlinePushInfo));
    }

    public void deleteMessageFromLocalStorage(String conversationID, String clientMsgID, OnBase<String> callBack) {
        Open_im_sdk.deleteMessageFromLocalStorage((Base)BaseImpl.stringBase(callBack), (String)ParamsUtil.buildOperationID(), (String)conversationID, (String)clientMsgID);
    }

    public void insertSingleMessageToLocalStorage(OnBase<String> base, Message message, String receiver, String sender) {
        Open_im_sdk.insertSingleMessageToLocalStorage((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(message), (String)receiver, (String)sender);
    }

    public void insertGroupMessageToLocalStorage(OnBase<String> base, Message message, String groupID, String senderID) {
        Open_im_sdk.insertGroupMessageToLocalStorage((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(message), (String)groupID, (String)senderID);
    }

    public void markMessagesAsReadByMsgID(String conversationID, List<String> clientMsgIDs, OnBase<String> callBack) {
        Open_im_sdk.markMessagesAsReadByMsgID((Base)BaseImpl.stringBase(callBack), (String)ParamsUtil.buildOperationID(), (String)conversationID, (String)JsonUtil.toString(clientMsgIDs));
    }

    public void markConversationMessageAsRead(String conversationID, OnBase<String> callback) {
        Open_im_sdk.markConversationMessageAsRead((Base)BaseImpl.stringBase(callback), (String)ParamsUtil.buildOperationID(), (String)conversationID);
    }

    public void typingStatusUpdate(OnBase<String> base, String userID, String msgTip) {
        Open_im_sdk.typingStatusUpdate((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)userID, (String)msgTip);
    }

    public Message createTextMessage(String text) {
        return MessageManager.parse(Open_im_sdk.createTextMessage((String)ParamsUtil.buildOperationID(), (String)text));
    }

    public Message createTextAtMessage(String text, List<String> atUserIDList, List<AtUserInfo> atUserInfoList, Message quoteMessage) {
        return MessageManager.parse(Open_im_sdk.createTextAtMessage((String)ParamsUtil.buildOperationID(), (String)text, (String)JsonUtil.toString(atUserIDList), (String)JsonUtil.toString(atUserInfoList), (String)JsonUtil.toString(quoteMessage)));
    }

    public Message createImageMessage(String imagePath) {
        return MessageManager.parse(Open_im_sdk.createImageMessage((String)ParamsUtil.buildOperationID(), (String)imagePath));
    }

    public Message createImageMessageFromFullPath(String imagePath) {
        return MessageManager.parse(Open_im_sdk.createImageMessageFromFullPath((String)ParamsUtil.buildOperationID(), (String)imagePath));
    }

    public Message createSoundMessage(String soundPath, long duration) {
        return MessageManager.parse(Open_im_sdk.createSoundMessage((String)ParamsUtil.buildOperationID(), (String)soundPath, (long)duration));
    }

    public Message createSoundMessageFromFullPath(String soundPath, long duration) {
        return MessageManager.parse(Open_im_sdk.createSoundMessageFromFullPath((String)ParamsUtil.buildOperationID(), (String)soundPath, (long)duration));
    }

    public Message createVideoMessage(String videoPath, String videoType, long duration, String snapshotPath) {
        return MessageManager.parse(Open_im_sdk.createVideoMessage((String)ParamsUtil.buildOperationID(), (String)videoPath, (String)videoType, (long)duration, (String)snapshotPath));
    }

    public Message createVideoMessageFromFullPath(String videoPath, String videoType, long duration, String snapshotPath) {
        return MessageManager.parse(Open_im_sdk.createVideoMessageFromFullPath((String)ParamsUtil.buildOperationID(), (String)videoPath, (String)videoType, (long)duration, (String)snapshotPath));
    }

    public Message createFileMessage(String filePath, String fileName) {
        return MessageManager.parse(Open_im_sdk.createFileMessage((String)ParamsUtil.buildOperationID(), (String)filePath, (String)fileName));
    }

    public Message createFileMessageFromFullPath(String filePath, String fileName) {
        return MessageManager.parse(Open_im_sdk.createFileMessageFromFullPath((String)ParamsUtil.buildOperationID(), (String)filePath, (String)fileName));
    }

    public Message createMergerMessage(List<Message> messageList, String title, List<String> summaryList) {
        return MessageManager.parse(Open_im_sdk.createMergerMessage((String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(messageList), (String)title, (String)JsonUtil.toString(summaryList)));
    }

    public Message createForwardMessage(Message message) {
        return MessageManager.parse(Open_im_sdk.createForwardMessage((String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(message)));
    }

    public Message createLocationMessage(double latitude, double longitude, String description) {
        return MessageManager.parse(Open_im_sdk.createLocationMessage((String)ParamsUtil.buildOperationID(), (String)description, (double)longitude, (double)latitude));
    }

    public Message createCustomMessage(String data, String extension, String description) {
        return MessageManager.parse(Open_im_sdk.createCustomMessage((String)ParamsUtil.buildOperationID(), (String)data, (String)extension, (String)description));
    }

    public Message createQuoteMessage(String text, Message message) {
        return MessageManager.parse(Open_im_sdk.createQuoteMessage((String)ParamsUtil.buildOperationID(), (String)text, (String)JsonUtil.toString(message)));
    }

    public Message createCardMessage(CardElem cardElem) {
        return MessageManager.parse(Open_im_sdk.createCardMessage((String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(cardElem)));
    }

    public Message createFaceMessage(long index, String data) {
        return MessageManager.parse(Open_im_sdk.createFaceMessage((String)ParamsUtil.buildOperationID(), (long)index, (String)data));
    }

    public void clearConversationAndDeleteAllMsg(String conversationID, OnBase<String> callBack) {
        Open_im_sdk.clearConversationAndDeleteAllMsg((Base)BaseImpl.stringBase(callBack), (String)ParamsUtil.buildOperationID(), (String)conversationID);
    }

    public void searchLocalMessages(OnBase<SearchResult> base, String conversationID, List<String> keywordList, int keywordListMatchType, List<String> senderUserIDList, List<Integer> messageTypeList, int searchTimePosition, int searchTimePeriod, int pageIndex, int count) {
        ArrayMap map = new ArrayMap();
        map.put("conversationID", conversationID);
        map.put("keywordList", keywordList);
        map.put("keywordListMatchType", keywordListMatchType);
        map.put("senderUserIDList", senderUserIDList);
        map.put("messageTypeList", messageTypeList);
        map.put("searchTimePosition", searchTimePosition);
        map.put("searchTimePeriod", searchTimePeriod);
        map.put("pageIndex", pageIndex);
        map.put("count", count);
        Open_im_sdk.searchLocalMessages((Base)BaseImpl.objectBase(base, SearchResult.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(map));
    }

    public void deleteMessageFromLocalAndSvr(String conversationID, String clientMsgID, OnBase<String> callBack) {
        Open_im_sdk.deleteMessage((Base)BaseImpl.stringBase(callBack), (String)ParamsUtil.buildOperationID(), (String)conversationID, (String)clientMsgID);
    }

    public void deleteAllMsgFromLocal(OnBase<String> base) {
        Open_im_sdk.deleteAllMsgFromLocal((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID());
    }

    public void deleteAllMsgFromLocalAndSvr(OnBase<String> base) {
        Open_im_sdk.deleteAllMsgFromLocalAndSvr((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID());
    }

    public void markMessageAsReadByConID(OnBase<String> callBack, String conversationID) {
        Open_im_sdk.markConversationMessageAsRead((Base)BaseImpl.stringBase(callBack), (String)ParamsUtil.buildOperationID(), (String)conversationID);
    }

    public void revokeMessageV2(OnBase<String> callBack, String conversationID, String clientMsgID) {
        Open_im_sdk.revokeMessage((Base)BaseImpl.stringBase(callBack), (String)ParamsUtil.buildOperationID(), (String)conversationID, (String)clientMsgID);
    }

    public void getAdvancedHistoryMessageList(final OnBase<AdvancedMessage> callBack, String conversationID, Message startMsg, int count) {
        this.isClearSeq(conversationID);
        ArrayMap map = new ArrayMap();
        map.put("lastMinSeq", this.lastMinSeq);
        map.put("conversationID", conversationID);
        if (null != startMsg) {
            map.put("startClientMsgID", startMsg.getClientMsgID());
        }
        map.put("count", count);
        Open_im_sdk.getAdvancedHistoryMessageList((Base)new Base(){

            public void onError(int i, String s) {
                CommonUtil.returnError(callBack, i, s);
            }

            public void onSuccess(String s) {
                AdvancedMessage messageListSeq = JsonUtil.toObj(s, AdvancedMessage.class);
                MessageManager.this.lastMinSeq = messageListSeq.getLastMinSeq();
                CommonUtil.runMainThread(() -> {
                    if (null != callBack) {
                        callBack.onSuccess(messageListSeq);
                    }
                });
            }
        }, (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(map));
    }

    private void isClearSeq(String conversationID) {
        if (!TextUtils.equals((CharSequence)this.lastConversationID, (CharSequence)conversationID)) {
            this.lastMinSeq = 0;
        }
        this.lastConversationID = conversationID;
    }

    public void getAdvancedHistoryMessageListReverse(final OnBase<AdvancedMessage> callBack, String conversationID, Message startMsg, int count) {
        this.isClearSeq(conversationID);
        ArrayMap map = new ArrayMap();
        map.put("lastMinSeq", this.lastMinSeq);
        map.put("conversationID", conversationID);
        if (null != startMsg) {
            map.put("startClientMsgID", startMsg.getClientMsgID());
        }
        map.put("count", count);
        Open_im_sdk.getAdvancedHistoryMessageListReverse((Base)new Base(){

            public void onError(int i, String s) {
                CommonUtil.returnError(callBack, i, s);
            }

            public void onSuccess(String s) {
                AdvancedMessage messageListSeq = JsonUtil.toObj(s, AdvancedMessage.class);
                MessageManager.this.lastMinSeq = messageListSeq.getLastMinSeq();
                CommonUtil.runMainThread(() -> {
                    if (null != callBack) {
                        callBack.onSuccess(messageListSeq);
                    }
                });
            }
        }, (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(map));
    }

    public void findMessageList(OnBase<SearchResult> base, List<SearchParams> searchParams) {
        Open_im_sdk.findMessageList((Base)BaseImpl.objectBase(base, SearchResult.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(searchParams));
    }

    public Message createAdvancedTextMessage(String text, List<RichMessage> richList) {
        return MessageManager.parse(Open_im_sdk.createAdvancedTextMessage((String)ParamsUtil.buildOperationID(), (String)text, (String)JsonUtil.toString(richList)));
    }

    public Message createAdvancedQuoteMessage(String text, Message message, List<RichMessage> richList) {
        return MessageManager.parse(Open_im_sdk.createAdvancedQuoteMessage((String)ParamsUtil.buildOperationID(), (String)text, (String)JsonUtil.toString(message), (String)JsonUtil.toString(richList)));
    }

    public void sendMessageNotOss(OnMsgSendCallback base, Message message, String recvUid, String recvGid, OfflinePushInfo offlinePushInfo) {
        Open_im_sdk.sendMessageNotOss((SendMsgCallBack)new _MsgSendProgressListener(base), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(message), (String)recvUid, (String)recvGid, (String)JsonUtil.toString(offlinePushInfo));
    }

    public Message createImageMessageByURL(String sourcePath, PictureInfo sourcePicture, PictureInfo bigPicture, PictureInfo snapshotPicture) {
        return MessageManager.parse(Open_im_sdk.createImageMessageByURL((String)ParamsUtil.buildOperationID(), (String)sourcePath, (String)JsonUtil.toString(sourcePicture), (String)JsonUtil.toString(bigPicture), (String)JsonUtil.toString(snapshotPicture)));
    }

    public Message createSoundMessageByURL(SoundElem soundElem) {
        return MessageManager.parse(Open_im_sdk.createSoundMessageByURL((String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(soundElem)));
    }

    public Message createVideoMessageByURL(VideoElem videoElem) {
        return MessageManager.parse(Open_im_sdk.createVideoMessageByURL((String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(videoElem)));
    }

    public Message createFileMessageByURL(FileElem fileElem) {
        return MessageManager.parse(Open_im_sdk.createFileMessageByURL((String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(fileElem)));
    }

    public void setMessageLocalEx(OnBase<String> callBack, String conversationID, String clientMsgID, String localEx) {
        Open_im_sdk.setMessageLocalEx((Base)BaseImpl.stringBase(callBack), (String)ParamsUtil.buildOperationID(), (String)conversationID, (String)clientMsgID, (String)localEx);
    }

    public void setCustomBusinessListener(io.openim.android.sdk.listener.OnCustomBusinessListener listener) {
        Open_im_sdk.setCustomBusinessListener((OnCustomBusinessListener)new _CustomBusinessListener(listener));
    }

    public void setMessageKvInfoListener(OnMessageKvInfoListener listener) {
        Open_im_sdk.setMessageKvInfoListener((open_im_sdk_callback.OnMessageKvInfoListener)new _MessageKvInfoListener(listener));
    }

    static Message parse(String msg) {
        return JsonUtil.toObj(msg, Message.class);
    }
}

