/*
 * Decompiled with CFR 0.152.
 */
package io.openim.android.sdk;

import android.app.Application;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ProcessLifecycleOwner;
import io.openim.android.sdk.internal.log.LogcatHelper;
import io.openim.android.sdk.listener.BaseImpl;
import io.openim.android.sdk.listener.OnBase;
import io.openim.android.sdk.listener.OnConnListener;
import io.openim.android.sdk.listener.OnCustomBusinessListener;
import io.openim.android.sdk.listener.OnListenerForService;
import io.openim.android.sdk.listener.OnPutFileListener;
import io.openim.android.sdk.listener._ConnListener;
import io.openim.android.sdk.listener._CustomBusinessListener;
import io.openim.android.sdk.listener._PutFileCallback;
import io.openim.android.sdk.manager.ConversationManager;
import io.openim.android.sdk.manager.FriendshipManager;
import io.openim.android.sdk.manager.GroupManager;
import io.openim.android.sdk.manager.MessageManager;
import io.openim.android.sdk.manager.UserInfoManager;
import io.openim.android.sdk.models.InitConfig;
import io.openim.android.sdk.models.PutArgs;
import io.openim.android.sdk.utils.CommonUtil;
import io.openim.android.sdk.utils.JsonUtil;
import io.openim.android.sdk.utils.ParamsUtil;
import java.util.List;
import open_im_sdk.Open_im_sdk;
import open_im_sdk_callback.Base;
import open_im_sdk_callback.UploadFileCallback;
import org.jetbrains.annotations.NotNull;

public class OpenIMClient {
    public ConversationManager conversationManager;
    public FriendshipManager friendshipManager;
    public GroupManager groupManager;
    public MessageManager messageManager;
    public UserInfoManager userInfoManager;
    private Application app;
    private final ConnectivityManager.NetworkCallback networkCallback = new ConnectivityManager.NetworkCallback(){

        public void onAvailable(@NonNull Network network) {
            OpenIMClient.this.networkChanged();
        }

        public void onLosing(@NonNull Network network, int maxMsToLive) {
            OpenIMClient.this.networkChanged();
        }

        public void onCapabilitiesChanged(@NonNull Network network, @NonNull NetworkCapabilities networkCapabilities) {
            OpenIMClient.this.networkChanged();
        }

        public void onLinkPropertiesChanged(@NonNull Network network, @NonNull LinkProperties linkProperties) {
            OpenIMClient.this.networkChanged();
        }
    };

    private OpenIMClient() {
        this.conversationManager = new ConversationManager();
        this.friendshipManager = new FriendshipManager();
        this.groupManager = new GroupManager();
        this.messageManager = new MessageManager();
        this.userInfoManager = new UserInfoManager();
    }

    public static OpenIMClient getInstance() {
        return Singleton.INSTANCE;
    }

    public boolean initSDK(Application application, InitConfig initConfig, @NotNull OnConnListener listener) {
        this.app = application;
        boolean initialized = Open_im_sdk.initSDK((open_im_sdk_callback.OnConnListener)new _ConnListener(listener), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(initConfig));
        LogcatHelper.logDInDebug(String.format("Initialization successful: %s", initialized));
        return initialized;
    }

    public void unInit() {
        Open_im_sdk.unInitSDK((String)ParamsUtil.buildOperationID());
    }

    private void registerNetworkCallback() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.app.getSystemService("connectivity");
        if (Build.VERSION.SDK_INT >= 26) {
            connectivityManager.registerDefaultNetworkCallback(this.networkCallback);
        } else {
            NetworkRequest.Builder builder = new NetworkRequest.Builder();
            NetworkRequest request = builder.build();
            connectivityManager.registerNetworkCallback(request, this.networkCallback);
        }
    }

    private void registerActivityLifecycleCallbacks() {
        ProcessLifecycleOwner.get().getLifecycle().addObserver((LifecycleObserver)new DefaultLifecycleObserver(){

            public void onResume(@NonNull LifecycleOwner owner) {
                OpenIMClient.setAppBackgroundStatus(false);
            }

            public void onStop(@NonNull LifecycleOwner owner) {
                OpenIMClient.setAppBackgroundStatus(true);
            }
        });
    }

    private static void setAppBackgroundStatus(boolean isBackground) {
        Open_im_sdk.setAppBackgroundStatus((Base)new Base(){

            public void onError(int i, String s) {
            }

            public void onSuccess(String s) {
            }
        }, (String)ParamsUtil.buildOperationID(), (boolean)isBackground);
    }

    public void login(final @NotNull OnBase<String> base, String uid, String token) {
        Open_im_sdk.login((Base)new Base(){

            public void onError(int i, String s) {
                CommonUtil.returnError(base, i, s);
            }

            public void onSuccess(String s) {
                CommonUtil.runMainThread(() -> base.onSuccess(s));
            }
        }, (String)ParamsUtil.buildOperationID(), (String)uid, (String)token);
    }

    public void logout(OnBase<String> base) {
        Open_im_sdk.logout((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID());
    }

    public int getLoginStatus() {
        return (int)Open_im_sdk.getLoginStatus((String)ParamsUtil.buildOperationID());
    }

    public String getLoginUserID() {
        return Open_im_sdk.getLoginUserID();
    }

    public void uploadFile(OnBase<String> base, OnPutFileListener listener, PutArgs putArgs) {
        Open_im_sdk.uploadFile((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(putArgs), (UploadFileCallback)new _PutFileCallback(listener));
    }

    public void uploadLogs(OnBase<String> base, List<String> params) {
        Open_im_sdk.uploadLogs((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(params));
    }

    public void updateFcmToken(OnBase<String> base, String fcmToken, long expireTime) {
        Open_im_sdk.updateFcmToken((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)fcmToken, (long)expireTime);
    }

    public void setOnListenerForService(OnListenerForService listener) {
    }

    public void networkChanged() {
        Open_im_sdk.networkStatusChanged((Base)new Base(){

            public void onError(int i, String s) {
            }

            public void onSuccess(String s) {
            }
        }, (String)ParamsUtil.buildOperationID());
    }

    public void setCustomBusinessListener(OnCustomBusinessListener customBusinessListener) {
        Open_im_sdk.setCustomBusinessListener((open_im_sdk_callback.OnCustomBusinessListener)new _CustomBusinessListener(customBusinessListener));
    }

    private static class Singleton {
        private static final OpenIMClient INSTANCE = new OpenIMClient();

        private Singleton() {
        }
    }
}

