/*
 * Decompiled with CFR 0.152.
 */
package io.openim.android.sdk.manager;

import android.util.ArrayMap;
import io.openim.android.sdk.listener.BaseImpl;
import io.openim.android.sdk.listener.OnBase;
import io.openim.android.sdk.listener.OnFriendshipListener;
import io.openim.android.sdk.listener._FriendshipListener;
import io.openim.android.sdk.models.FriendApplicationInfo;
import io.openim.android.sdk.models.FriendInfo;
import io.openim.android.sdk.models.FriendshipInfo;
import io.openim.android.sdk.models.UserInfo;
import io.openim.android.sdk.utils.JsonUtil;
import io.openim.android.sdk.utils.ParamsUtil;
import java.util.List;
import open_im_sdk.Open_im_sdk;
import open_im_sdk_callback.Base;

public class FriendshipManager {
    public void setOnFriendshipListener(OnFriendshipListener listener) {
        Open_im_sdk.setFriendListener((open_im_sdk_callback.OnFriendshipListener)new _FriendshipListener(listener));
    }

    public void getFriendsInfo(OnBase<List<UserInfo>> base, List<String> uidList) {
        Open_im_sdk.getSpecifiedFriendsInfo((Base)BaseImpl.arrayBase(base, UserInfo.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(uidList));
    }

    public void addFriend(OnBase<String> base, String uid, String reqMessage) {
        ArrayMap params = new ArrayMap();
        params.put("toUserID", uid);
        params.put("reqMsg", reqMessage);
        Open_im_sdk.addFriend((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(params));
    }

    public void getRecvFriendApplicationList(OnBase<List<FriendApplicationInfo>> base) {
        Open_im_sdk.getFriendApplicationListAsRecipient((Base)BaseImpl.arrayBase(base, FriendApplicationInfo.class), (String)ParamsUtil.buildOperationID());
    }

    public void getSendFriendApplicationList(OnBase<List<FriendApplicationInfo>> base) {
        Open_im_sdk.getFriendApplicationListAsApplicant((Base)BaseImpl.arrayBase(base, FriendApplicationInfo.class), (String)ParamsUtil.buildOperationID());
    }

    public void getFriendList(OnBase<List<UserInfo>> base) {
        Open_im_sdk.getFriendList((Base)BaseImpl.arrayBase(base, UserInfo.class), (String)ParamsUtil.buildOperationID());
    }

    public void setFriendRemark(OnBase<String> base, String uid, String remark) {
        ArrayMap params = new ArrayMap();
        params.put("toUserID", uid);
        params.put("remark", remark);
        Open_im_sdk.setFriendRemark((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(params));
    }

    public void addBlacklist(OnBase<String> base, String uid, String ex) {
        Open_im_sdk.addBlack((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)uid, (String)ex);
    }

    public void addBlacklist(OnBase<String> base, String uid) {
        Open_im_sdk.addBlack((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)uid, null);
    }

    public void getBlacklist(OnBase<List<UserInfo>> base) {
        Open_im_sdk.getBlackList((Base)BaseImpl.arrayBase(base, UserInfo.class), (String)ParamsUtil.buildOperationID());
    }

    public void removeBlacklist(OnBase<String> base, String uid) {
        Open_im_sdk.removeBlack((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)uid);
    }

    public void checkFriend(OnBase<List<FriendshipInfo>> base, List<String> uidList) {
        Open_im_sdk.checkFriend((Base)BaseImpl.arrayBase(base, FriendshipInfo.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(uidList));
    }

    public void deleteFriend(OnBase<String> base, String uid) {
        Open_im_sdk.deleteFriend((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)uid);
    }

    public void refuseFriendApplication(OnBase<String> base, String uid, String handleMsg) {
        ArrayMap params = new ArrayMap();
        params.put("toUserID", uid);
        params.put("handleMsg", handleMsg);
        Open_im_sdk.refuseFriendApplication((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(params));
    }

    public void acceptFriendApplication(OnBase<String> base, String uid, String handleMsg) {
        ArrayMap params = new ArrayMap();
        params.put("toUserID", uid);
        params.put("handleMsg", handleMsg);
        Open_im_sdk.acceptFriendApplication((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(params));
    }

    public void searchFriends(OnBase<List<FriendInfo>> base, List<String> keywordList, boolean isSearchUserID, boolean isSearchNickname, boolean isSearchRemark) {
        ArrayMap params = new ArrayMap();
        params.put("keywordList", keywordList);
        params.put("isSearchUserID", isSearchUserID);
        params.put("isSearchNickname", isSearchNickname);
        params.put("isSearchRemark", isSearchRemark);
        Open_im_sdk.searchFriends((Base)BaseImpl.arrayBase(base, FriendInfo.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(params));
    }
}

