/*
 * Decompiled with CFR 0.152.
 */
package io.openim.android.sdk.utils;

import android.os.Handler;
import android.os.Looper;
import io.openim.android.sdk.listener.OnBase;
import io.openim.android.sdk.utils.JsonUtil;
import java.util.List;

public class CommonUtil {
    private static final Handler UIHandler = new Handler(Looper.getMainLooper());

    public static void runMainThread(Runnable runnable) {
        UIHandler.post(runnable);
    }

    public static <T> void returnError(OnBase<T> onBase, int code, String error) {
        if (onBase != null) {
            CommonUtil.runMainThread(() -> onBase.onError(code, error));
        }
    }

    public static void returnSuccess(OnBase<String> onBase, String s) {
        if (onBase != null) {
            CommonUtil.runMainThread(() -> onBase.onSuccess(s));
        }
    }

    public static <T> void returnObject(OnBase<T> onBase, Class<T> clazz, String s) {
        if (onBase != null) {
            try {
                Object obj = JsonUtil.toObj(s, clazz);
                CommonUtil.runMainThread(() -> onBase.onSuccess(obj));
            }
            catch (Exception e) {
                CommonUtil.runMainThread(() -> onBase.onError(-1, e.getMessage()));
            }
        }
    }

    public static <T> void returnList(OnBase<List<T>> onBase, Class<T> clazz, String s) {
        if (onBase != null) {
            try {
                List list = JsonUtil.toArray(s, clazz);
                CommonUtil.runMainThread(() -> onBase.onSuccess(list));
            }
            catch (Exception e) {
                CommonUtil.runMainThread(() -> onBase.onError(-1, e.getMessage()));
            }
        }
    }
}

