/*
 * Decompiled with CFR 0.152.
 */
package io.openim.android.sdk.listener;

import io.openim.android.sdk.listener.OnBase;
import io.openim.android.sdk.utils.CommonUtil;
import java.util.List;
import open_im_sdk_callback.Base;

public final class BaseImpl {
    public static Base stringBase(OnBase<String> base) {
        return new StringBase(base);
    }

    public static <T> Base arrayBase(OnBase<List<T>> base, Class<T> clazz) {
        return new ArrayBase<T>(base, clazz);
    }

    public static <T> Base objectBase(OnBase<T> base, Class<T> clazz) {
        return new ObjectBase<T>(base, clazz);
    }

    private static class StringBase
    implements Base {
        OnBase<String> base;

        public StringBase(OnBase<String> base) {
            this.base = base;
        }

        public void onError(int l, String s) {
            CommonUtil.returnError(this.base, l, s);
        }

        public void onSuccess(String s) {
            CommonUtil.returnSuccess(this.base, s);
        }
    }

    private static class ArrayBase<T>
    implements Base {
        OnBase<List<T>> base;
        Class<T> clazz;

        public ArrayBase(OnBase<List<T>> base, Class<T> clazz) {
            this.base = base;
            this.clazz = clazz;
        }

        public void onError(int l, String s) {
            CommonUtil.returnError(this.base, l, s);
        }

        public void onSuccess(String s) {
            CommonUtil.returnList(this.base, this.clazz, s);
        }
    }

    private static class ObjectBase<T>
    implements Base {
        OnBase<T> base;
        Class<T> clazz;

        public ObjectBase(OnBase<T> base, Class<T> clazz) {
            this.base = base;
            this.clazz = clazz;
        }

        public void onError(int l, String s) {
            CommonUtil.returnError(this.base, l, s);
        }

        public void onSuccess(String s) {
            CommonUtil.returnObject(this.base, this.clazz, s);
        }
    }
}

