/*
 * Decompiled with CFR 0.152.
 */
package io.openim.android.sdk.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JsonUtil {
    private static final Gson gson = new Gson();

    public static String toString(Object object) {
        String gsonString = "";
        try {
            if (null != object) {
                gsonString = gson.toJson(object);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return gsonString;
    }

    public static String toStringWithoutNull(Object object) {
        String gsonString = "";
        try {
            if (null != object) {
                gsonString = new GsonBuilder().create().toJson(object);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return gsonString;
    }

    public static <T> T toObj(String gsonString, Class<T> cls) {
        Object t = null;
        try {
            if (null != gsonString) {
                t = gson.fromJson(gsonString, cls);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)t;
    }

    public static <T> List<T> toArray(String json, Class<T> cls) {
        ArrayList<Object> list = null;
        try {
            if (null != json) {
                list = new ArrayList<Object>();
                JsonArray array = JsonParser.parseString((String)json).getAsJsonArray();
                for (JsonElement elem : array) {
                    list.add(gson.fromJson(elem, cls));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static <T> List<Map<String, T>> toListMaps(String gsonString) {
        List list = null;
        if (null != gsonString) {
            list = (List)gson.fromJson(gsonString, new TypeToken<List<Map<String, T>>>(){}.getType());
        }
        return list;
    }

    public static <T> Map<String, T> toMaps(String gsonString) {
        Map map = null;
        if (null != gsonString) {
            map = (Map)gson.fromJson(gsonString, new TypeToken<Map<String, T>>(){}.getType());
        }
        return map;
    }
}

