/*
 * Decompiled with CFR 0.152.
 */
package io.openim.android.sdk.manager;

import io.openim.android.sdk.listener.BaseImpl;
import io.openim.android.sdk.listener.OnBase;
import io.openim.android.sdk.listener.OnConversationListener;
import io.openim.android.sdk.listener._ConversationListener;
import io.openim.android.sdk.models.ConversationInfo;
import io.openim.android.sdk.models.ConversationReq;
import io.openim.android.sdk.utils.JsonUtil;
import io.openim.android.sdk.utils.ParamsUtil;
import java.util.Comparator;
import java.util.List;
import open_im_sdk.Open_im_sdk;
import open_im_sdk_callback.Base;

public class ConversationManager {
    public void setOnConversationListener(OnConversationListener listener) {
        Open_im_sdk.setConversationListener((open_im_sdk_callback.OnConversationListener)new _ConversationListener(listener));
    }

    public void getAllConversationList(OnBase<List<ConversationInfo>> base) {
        Open_im_sdk.getAllConversationList((Base)BaseImpl.arrayBase(base, ConversationInfo.class), (String)ParamsUtil.buildOperationID());
    }

    public void getConversationListSplit(OnBase<List<ConversationInfo>> base, long offset, long count) {
        Open_im_sdk.getConversationListSplit((Base)BaseImpl.arrayBase(base, ConversationInfo.class), (String)ParamsUtil.buildOperationID(), (long)offset, (long)count);
    }

    public void getOneConversation(OnBase<ConversationInfo> base, String sourceId, int sessionType) {
        Open_im_sdk.getOneConversation((Base)BaseImpl.objectBase(base, ConversationInfo.class), (String)ParamsUtil.buildOperationID(), (int)sessionType, (String)sourceId);
    }

    public void getMultipleConversation(OnBase<List<ConversationInfo>> base, List<String> conversationIDs) {
        Open_im_sdk.getMultipleConversation((Base)BaseImpl.arrayBase(base, ConversationInfo.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(conversationIDs));
    }

    public void setConversationDraft(OnBase<String> base, String conversationID, String draftText) {
        Open_im_sdk.setConversationDraft((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)conversationID, (String)draftText);
    }

    public void hideConversation(OnBase<String> base, String conversationID) {
        Open_im_sdk.hideConversation((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)conversationID);
    }

    public void markGroupMessageHasRead(OnBase<String> base, String groupID) {
        Open_im_sdk.markConversationMessageAsRead((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)groupID);
    }

    public void getTotalUnreadMsgCount(OnBase<String> base) {
        Open_im_sdk.getTotalUnreadMsgCount((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID());
    }

    public String getConversationIDBySessionType(String sourceId, int sessionType) {
        return Open_im_sdk.getConversationIDBySessionType((String)ParamsUtil.buildOperationID(), (String)sourceId, (long)sessionType);
    }

    public void changeInputStates(OnBase<String> base, String conversationId, boolean hasFocus) {
        Open_im_sdk.changeInputStates((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)conversationId, (boolean)hasFocus);
    }

    public void getInputStates(OnBase<String> base, String conversationID, String userId) {
        Open_im_sdk.getInputStates((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)conversationID, (String)userId);
    }

    public void setConversation(OnBase<String> base, String conversationID, ConversationReq conversationReq) {
        Open_im_sdk.setConversation((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)conversationID, (String)JsonUtil.toStringWithoutNull(conversationReq));
    }

    public void deleteConversationFromLocalAndSvr(OnBase<String> base, String conversionID) {
        Open_im_sdk.clearConversationAndDeleteAllMsg((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)conversionID);
    }

    public void deleteConversationAndDeleteAllMsg(OnBase<String> base, String conversionID) {
        Open_im_sdk.deleteConversationAndDeleteAllMsg((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)conversionID);
    }

    public String getAtAllTag() {
        return Open_im_sdk.getAtAllTag((String)ParamsUtil.buildOperationID());
    }

    public Comparator<ConversationInfo> simpleComparator() {
        return (a, b) -> {
            if (a.isPinned() && b.isPinned() || !a.isPinned() && !b.isPinned()) {
                long aCompare = Math.max(a.getDraftTextTime(), a.getLatestMsgSendTime());
                long bCompare = Math.max(b.getDraftTextTime(), b.getLatestMsgSendTime());
                return Long.compare(bCompare, aCompare);
            }
            if (a.isPinned() && !b.isPinned()) {
                return -1;
            }
            return 1;
        };
    }
}

