/*
 * Decompiled with CFR 0.152.
 */
package io.openim.android.sdk.manager;

import android.util.ArrayMap;
import io.openim.android.sdk.listener.BaseImpl;
import io.openim.android.sdk.listener.OnBase;
import io.openim.android.sdk.listener.OnGroupListener;
import io.openim.android.sdk.listener._GroupListener;
import io.openim.android.sdk.models.GroupApplicationInfo;
import io.openim.android.sdk.models.GroupInfo;
import io.openim.android.sdk.models.GroupMembersInfo;
import io.openim.android.sdk.models.SetGroupMemberInfo;
import io.openim.android.sdk.utils.JsonUtil;
import io.openim.android.sdk.utils.ParamsUtil;
import java.util.List;
import open_im_sdk.Open_im_sdk;
import open_im_sdk_callback.Base;

public class GroupManager {
    public void setOnGroupListener(OnGroupListener listener) {
        Open_im_sdk.setGroupListener((open_im_sdk_callback.OnGroupListener)new _GroupListener(listener));
    }

    public void inviteUserToGroup(OnBase<String> base, String groupId, List<String> uidList, String reason) {
        Open_im_sdk.inviteUserToGroup((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)groupId, (String)reason, (String)JsonUtil.toString(uidList));
    }

    public void kickGroupMember(OnBase<String> base, String groupId, List<String> uidList, String reason) {
        Open_im_sdk.kickGroupMember((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)groupId, (String)reason, (String)JsonUtil.toString(uidList));
    }

    public void getGroupMembersInfo(OnBase<List<GroupMembersInfo>> base, String groupId, List<String> uidList) {
        Open_im_sdk.getSpecifiedGroupMembersInfo((Base)BaseImpl.arrayBase(base, GroupMembersInfo.class), (String)ParamsUtil.buildOperationID(), (String)groupId, (String)JsonUtil.toString(uidList));
    }

    public void getGroupMemberList(OnBase<List<GroupMembersInfo>> base, String groupId, int filter, int offset, int count) {
        Open_im_sdk.getGroupMemberList((Base)BaseImpl.arrayBase(base, GroupMembersInfo.class), (String)ParamsUtil.buildOperationID(), (String)groupId, (int)filter, (int)offset, (int)count);
    }

    public void getUsersInGroup(OnBase<List<String>> base, String groupID, List<String> userIdList) {
        Open_im_sdk.getUsersInGroup((Base)BaseImpl.arrayBase(base, String.class), (String)ParamsUtil.buildOperationID(), (String)groupID, (String)JsonUtil.toString(userIdList));
    }

    public void getJoinedGroupList(OnBase<List<GroupInfo>> base) {
        Open_im_sdk.getJoinedGroupList((Base)BaseImpl.arrayBase(base, GroupInfo.class), (String)ParamsUtil.buildOperationID());
    }

    public void getJoinedGroupListPage(OnBase<List<GroupInfo>> base, int offset, int count) {
        Open_im_sdk.getJoinedGroupListPage((Base)BaseImpl.arrayBase(base, GroupInfo.class), (String)ParamsUtil.buildOperationID(), (int)offset, (int)count);
    }

    public void createGroup(List<String> memberUserIDs, List<String> adminUserIDs, GroupInfo groupInfo, String ownerUserID, OnBase<GroupInfo> callBack) {
        ArrayMap map = new ArrayMap();
        map.put("memberUserIDs", memberUserIDs);
        map.put("groupInfo", groupInfo);
        map.put("adminUserIDs", adminUserIDs);
        map.put("ownerUserID", ownerUserID);
        Open_im_sdk.createGroup((Base)BaseImpl.objectBase(callBack, GroupInfo.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(map));
    }

    public void setGroupInfo(GroupInfo groupInfo, OnBase<String> callBack) {
        Open_im_sdk.setGroupInfo((Base)BaseImpl.stringBase(callBack), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(groupInfo));
    }

    public void getGroupsInfo(OnBase<List<GroupInfo>> base, List<String> gidList) {
        Open_im_sdk.getSpecifiedGroupsInfo((Base)BaseImpl.arrayBase(base, GroupInfo.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(gidList));
    }

    public void joinGroup(OnBase<String> base, String gid, String reason, int joinSource) {
        this.joinGroup(base, gid, reason, joinSource, null);
    }

    public void joinGroup(OnBase<String> base, String gid, String reason, int joinSource, String ex) {
        Open_im_sdk.joinGroup((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)gid, (String)reason, (int)joinSource, (String)ex);
    }

    public void quitGroup(OnBase<String> base, String gid) {
        Open_im_sdk.quitGroup((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)gid);
    }

    public void transferGroupOwner(OnBase<String> base, String gid, String uid) {
        Open_im_sdk.transferGroupOwner((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)gid, (String)uid);
    }

    public void getRecvGroupApplicationList(OnBase<List<GroupApplicationInfo>> base) {
        Open_im_sdk.getGroupApplicationListAsRecipient((Base)BaseImpl.arrayBase(base, GroupApplicationInfo.class), (String)ParamsUtil.buildOperationID());
    }

    public void getSendGroupApplicationList(OnBase<List<GroupApplicationInfo>> base) {
        Open_im_sdk.getGroupApplicationListAsApplicant((Base)BaseImpl.arrayBase(base, GroupApplicationInfo.class), (String)ParamsUtil.buildOperationID());
    }

    public void acceptGroupApplication(OnBase<String> base, String gid, String uid, String handleMsg) {
        Open_im_sdk.acceptGroupApplication((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)gid, (String)uid, (String)handleMsg);
    }

    public void refuseGroupApplication(OnBase<String> base, String gid, String uid, String handleMsg) {
        Open_im_sdk.refuseGroupApplication((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)gid, (String)uid, (String)handleMsg);
    }

    public void dismissGroup(OnBase<String> base, String gid) {
        Open_im_sdk.dismissGroup((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)gid);
    }

    public void changeGroupMute(OnBase<String> base, String gid, boolean mute) {
        Open_im_sdk.changeGroupMute((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)gid, (boolean)mute);
    }

    public void changeGroupMemberMute(OnBase<String> base, String gid, String uid, long seconds) {
        Open_im_sdk.changeGroupMemberMute((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)gid, (String)uid, (long)seconds);
    }

    public void searchGroups(OnBase<List<GroupInfo>> base, List<String> keywordList, boolean isSearchGroupID, boolean isSearchGroupName) {
        ArrayMap map = new ArrayMap();
        map.put("keywordList", keywordList);
        map.put("isSearchGroupID", isSearchGroupID);
        map.put("isSearchGroupName", isSearchGroupName);
        Open_im_sdk.searchGroups((Base)BaseImpl.arrayBase(base, GroupInfo.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(map));
    }

    public void setGroupMemberInfo(SetGroupMemberInfo setGroupMemberInfo, OnBase<String> base) {
        Open_im_sdk.setGroupMemberInfo((Base)BaseImpl.stringBase(base), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toStringWithoutNull(setGroupMemberInfo));
    }

    public void getGroupMemberListByJoinTime(OnBase<List<GroupMembersInfo>> base, String groupID, int offset, int count, long joinTimeBegin, long joinTimeEnd, List<String> excludeUserIDList) {
        Open_im_sdk.getGroupMemberListByJoinTimeFilter((Base)BaseImpl.arrayBase(base, GroupMembersInfo.class), (String)ParamsUtil.buildOperationID(), (String)groupID, (int)offset, (int)count, (long)joinTimeBegin, (long)joinTimeEnd, (String)JsonUtil.toString(excludeUserIDList));
    }

    public void getGroupMemberOwnerAndAdmin(OnBase<List<GroupMembersInfo>> base, String groupID) {
        Open_im_sdk.getGroupMemberOwnerAndAdmin((Base)BaseImpl.arrayBase(base, GroupMembersInfo.class), (String)ParamsUtil.buildOperationID(), (String)groupID);
    }

    public void searchGroupMembers(OnBase<List<GroupMembersInfo>> base, String groupID, List<String> keywordList, boolean isSearchUserID, boolean isSearchMemberNickname, int offset, int count) {
        ArrayMap map = new ArrayMap();
        map.put("groupID", groupID);
        map.put("keywordList", keywordList);
        map.put("isSearchUserID", isSearchUserID);
        map.put("isSearchMemberNickname", isSearchMemberNickname);
        map.put("offset", offset);
        map.put("count", count);
        Open_im_sdk.searchGroupMembers((Base)BaseImpl.arrayBase(base, GroupMembersInfo.class), (String)ParamsUtil.buildOperationID(), (String)JsonUtil.toString(map));
    }

    public void isJoinGroup(String gid, OnBase<Boolean> callBack) {
        Open_im_sdk.isJoinGroup((Base)BaseImpl.objectBase(callBack, Boolean.class), (String)ParamsUtil.buildOperationID(), (String)gid);
    }
}

