/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.arquillian.managed;

import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import io.openliberty.arquillian.managed.AppStateChecker;
import io.openliberty.arquillian.managed.ByteClassLoader;
import io.openliberty.arquillian.managed.Interruptor;
import io.openliberty.arquillian.managed.WLPManagedContainerConfiguration;
import io.openliberty.arquillian.managed.exceptions.CDILogExceptionLocator;
import io.openliberty.arquillian.managed.exceptions.DeploymentExceptionLocator;
import io.openliberty.arquillian.managed.exceptions.FFDCExceptionLocator;
import io.openliberty.arquillian.managed.exceptions.SupportFeatureSerializedExceptionLocator;
import io.openliberty.arquillian.managed.exceptions.SupportFeatureTextExceptionLocator;
import jakarta.servlet.annotation.WebServlet;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.container.test.api.Testable;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.ArchiveAsset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.asset.ClassAsset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WLPManagedContainer
implements DeployableContainer<WLPManagedContainerConfiguration> {
    private static final String DEFAULT_MESSAGES_LOG_NAME = "messages.log";
    private static final String MESSAGE_FILE_NAME = "messageFileName";
    private static final String MESSAGE_FILE_PROPERTY = "com.ibm.ws.logging.message.file.name";
    private static final String LOG_DIRECTORY = "logDirectory";
    private static final String LOG_DIRECTORY_PROPERTY = "com.ibm.ws.logging.log.directory";
    private static final String LOG_DIR = "LOG_DIR";
    private static final String WLP_OUTPUT_DIR = "WLP_OUTPUT_DIR";
    private static final String WLP_USER_DIR = "WLP_USER_DIR";
    private static final String JAVA_TOOL_OPTIONS = "JAVA_TOOL_OPTIONS";
    private static final String ARQUILLIAN_SERVLET_NAME = "ArquillianServletRunnerEE9";
    private static final String className = WLPManagedContainer.class.getName();
    private static Logger log = Logger.getLogger(className);
    private static final String javaVmArgumentsDelimiter = " ";
    private static final String javaVmArgumentsIndicator = "-";
    private WLPManagedContainerConfiguration containerConfiguration;
    private JMXConnector jmxConnector;
    private MBeanServerConnection mbsc;
    private Process wlpProcess;
    private Thread shutdownThread;
    private Map<String, Long> archiveDeployTimes = new HashMap<String, Long>();
    private List<DeploymentExceptionLocator> exceptionLocators;

    public void setup(WLPManagedContainerConfiguration configuration) {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "setup");
        }
        this.containerConfiguration = configuration;
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "setup");
        }
    }

    public void start() throws LifecycleException {
        String serviceURL;
        block20: {
            if (log.isLoggable(Level.FINER)) {
                log.entering(className, "start");
            }
            VirtualMachine wlpvm = null;
            serviceURL = null;
            try {
                String vmid = this.findVirtualMachineIdByName(this.containerConfiguration.getServerName());
                if (vmid != null) {
                    if (!this.containerConfiguration.isAllowConnectingToRunningServer()) {
                        throw new LifecycleException("Connecting to an already running server is not allowed");
                    }
                    wlpvm = VirtualMachine.attach(vmid);
                    serviceURL = this.getVMLocalConnectorAddress(wlpvm);
                    if (serviceURL == null) {
                        throw new LifecycleException("Unable to retrieve connector address for localConnector.Ensure the `localConnector-1.0` feature is included in the server.xml and installed correctly");
                    }
                    break block20;
                }
                if (this.containerConfiguration.isAddLocalConnector()) {
                    String serverXML = this.getServerXML();
                    if ("defaultServer".equals(this.containerConfiguration.getServerName()) && !new File(serverXML).exists()) {
                        serverXML = this.getDefaultServerXML();
                    }
                    Document document = this.readServerXML(serverXML);
                    this.addFeatures(document, "localConnector-1.0");
                    this.writeServerXML(document, serverXML);
                }
                List<String> cmd = this.getServerCommand(CommandType.RUN);
                ProcessBuilder pb = new ProcessBuilder(cmd);
                pb.redirectErrorStream(true);
                pb.directory(new File(this.containerConfiguration.getWlpHome()));
                List<String> javaVmArguments = this.parseJvmArgs(this.containerConfiguration.getJavaVmArguments());
                StringBuilder vmArgs = new StringBuilder("-Dcom.ibm.ws.logging.console.log.level=INFO");
                for (String javaVmArgument : javaVmArguments) {
                    vmArgs.append(javaVmArgumentsDelimiter).append(javaVmArgument);
                }
                log.finer("Setting JVM arguments: " + vmArgs.toString());
                pb.environment().put(JAVA_TOOL_OPTIONS, vmArgs.toString());
                if (this.containerConfiguration.getUsrDir() != null) {
                    pb.environment().put(WLP_USER_DIR, new File(this.containerConfiguration.getUsrDir()).getCanonicalPath());
                }
                log.finer("Starting server with command: " + cmd.toString());
                this.wlpProcess = pb.start();
                new Thread(new ConsoleConsumer(this.wlpProcess)).start();
                cmd = this.getServerCommand(CommandType.STOP);
                this.shutdownThread = this.getShutDownThread(cmd);
                Runtime.getRuntime().addShutdownHook(this.shutdownThread);
                int startupTimeout = this.containerConfiguration.getServerStartTimeout() * 1000;
                while (startupTimeout > 0 && serviceURL == null) {
                    startupTimeout -= 500;
                    Thread.sleep(500L);
                    int ev = Integer.MIN_VALUE;
                    IllegalThreadStateException itse = null;
                    try {
                        ev = this.wlpProcess.exitValue();
                    }
                    catch (IllegalThreadStateException e) {
                        itse = e;
                    }
                    if (itse == null) {
                        throw new LifecycleException("Process terminated prematurely; ev = " + ev);
                    }
                    if (vmid == null) {
                        vmid = this.findVirtualMachineIdByName(this.containerConfiguration.getServerName());
                    }
                    if (wlpvm == null && vmid != null) {
                        wlpvm = VirtualMachine.attach(vmid);
                    }
                    if (serviceURL != null || wlpvm == null) continue;
                    serviceURL = this.getVMLocalConnectorAddress(wlpvm);
                }
                if (serviceURL == null) {
                    throw new LifecycleException("Unable to retrieve connector address for localConnector of started VM. vmid: " + vmid + " connectedVM: " + wlpvm + ". Ensure the `localConnector-1.0` feature is included in the server.xml and installed correctly");
                }
                log.finer("vmid: " + vmid);
            }
            catch (Exception e) {
                throw new LifecycleException("Could not start container", (Throwable)e);
            }
        }
        try {
            JMXServiceURL url = new JMXServiceURL(serviceURL);
            this.jmxConnector = JMXConnectorFactory.connect(url);
            this.mbsc = this.jmxConnector.getMBeanServerConnection();
        }
        catch (IOException e) {
            throw new LifecycleException("Connecting to the JMX MBean Server failed", (Throwable)e);
        }
        this.initExceptionLocators();
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "start");
        }
    }

    private List<String> getServerCommand(CommandType type) {
        ArrayList<String> cmd = new ArrayList<String>();
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            cmd.add(this.containerConfiguration.getWlpHome() + "/bin/server.bat");
        } else {
            String serverCommand = this.containerConfiguration.getWlpHome() + "/bin/server";
            cmd.add(serverCommand);
            File f = new File(serverCommand);
            if (!f.canExecute()) {
                f.setExecutable(true, true);
            }
        }
        switch (type) {
            case RUN: {
                cmd.add("run");
                break;
            }
            case STOP: {
                cmd.add("stop");
            }
        }
        cmd.add(this.containerConfiguration.getServerName());
        return cmd;
    }

    private Thread getShutDownThread(List<String> cmd) {
        final ProcessBuilder shutDownProcessBuilder = new ProcessBuilder(cmd);
        try {
            if (this.containerConfiguration.getUsrDir() != null) {
                shutDownProcessBuilder.environment().put(WLP_USER_DIR, new File(this.containerConfiguration.getUsrDir()).getCanonicalPath());
            }
        }
        catch (IOException e) {
            log.finer("Failed to set WLP_USER_DIR for shut-down shell command.");
        }
        return new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Process proc = shutDownProcessBuilder.start();
                    proc.waitFor();
                }
                catch (IOException | InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private List<String> parseJvmArgs(String javaVmArguments) {
        ArrayList<String> parsedJavaVmArguments = new ArrayList<String>();
        String[] splitJavaVmArguments = javaVmArguments.split(javaVmArgumentsDelimiter);
        if (splitJavaVmArguments.length > 1) {
            for (String javaVmArgument : splitJavaVmArguments) {
                if (javaVmArgument.trim().length() <= 0) continue;
                if (javaVmArgument.startsWith(javaVmArgumentsIndicator)) {
                    parsedJavaVmArguments.add(javaVmArgument);
                    continue;
                }
                String javaVmArgumentExtension = javaVmArgument;
                javaVmArgument = (String)parsedJavaVmArguments.remove(parsedJavaVmArguments.size() - 1) + javaVmArgumentsDelimiter + javaVmArgumentExtension;
                parsedJavaVmArguments.add(javaVmArgument);
            }
        } else {
            parsedJavaVmArguments.add(javaVmArguments);
        }
        return parsedJavaVmArguments;
    }

    private String getVMLocalConnectorAddress(VirtualMachine wlpvm) throws IOException {
        String PROPERTY_NAME = "com.sun.management.jmxremote.localConnectorAddress";
        String serviceURL = wlpvm.getAgentProperties().getProperty(PROPERTY_NAME);
        if (serviceURL == null) {
            serviceURL = wlpvm.getSystemProperties().getProperty(PROPERTY_NAME);
        }
        if (serviceURL == null) {
            List<String> lines;
            File jmxAddr = new File(this.getServerOutputDir() + "/logs/state/com.ibm.ws.jmx.local.address");
            if (log.isLoggable(Level.FINER)) {
                log.info("Checking local connector address file for JMX address at " + jmxAddr.getAbsolutePath());
            }
            if (jmxAddr.exists() && jmxAddr.isFile() && jmxAddr.canRead() && (lines = Files.readAllLines(jmxAddr.toPath(), StandardCharsets.UTF_8)) != null && lines.size() > 0) {
                if (log.isLoggable(Level.FINER)) {
                    log.info("Checking local connector address file for JMX address at " + lines.get(0));
                }
                return lines.get(0);
            }
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("service url: " + serviceURL);
        }
        return serviceURL;
    }

    private String findVirtualMachineIdByName(String serverName) {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "findVirtualMachineIdByName");
        }
        List<VirtualMachineDescriptor> vmds = VirtualMachine.list();
        for (VirtualMachineDescriptor vmd : vmds) {
            String displayName = vmd.displayName();
            if (log.isLoggable(Level.FINER)) {
                log.finer("VMD displayName: " + displayName);
                log.finer("VMD id: " + vmd.id());
            }
            if (!displayName.contains(serverName) || !displayName.contains("ws-server.jar") && !displayName.contains("ws-launch.jar")) continue;
            if (log.isLoggable(Level.FINER)) {
                log.exiting(className, "findVirtualMachineIdByName", vmd.id());
            }
            return vmd.id();
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "findVirtualMachineIdByName");
        }
        return null;
    }

    private void initExceptionLocators() throws LifecycleException {
        try {
            this.exceptionLocators = new ArrayList<DeploymentExceptionLocator>();
            this.exceptionLocators.add(new SupportFeatureSerializedExceptionLocator("localhost", this.getHttpPort()));
            this.exceptionLocators.add(new SupportFeatureTextExceptionLocator("localhost", this.getHttpPort()));
            this.exceptionLocators.add(new FFDCExceptionLocator(this.getLogsDirectory()));
            this.exceptionLocators.add(new CDILogExceptionLocator());
        }
        catch (Exception e) {
            throw new LifecycleException("Failed to initialize exception locators", (Throwable)e);
        }
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "deploy");
            log.finer("Archive provided to deploy method: " + archive.toString(true));
        }
        this.waitForVerifyApps();
        String archiveName = archive.getName();
        String archiveType = this.createDeploymentType(archiveName);
        String deployName = this.createDeploymentName(archiveName);
        this.archiveDeployTimes.put(deployName, System.currentTimeMillis());
        try {
            List<WebModule> modules;
            File exportedArchiveLocation;
            if (this.containerConfiguration.isDeployTypeXML()) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Deploying using server.xml");
                }
                if (!(archiveType.equalsIgnoreCase("ear") || archiveType.equalsIgnoreCase("war") || archiveType.equalsIgnoreCase("eba"))) {
                    throw new DeploymentException("Invalid archive type: " + archiveType + ".  Valid archive types are ear, war, and eba.");
                }
                String appDir = this.getAppDirectory();
                exportedArchiveLocation = new File(appDir, archiveName);
                ((ZipExporter)archive.as(ZipExporter.class)).exportTo(exportedArchiveLocation, true);
                Document document = this.readServerXML();
                this.addApplication(document, deployName, archiveName, archiveType);
                this.writeServerXML(document);
            } else {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Deploying using dropins");
                }
                String dropInDir = this.getDropInDirectory();
                exportedArchiveLocation = new File(dropInDir, archiveName);
                String tempDir = this.getDropInTempDirectory();
                File tempArchiveLocation = new File(tempDir, archiveName);
                ((ZipExporter)archive.as(ZipExporter.class)).exportTo(tempArchiveLocation, true);
                Files.move(tempArchiveLocation.toPath(), exportedArchiveLocation.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer("Deployment done");
            }
            this.waitForApplicationTargetState(new String[]{deployName}, true, this.containerConfiguration.getAppDeployTimeout());
            ProtocolMetaData metaData = new ProtocolMetaData();
            HTTPContext httpContext = new HTTPContext("localhost", this.getHttpPort());
            if (archive instanceof EnterpriseArchive) {
                modules = this.getWebModules((EnterpriseArchive)archive);
            } else if (archive instanceof WebArchive) {
                WebModule m = new WebModule();
                m.name = deployName;
                m.archive = (WebArchive)archive;
                m.contextRoot = this.getContextRoot(m.archive);
                modules = Collections.singletonList(m);
            } else {
                modules = Collections.emptyList();
            }
            boolean addedSomeServlets = false;
            for (WebModule module : modules) {
                List<String> servlets = this.getServletNames(module);
                for (String servlet : servlets) {
                    httpContext.add(new Servlet(servlet, module.contextRoot));
                    addedSomeServlets = true;
                }
            }
            if (!addedSomeServlets) {
                if (modules.size() == 1) {
                    WebModule m = modules.get(0);
                    httpContext.add(new Servlet(ARQUILLIAN_SERVLET_NAME, m.contextRoot));
                } else {
                    httpContext.add(new Servlet(ARQUILLIAN_SERVLET_NAME, deployName));
                }
            }
            metaData.addContext((Object)httpContext);
            if (log.isLoggable(Level.FINER)) {
                log.exiting(className, "deploy");
            }
            return metaData;
        }
        catch (DeploymentException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DeploymentException("Exception while deploying application.", (Throwable)e);
        }
    }

    private void waitForVerifyApps() throws DeploymentException {
        String verifyApps = this.containerConfiguration.getVerifyApps();
        if (verifyApps != null && verifyApps.length() > 0) {
            String[] verifyAppArray = verifyApps.split(",");
            HashSet<String> verifyAppSet = new HashSet<String>();
            for (int i = 0; i < verifyAppArray.length; ++i) {
                String appToVerify = verifyAppArray[i];
                if ((appToVerify = appToVerify.trim()).length() <= 0) continue;
                verifyAppSet.add(appToVerify);
            }
            int totalTimeout = this.containerConfiguration.getVerifyAppDeployTimeout() * verifyAppSet.size();
            this.waitForApplicationTargetState(verifyAppSet.toArray(new String[verifyAppSet.size()]), true, totalTimeout);
        }
    }

    private List<WebModule> getWebModules(EnterpriseArchive ear) throws DeploymentException {
        ArrayList<WebModule> modules = new ArrayList<WebModule>();
        for (ArchivePath path : ear.getContent().keySet()) {
            if (!path.get().endsWith("war")) continue;
            WebModule module = new WebModule();
            module.archive = (WebArchive)ear.getAsType(WebArchive.class, path);
            module.name = module.archive.getName().replaceFirst("^\\/", "").replaceFirst("\\.war$", "");
            module.contextRoot = this.getContextRoot(ear, module.archive);
            modules.add(module);
        }
        return modules;
    }

    private List<String> getServletNames(WebModule webModule) throws DeploymentException {
        try {
            ArrayList<String> servletNames = new ArrayList<String>();
            this.getServletNames((Archive)webModule.archive, servletNames);
            if (servletNames.isEmpty() && Testable.isArchiveToTest((Archive)webModule.archive)) {
                servletNames.add(ARQUILLIAN_SERVLET_NAME);
            }
            return servletNames;
        }
        catch (Exception e) {
            throw new DeploymentException("Error trying to retrieve servlet names", (Throwable)e);
        }
    }

    private void getServletNames(Archive archive, List<String> servletNames) throws DeploymentException {
        try {
            Map content = archive.getContent();
            for (ArchivePath key : content.keySet()) {
                ClassAsset classAsset;
                Class c;
                String name;
                Node node = (Node)content.get(key);
                boolean isWebINF = node.getPath().get().startsWith("/WEB-INF/lib");
                if (node.getAsset() != null && node.getAsset() instanceof ArchiveAsset && isWebINF) {
                    ArchiveAsset archiveAsset = (ArchiveAsset)node.getAsset();
                    this.getServletNames(archiveAsset.getArchive(), servletNames);
                }
                if (node.getAsset() != null && (node.getAsset() instanceof ClassLoaderAsset || node.getAsset() instanceof ByteArrayAsset) && key.get().endsWith(".class")) {
                    byte[] ba = null;
                    try {
                        if (node.getAsset() instanceof ClassLoaderAsset && key.get().contains("WEB-INF")) {
                            ClassLoaderAsset classLoaderAsset = (ClassLoaderAsset)node.getAsset();
                            InputStream inputStream = classLoaderAsset.openStream();
                            ba = IOUtils.toByteArray((InputStream)inputStream);
                            inputStream.close();
                        } else if (node.getAsset() instanceof ByteArrayAsset) {
                            ByteArrayAsset byteArrayAsset = (ByteArrayAsset)node.getAsset();
                            ba = byteArrayAsset.getSource();
                        }
                        if (ba != null) {
                            ByteClassLoader loader = new ByteClassLoader(ClassLoader.getSystemClassLoader(), ba);
                            Class<?> c2 = loader.findClass(null);
                            String name2 = this.getServletNameFromAnnotation(c2);
                            if (name2 != null) {
                                servletNames.add(name2);
                            }
                            loader = null;
                            ba = null;
                            c2 = null;
                        }
                    }
                    catch (IOException | IndexOutOfBoundsException | LinkageError e) {
                        log.warning("Failed to resolve servlet names for:" + key.get() + ". " + e.toString());
                    }
                }
                if (node.getAsset() != null && node.getAsset() instanceof ClassAsset && (name = this.getServletNameFromAnnotation(c = (classAsset = (ClassAsset)node.getAsset()).getSource())) != null) {
                    servletNames.add(name);
                }
                if (!key.get().endsWith("web.xml") && !key.get().endsWith("web-fragment.xml")) continue;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(node.getAsset().openStream());
                servletNames.addAll(this.getServletNamesFromWebXML(doc));
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Error trying to retrieve servlet names", (Throwable)e);
        }
    }

    private String getServletNameFromAnnotation(Class<?> c) throws DeploymentException {
        try {
            WebServlet webServlet = c.getAnnotation(WebServlet.class);
            if (webServlet != null) {
                if (webServlet.name() != null && !webServlet.name().isEmpty()) {
                    return webServlet.name();
                }
                return c.getSimpleName();
            }
            return null;
        }
        catch (Exception e) {
            throw new DeploymentException("Error trying to resolve servlet name from jakarta.servlet.annotation.WebServlet annotation", (Throwable)e);
        }
    }

    private List<String> getServletNamesFromWebXML(Document webXML) {
        ArrayList<String> servletNames = new ArrayList<String>();
        NodeList servlets = webXML.getElementsByTagName("servlet");
        for (int i = 0; i < servlets.getLength(); ++i) {
            Element servletElement;
            NodeList nameElements;
            org.w3c.dom.Node currElement = servlets.item(i);
            if (currElement.getNodeType() != 1 || (nameElements = (servletElement = (Element)currElement).getElementsByTagName("servlet-name")).getLength() < 1) continue;
            String servletName = nameElements.item(0).getTextContent();
            servletNames.add(servletName);
        }
        return servletNames;
    }

    private String getContextRoot(EnterpriseArchive ear, WebArchive war) throws DeploymentException {
        Node applicationXmlNode = ear.get("META-INF/application.xml");
        if (applicationXmlNode != null && applicationXmlNode.getAsset() != null) {
            InputStream input;
            block5: {
                String string;
                input = null;
                try {
                    input = ear.get("META-INF/application.xml").getAsset().openStream();
                    Document applicationXml = this.readXML(input);
                    XPath xPath = XPathFactory.newInstance().newXPath();
                    XPathExpression ctxRootSelector = xPath.compile("//module/web[web-uri/text()='" + war.getName() + "']/context-root");
                    String ctxRoot = ctxRootSelector.evaluate(applicationXml);
                    if (ctxRoot == null || ctxRoot.trim().length() <= 0) break block5;
                    string = ctxRoot;
                }
                catch (Exception e) {
                    try {
                        throw new DeploymentException("Unable to retrieve context-root from application.xml");
                    }
                    catch (Throwable throwable) {
                        WLPManagedContainer.closeQuietly(input);
                        throw throwable;
                    }
                }
                WLPManagedContainer.closeQuietly(input);
                return string;
            }
            WLPManagedContainer.closeQuietly(input);
        }
        return this.getContextRoot(war);
    }

    private String getContextRoot(WebArchive war) throws DeploymentException {
        Node webExtXmlNode = war.get("WEB-INF/ibm-web-ext.xml");
        if (webExtXmlNode != null && webExtXmlNode.getAsset() != null) {
            InputStream input;
            block5: {
                String string;
                input = null;
                try {
                    input = war.get("WEB-INF/ibm-web-ext.xml").getAsset().openStream();
                    Document webExtXml = this.readXML(input);
                    XPath xPath = XPathFactory.newInstance().newXPath();
                    XPathExpression ctxRootSelector = xPath.compile("//context-root/@uri");
                    String ctxRoot = ctxRootSelector.evaluate(webExtXml);
                    if (ctxRoot == null || ctxRoot.trim().length() <= 0) break block5;
                    string = ctxRoot;
                }
                catch (Exception e) {
                    try {
                        throw new DeploymentException("Unable to retrieve context-root from ibm-web-ext.xml");
                    }
                    catch (Throwable throwable) {
                        WLPManagedContainer.closeQuietly(input);
                        throw throwable;
                    }
                }
                WLPManagedContainer.closeQuietly(input);
                return string;
            }
            WLPManagedContainer.closeQuietly(input);
        }
        return this.createDeploymentName(war.getName());
    }

    private static void closeQuietly(Closeable closable) {
        try {
            if (closable != null) {
                closable.close();
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Exception while closing Closeable", e);
        }
    }

    private int getHttpPort() throws DeploymentException {
        int httpPort;
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "getHttpPort");
        }
        if ((httpPort = this.containerConfiguration.getHttpPort()) == 0) {
            httpPort = this.getHttpPortFromChannelFWMBean("defaultHttpEndpoint");
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "getHttpPort", httpPort);
        }
        return httpPort;
    }

    private int getHttpPortFromChannelFWMBean(String endpointName) throws DeploymentException {
        int httpPort;
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "getHttpPortFromChannelFWMBean", endpointName);
        }
        ObjectName endpointMBean = null;
        try {
            endpointMBean = new ObjectName("WebSphere:feature=channelfw,type=endpoint,name=" + endpointName);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("The generated object name is wrong. The endpointName used was '" + endpointName + "'", (Throwable)e);
        }
        catch (NullPointerException e) {
            throw new DeploymentException("This should never happen", (Throwable)e);
        }
        try {
            if (!this.mbsc.isRegistered(endpointMBean)) {
                throw new DeploymentException("The Channel Framework MBean with endpointName '" + endpointName + "' does not exist.");
            }
            httpPort = (Integer)this.mbsc.getAttribute(endpointMBean, "Port");
            log.finer("httpPort: " + httpPort);
        }
        catch (Exception e) {
            throw new DeploymentException("Exception while retrieving httpPort information from Channel Framework MBean. The httpPort can also be manually configured in the arquillian container configuration.", (Throwable)e);
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "getHttpPortFromChannelFWMBean", httpPort);
        }
        return httpPort;
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "undeploy");
        }
        String archiveName = archive.getName();
        String deployName = this.createDeploymentName(archiveName);
        String deployDir = null;
        this.archiveDeployTimes.remove(deployName);
        try {
            if (this.containerConfiguration.isDeployTypeXML()) {
                Document document = this.readServerXML();
                this.removeApplication(document, deployName);
                this.writeServerXML(document);
                this.waitForApplicationTargetState(new String[]{deployName}, false, this.containerConfiguration.getAppUndeployTimeout());
            }
            deployDir = this.containerConfiguration.isDeployTypeXML() ? this.getAppDirectory() : this.getDropInDirectory();
            File exportedArchiveLocation = new File(deployDir, archiveName);
            this.deleteWithRetries(exportedArchiveLocation, this.containerConfiguration.isFailSafeUndeployment(), this.containerConfiguration.getFileDeleteRetries(), this.containerConfiguration.getStandardFileDeleteRetryInterval());
            if (!this.containerConfiguration.isDeployTypeXML()) {
                this.waitForApplicationTargetState(new String[]{deployName}, false, this.containerConfiguration.getAppUndeployTimeout());
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Exception while undeploying application.", (Throwable)e);
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "undeploy");
        }
    }

    private void deleteWithRetries(File archveToDelete, boolean isFailSafeUndeployment, int retries, int retryInterval) throws DeploymentException {
        boolean complete = false;
        boolean failSafeUndeployment = this.containerConfiguration.isFailSafeUndeployment();
        IOException lastException = null;
        for (int attempt = 0; !complete && attempt <= retries; ++attempt) {
            if (attempt > 0) {
                try {
                    Thread.sleep(retryInterval);
                }
                catch (InterruptedException e) {
                    throw new DeploymentException("Interrupted while trying to delete " + archveToDelete, (Throwable)e);
                }
            }
            try {
                if (Files.deleteIfExists(archveToDelete.toPath())) {
                    complete = true;
                    continue;
                }
                if (failSafeUndeployment) continue;
                throw new DeploymentException("Archive " + archveToDelete + " already deleted from deployment directory");
            }
            catch (IOException e) {
                lastException = e;
            }
        }
        if (!complete) {
            if (failSafeUndeployment) {
                log.log(Level.WARNING, "Unable to delete archive from deployment directory -> failsafe -> archive " + archveToDelete + " marked for delete on exit", lastException);
                archveToDelete.deleteOnExit();
            } else {
                throw new DeploymentException("Could not delete " + archveToDelete, (Throwable)lastException);
            }
        }
    }

    private String getDropInDirectory() throws IOException {
        String dropInDir = this.getServerConfigDir() + "/dropins";
        if (log.isLoggable(Level.FINER)) {
            log.finer("dropInDir: " + dropInDir);
        }
        new File(dropInDir).mkdirs();
        return dropInDir;
    }

    private String getAppDirectory() throws IOException {
        String appDir = this.getServerConfigDir() + "/apps";
        if (log.isLoggable(Level.FINER)) {
            log.finer("appDir: " + appDir);
        }
        new File(appDir).mkdirs();
        return appDir;
    }

    private String getDropInTempDirectory() throws IOException {
        String dropInTempDir = this.getServerConfigDir() + "/temp";
        if (log.isLoggable(Level.FINER)) {
            log.finer("dropInDir: " + dropInTempDir);
        }
        new File(dropInTempDir).mkdirs();
        return dropInTempDir;
    }

    private String getServerXML() throws IOException {
        String serverXML = this.getServerConfigDir() + "/server.xml";
        if (log.isLoggable(Level.FINER)) {
            log.finer("server.xml: " + serverXML);
        }
        return serverXML;
    }

    private String getDefaultServerXML() {
        String serverXML = this.containerConfiguration.getWlpHome() + "/templates/servers/defaultServer/server.xml";
        if (log.isLoggable(Level.FINER)) {
            log.finer("default server.xml: " + serverXML);
        }
        return serverXML;
    }

    private String createDeploymentName(String archiveName) {
        return archiveName.substring(0, archiveName.lastIndexOf("."));
    }

    private String createDeploymentType(String archiveName) {
        return archiveName.substring(archiveName.lastIndexOf(".") + 1);
    }

    private Document readServerXML() throws DeploymentException {
        try {
            return this.readServerXML(this.getServerXML());
        }
        catch (IOException e) {
            throw new DeploymentException("Can't read server.xml", (Throwable)e);
        }
    }

    private Document readServerXML(String serverXML) throws DeploymentException {
        Document document;
        FileInputStream input = null;
        try {
            input = new FileInputStream(new File(serverXML));
            document = this.readXML(input);
        }
        catch (Exception e) {
            try {
                throw new DeploymentException("Exception while reading server.xml file.", (Throwable)e);
            }
            catch (Throwable throwable) {
                WLPManagedContainer.closeQuietly(input);
                throw throwable;
            }
        }
        WLPManagedContainer.closeQuietly(input);
        return document;
    }

    private Document readXML(InputStream input) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(input);
    }

    private void writeServerXML(Document doc) throws DeploymentException, IOException {
        this.writeServerXML(doc, this.getServerXML());
    }

    private void writeServerXML(Document doc, String serverXML) throws DeploymentException {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer tr = tf.newTransformer();
            tr.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult res = new StreamResult(new File(serverXML));
            tr.transform(source, res);
        }
        catch (Exception e) {
            throw new DeploymentException("Exception wile writing server.xml file.", (Throwable)e);
        }
    }

    private Element createFeature(Document doc, String featureName) {
        Element feature = doc.createElement("feature");
        feature.appendChild(doc.createTextNode(featureName));
        return feature;
    }

    private void addFeatures(Document doc, String featureNames) {
        NodeList rootList = doc.getElementsByTagName("featureManager");
        org.w3c.dom.Node featureManager = rootList.item(0);
        for (String featureName : featureNames.split(",")) {
            if (this.checkFeatureAlreadyThere(featureName, featureManager.getChildNodes())) continue;
            featureManager.appendChild(this.createFeature(doc, featureName));
        }
    }

    private boolean checkFeatureAlreadyThere(String featureName, NodeList featureManagerList) {
        for (int i = 0; i < featureManagerList.getLength(); ++i) {
            org.w3c.dom.Node featureText;
            org.w3c.dom.Node feature = featureManagerList.item(i);
            if (!"feature".equals(feature.getNodeName()) || (featureText = feature.getFirstChild()) == null || !featureText.getTextContent().trim().equals(featureName)) continue;
            return true;
        }
        return false;
    }

    private Element createApplication(Document doc, String deploymentName, String archiveName, String type) throws DeploymentException {
        Element application = doc.createElement("application");
        application.setAttribute("id", deploymentName);
        application.setAttribute("location", archiveName);
        application.setAttribute("name", deploymentName);
        application.setAttribute("type", type);
        if (this.containerConfiguration.getSharedLib() != null || this.containerConfiguration.getApiTypeVisibility() != null) {
            Element classloader = doc.createElement("classloader");
            if (this.containerConfiguration.getSharedLib() != null) {
                classloader.setAttribute("commonLibraryRef", this.containerConfiguration.getSharedLib());
            }
            if (this.containerConfiguration.getApiTypeVisibility() != null) {
                classloader.setAttribute("apiTypeVisibility", this.containerConfiguration.getApiTypeVisibility());
            }
            application.appendChild(classloader);
        }
        if (this.containerConfiguration.getSecurityConfiguration() != null) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(new File(this.containerConfiguration.getSecurityConfiguration()));
                Document securityConfiguration = this.readXML(input);
                application.appendChild(doc.adoptNode(securityConfiguration.getDocumentElement().cloneNode(true)));
            }
            catch (Exception e) {
                try {
                    throw new DeploymentException("Exception while reading " + this.containerConfiguration.getSecurityConfiguration() + " file.", (Throwable)e);
                }
                catch (Throwable throwable) {
                    WLPManagedContainer.closeQuietly(input);
                    throw throwable;
                }
            }
            WLPManagedContainer.closeQuietly(input);
        }
        return application;
    }

    private void addApplication(Document doc, String deployName, String archiveName, String type) throws DOMException, DeploymentException {
        NodeList rootList = doc.getElementsByTagName("server");
        org.w3c.dom.Node root = rootList.item(0);
        root.appendChild(this.createApplication(doc, deployName, archiveName, type));
    }

    private void removeApplication(Document doc, String deployName) {
        org.w3c.dom.Node server = doc.getElementsByTagName("server").item(0);
        NodeList serverlist = server.getChildNodes();
        for (int i = 0; serverlist.getLength() > i; ++i) {
            org.w3c.dom.Node node = serverlist.item(i);
            if (!node.getNodeName().equals("application") || !node.getAttributes().getNamedItem("id").getNodeValue().equals(deployName)) continue;
            node.getParentNode().removeChild(node);
        }
    }

    private void logAllApps() {
        try {
            log.info("Listing all apps...");
            Set<ObjectInstance> allApps = this.mbsc.queryMBeans(null, null);
            log.info("Size of results: " + allApps.size());
            for (ObjectInstance app : allApps) {
                log.info(app.getObjectName().toString());
            }
        }
        catch (IOException e) {
            log.warning("Could not print list of all apps. Exception thrown is: " + e.getMessage());
        }
    }

    private void waitForApplicationTargetState(String[] applicationNames, boolean targetState, int timeout) throws DeploymentException {
        boolean allReady;
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "waitForApplicationTargetState");
            StringBuilder sb = new StringBuilder();
            sb.append("Waiting for apps to ").append(targetState ? "start" : "stop").append(" - ");
            for (String appName : applicationNames) {
                sb.append(appName).append(", ");
            }
        }
        String desiredState = targetState ? "STARTED" : "NOT_INSTALLED";
        ArrayList<AppStateChecker> appStateCheckers = new ArrayList<AppStateChecker>();
        for (String appName : applicationNames) {
            appStateCheckers.add(new AppStateChecker(this.mbsc, appName));
        }
        int timeleft = timeout * 1000;
        do {
            allReady = true;
            for (AppStateChecker appStateChecker : appStateCheckers) {
                String currentState = appStateChecker.checkState();
                if (log.isLoggable(Level.FINER)) {
                    log.finer("AppMBean for " + appStateChecker.getAppName() + " is in state " + currentState);
                }
                if (!currentState.equals(desiredState)) {
                    allReady = false;
                }
                if (!desiredState.equals("STARTED") || !currentState.equals("INSTALLED") || appStateChecker.getMsInState() < 1000L) continue;
                log.finer(appStateChecker.getAppName() + " has failed to start (in INSTALLED state for more than one second)");
                this.throwDeploymentException(appStateChecker.getAppName());
            }
            if (allReady) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new DeploymentException("Deployment interrupted", (Throwable)e);
            }
        } while ((timeleft -= 100) > 0);
        if (!allReady) {
            allReady = true;
            StringBuilder appMessageStatus = new StringBuilder();
            for (AppStateChecker appStateChecker : appStateCheckers) {
                String actualState = appStateChecker.checkState();
                if (actualState.equals(desiredState)) continue;
                appMessageStatus.append("Timeout while waiting for \"").append(appStateChecker.getAppName()).append("\" ApplicationMBean to reach ").append(desiredState).append(". Actual state: ").append(actualState).append(".");
                allReady = false;
            }
            if (!allReady) {
                this.logAllApps();
                throw new DeploymentException(appMessageStatus.toString());
            }
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "waitForApplicationTargetState");
        }
    }

    public void stop() throws LifecycleException {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "stop");
        }
        try {
            this.jmxConnector.close();
        }
        catch (IOException e) {
            throw new LifecycleException("Communication with the MBean Server failed.", (Throwable)e);
        }
        if (this.shutdownThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            this.shutdownThread = null;
        }
        if (this.wlpProcess != null) {
            ProcessBuilder stopProcessBuilder = new ProcessBuilder(this.getServerCommand(CommandType.STOP));
            stopProcessBuilder.redirectErrorStream(true);
            try {
                if (this.containerConfiguration.getUsrDir() != null) {
                    stopProcessBuilder.environment().put(WLP_USER_DIR, new File(this.containerConfiguration.getUsrDir()).getCanonicalPath());
                }
            }
            catch (IOException e) {
                throw new LifecycleException("Failed to run server stop command", (Throwable)e);
            }
            try {
                Process stopProcess = stopProcessBuilder.start();
                new Thread(new ConsoleConsumer(stopProcess)).start();
                int rc = this.waitFor(stopProcess, this.containerConfiguration.getServerStopTimeout(), TimeUnit.SECONDS);
                if (rc != 0) {
                    throw new LifecycleException("Server stop failed, see log for details. RC = " + rc);
                }
            }
            catch (TimeoutException e) {
                throw new LifecycleException("Server stop command did not complete within the server stop timeout", (Throwable)e);
            }
            catch (Exception e) {
                throw new LifecycleException("Failed to run server stop command");
            }
            try {
                this.waitFor(this.wlpProcess, this.containerConfiguration.getServerStopTimeout(), TimeUnit.SECONDS);
                this.wlpProcess = null;
            }
            catch (Exception e) {
                throw new LifecycleException("Server stop command ran but the server process did not exit", (Throwable)e);
            }
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "stop");
        }
    }

    public int waitFor(Process process, int time, TimeUnit timeUnit) throws TimeoutException {
        long millisToWait = TimeUnit.MILLISECONDS.convert(time, timeUnit);
        Interruptor interruptor = new Interruptor(Thread.currentThread(), millisToWait);
        try {
            interruptor.start();
            int rc = process.waitFor();
            interruptor.stop();
            return rc;
        }
        catch (InterruptedException e) {
            throw new TimeoutException("Timed out waiting for process to stop after " + time + javaVmArgumentsDelimiter + (Object)((Object)timeUnit));
        }
    }

    public ProtocolDescription getDefaultProtocol() {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "getDefaultProtocol");
        }
        String defaultProtocol = "Servlet 5.0";
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "getDefaultProtocol", defaultProtocol);
        }
        return new ProtocolDescription(defaultProtocol);
    }

    public Class<WLPManagedContainerConfiguration> getConfigurationClass() {
        return WLPManagedContainerConfiguration.class;
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLibertyEnvVar(String key) throws IOException {
        String string;
        String value = null;
        Properties props = new Properties();
        FileInputStream fisServerEnv = null;
        FileInputStream fisSystemServerEnv = null;
        try {
            if (!key.equals(WLP_USER_DIR)) {
                try {
                    fisServerEnv = new FileInputStream(new File(this.getServerEnvFilename()));
                    props.load(fisServerEnv);
                    value = props.getProperty(key);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (value == null && !key.equals(LOG_DIR)) {
                try {
                    fisSystemServerEnv = new FileInputStream(new File(this.getSystemServerEnvFilename()));
                    props.load(fisSystemServerEnv);
                    value = props.getProperty(key);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                if (value == null) {
                    value = this.getEnv(key);
                }
            }
            log.fine("server.env: " + key + "=" + value);
            string = value;
        }
        catch (Throwable throwable) {
            WLPManagedContainer.closeQuietly(fisServerEnv);
            WLPManagedContainer.closeQuietly(fisSystemServerEnv);
            throw throwable;
        }
        WLPManagedContainer.closeQuietly(fisServerEnv);
        WLPManagedContainer.closeQuietly(fisSystemServerEnv);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void throwDeploymentException(String applicationName) throws DeploymentException {
        block15: {
            BufferedReader br = null;
            String messagesFilePath = null;
            if (log.isLoggable(Level.FINER)) {
                log.entering(className, "throwDeploymentException");
            }
            try {
                String line;
                messagesFilePath = this.getMessageFilePath();
                log.finest("Scanning message file " + messagesFilePath);
                br = new BufferedReader(new InputStreamReader(new FileInputStream(messagesFilePath)));
                String bestLine = null;
                while ((line = br.readLine()) != null) {
                    if (!line.contains("CWWKZ0002") && !line.contains("CWWKZ0001I") || !line.contains(applicationName)) continue;
                    bestLine = line;
                }
                if (bestLine == null) {
                    log.finest("The application deployment failure message was not found. Waiting...");
                } else {
                    if (bestLine.contains("CWWKZ0002")) {
                        log.finest("A exception was found in line " + bestLine + " of file " + messagesFilePath);
                        long deploymentTime = this.archiveDeployTimes.get(applicationName);
                        Throwable serverException = null;
                        for (DeploymentExceptionLocator locator : this.exceptionLocators) {
                            serverException = locator.getException(applicationName, bestLine, deploymentTime);
                            if (serverException == null) continue;
                            log.info("Deployment exception retrieved using " + locator.getClass().getSimpleName() + ": " + serverException);
                            break;
                        }
                        String loggedException = bestLine.substring(bestLine.indexOf("The exception message was: ") + 27);
                        StringBuilder deploymemtExceptionMessage = new StringBuilder();
                        deploymemtExceptionMessage.append("Failed to deploy ").append(applicationName).append(" on ").append(this.containerConfiguration.getServerName()).append(": ").append(loggedException);
                        throw new DeploymentException(deploymemtExceptionMessage.toString(), serverException);
                    }
                    if (bestLine.contains("CWWKZ0001I") && bestLine.contains(applicationName)) {
                        throw new DeploymentException("Application " + applicationName + " started unexpectedly even though it never reached the STARTED state. This should never happen.");
                    }
                }
                WLPManagedContainer.closeQuietly(br);
            }
            catch (IOException e) {
                log.warning("Exception while reading messages.log: " + messagesFilePath + ": " + e.toString());
                e.printStackTrace();
            }
            catch (XPathExpressionException e2) {
                log.warning(e2.getMessage());
                break block15;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                WLPManagedContainer.closeQuietly(br);
            }
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "throwDeploymentException");
        }
    }

    private String getEnv(final String name) {
        String result = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getenv(name);
            }
        });
        return result;
    }

    private String getWlpUsrDir() throws IOException {
        String usrDir = this.containerConfiguration.getUsrDir();
        if (usrDir == null && (usrDir = this.getLibertyEnvVar(WLP_USER_DIR)) == null) {
            usrDir = this.containerConfiguration.getWlpHome() + "/usr/";
        }
        usrDir = new File(usrDir).getCanonicalPath();
        log.finer("wlp.usr.dir path: " + usrDir);
        return usrDir;
    }

    private String getServerOutputDir() throws IOException {
        String serverOutputDir = null;
        String wlpOutputDir = this.getLibertyEnvVar(WLP_OUTPUT_DIR);
        serverOutputDir = wlpOutputDir == null ? this.getServerConfigDir() : wlpOutputDir + "/" + this.containerConfiguration.getServerName();
        log.finer("server output dir path: " + serverOutputDir);
        return serverOutputDir;
    }

    private String getServerConfigDir() throws IOException {
        String serverConfigDir = this.getWlpUsrDir() + "/servers/" + this.containerConfiguration.getServerName();
        log.finer("server.config.dir path: " + serverConfigDir);
        return serverConfigDir;
    }

    private String getLogsDirectory() throws IOException {
        String logDir = null;
        try {
            logDir = this.getServerXmlLoggingAttribute(LOG_DIRECTORY);
            log.finest("logDir getServerXmlLoggingAttribute: " + logDir);
        }
        catch (DeploymentException e) {
            log.warning(e.getMessage());
        }
        catch (XPathExpressionException e) {
            log.warning(e.getMessage());
        }
        if (logDir == null || logDir.length() == 0) {
            logDir = this.getBootstrapProperty(LOG_DIRECTORY_PROPERTY);
            log.finest("logDir getBootstrapProperty(LOG_DIRECTORY_PROPERTY): " + logDir);
        }
        if (logDir == null || logDir.length() == 0) {
            logDir = this.getLibertyEnvVar(LOG_DIR);
            log.finest("logDir getLibertyEnvVar: " + logDir);
        }
        if (logDir == null || logDir.length() == 0) {
            logDir = this.getServerOutputDir() + "/logs";
            log.finest("logDir getServerOutputDir: " + logDir);
        }
        log.finest("getLogsDirectory result: " + logDir);
        return logDir;
    }

    private String getServerXmlLoggingAttribute(String attr) throws XPathExpressionException, DeploymentException {
        String loggingElementXpath = "/server/logging";
        String resultString = "";
        try {
            Document serverXml = this.readServerXML();
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xpath = xPathFactory.newXPath();
            Element loggingElement = null;
            loggingElement = (Element)xpath.evaluate(loggingElementXpath, serverXml, XPathConstants.NODE);
            if (loggingElement != null && loggingElement.hasAttribute(attr)) {
                resultString = loggingElement.getAttribute(attr);
            } else {
                log.finest("logging element is null for " + loggingElementXpath + "/@" + attr);
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            log.finer("problem with expression: " + loggingElementXpath + javaVmArgumentsDelimiter + e.getMessage());
            throw e;
        }
        catch (DeploymentException e) {
            e.printStackTrace();
            log.finer("unreadable server.xml" + e.getMessage());
            throw e;
        }
        log.finest("getServerXmlLoggingAttribute(" + attr + ")=" + resultString);
        return resultString;
    }

    private String getServerEnvFilename() throws IOException {
        String serverEnv = this.getServerConfigDir() + "/server.env";
        log.finer("server.env path: " + serverEnv);
        return serverEnv;
    }

    private String getSystemServerEnvFilename() {
        String systemServerEnv = this.containerConfiguration.getWlpHome() + "/etc/server.env";
        log.finer("system wide server.env path: " + systemServerEnv);
        return systemServerEnv;
    }

    private List<String> getJPMSOptions() {
        ArrayList<String> args = new ArrayList<String>();
        File jpmsOptions = new File(this.containerConfiguration.getWlpHome(), "lib/platform/java/java9.options");
        try (Scanner s = new Scanner(jpmsOptions);){
            String line = null;
            String arg = null;
            while (s.hasNextLine()) {
                line = s.nextLine().trim();
                if (line.startsWith("#")) continue;
                if (line.startsWith("--")) {
                    arg = line;
                    continue;
                }
                args.add(arg + '=' + line);
                arg = null;
            }
        }
        catch (IOException e) {
            log.finer("Unable to locate Liberty JPMS options file at: " + jpmsOptions.getAbsolutePath());
            return args;
        }
        return args;
    }

    private String getMessageFilePath() throws XPathExpressionException, DeploymentException, IOException {
        String msgFileName = this.getServerXmlLoggingAttribute(MESSAGE_FILE_NAME);
        if (!(msgFileName != null && msgFileName.length() != 0 || (msgFileName = this.getBootstrapProperty(MESSAGE_FILE_PROPERTY)) != null && msgFileName.length() != 0)) {
            msgFileName = DEFAULT_MESSAGES_LOG_NAME;
        }
        String messagesFilePath = this.getLogsDirectory() + "/" + msgFileName;
        log.finer("using message.log file path: " + messagesFilePath);
        return messagesFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBootstrapProperty(String key) {
        Properties props = new Properties();
        FileInputStream fisBootstrapProperties = null;
        try {
            fisBootstrapProperties = new FileInputStream(this.getBootstrapPropertiesPath());
            props.load(fisBootstrapProperties);
        }
        catch (IOException ex) {
            try {
                log.finest(ex.getMessage());
            }
            catch (Throwable throwable) {
                WLPManagedContainer.closeQuietly(fisBootstrapProperties);
                throw throwable;
            }
            WLPManagedContainer.closeQuietly(fisBootstrapProperties);
        }
        WLPManagedContainer.closeQuietly(fisBootstrapProperties);
        String value = props.getProperty(key);
        log.finest("bootstrap.properties:" + key + "=" + value);
        return value;
    }

    private String getBootstrapPropertiesPath() {
        String bootstrapProperties = null;
        try {
            bootstrapProperties = this.getServerConfigDir() + "/bootstrap.properties";
        }
        catch (IOException e) {
            log.warning(e.getMessage());
        }
        log.finest("bootstrap.properties: " + bootstrapProperties);
        return bootstrapProperties;
    }

    private class ConsoleConsumer
    implements Runnable {
        private final Process process;

        public ConsoleConsumer(Process process) {
            this.process = process;
        }

        @Override
        public void run() {
            InputStream stream = this.process.getInputStream();
            boolean writeOutput = WLPManagedContainer.this.containerConfiguration.isOutputToConsole();
            try {
                int num;
                byte[] buf = new byte[32];
                while ((num = stream.read(buf)) != -1) {
                    if (!writeOutput) continue;
                    System.out.write(buf, 0, num);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class WebModule {
        private String name;
        private String contextRoot;
        private WebArchive archive;

        private WebModule() {
        }
    }

    private static enum CommandType {
        RUN,
        STOP;

    }
}

