/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.arquillian.managed;

import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;

public class AppStateChecker {
    private final String appName;
    private final ObjectName objectName;
    private final MBeanServerConnection mbsc;
    private String lastState;
    private long lastStateTransitionNanos;

    public AppStateChecker(MBeanServerConnection mbsc, String appName) throws DeploymentException {
        this.appName = appName;
        this.mbsc = mbsc;
        try {
            this.objectName = new ObjectName("WebSphere:service=com.ibm.websphere.application.ApplicationMBean,name=" + appName);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("The generated object name is wrong. The applicationName used was '" + appName + "'", (Throwable)e);
        }
    }

    public String checkState() throws DeploymentException {
        String result;
        try {
            result = (String)this.mbsc.getAttribute(this.objectName, "State");
        }
        catch (InstanceNotFoundException e) {
            result = "NOT_INSTALLED";
        }
        catch (Exception e) {
            throw new DeploymentException("Exception while checking state of application " + this.appName, (Throwable)e);
        }
        if (!result.equals(this.lastState)) {
            this.lastStateTransitionNanos = System.nanoTime();
            this.lastState = result;
        }
        return result;
    }

    public long getMsInState() {
        return (System.nanoTime() - this.lastStateTransitionNanos) / 1000000L;
    }

    public String getAppName() {
        return this.appName;
    }
}

