/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.arquillian.managed.exceptions;

import io.openliberty.arquillian.managed.exceptions.DeploymentExceptionLocator;
import io.openliberty.arquillian.managed.exceptions.NestedExceptionBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FFDCExceptionLocator
implements DeploymentExceptionLocator {
    private static Logger log = Logger.getLogger(FFDCExceptionLocator.class.getName());
    private final String logsDirectory;

    public FFDCExceptionLocator(String logsDirectory) {
        this.logsDirectory = logsDirectory;
    }

    @Override
    public Throwable getException(String appName, String logLine, long deploymentTime) {
        ArrayList<NestedExceptionBuilder.ExMsg> chain;
        File[] ffdcFiles = this.getFfdcFilesSince(deploymentTime);
        File ffdc = this.findStateChangeExceptionFfdcFileForApp(appName, ffdcFiles);
        Throwable cause = null;
        if (ffdc != null && (chain = this.getExceptionCausalChain(ffdc)) != null) {
            cause = NestedExceptionBuilder.buildNestedException(chain);
        }
        for (Throwable c = cause; c != null; c = c.getCause()) {
            log.finest("FFDC Exception Chain:" + c.getClass());
        }
        return cause;
    }

    private File[] getFfdcFilesSince(Long deployTime) {
        long AT_LEAST_ONE_SECOND = 1001L;
        final long since = deployTime != null ? deployTime - 1001L : 0L;
        Object[] ffdcFiles = null;
        int attempts = 0;
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            File ffdcDir = null;
            String ffdcDirPath = "NOT_SET";
            ffdcDirPath = this.logsDirectory + "/ffdc";
            ffdcDir = new File(ffdcDirPath);
            log.finest("FFDC Dir: " + ffdcDir.getAbsolutePath() + "looking for ffdc_* file since " + new Timestamp(since));
            ffdcFiles = ffdcDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String fileName) {
                    File ffdcFile = new File(dir, fileName);
                    return ffdcFile.lastModified() >= since && fileName.startsWith("ffdc_");
                }
            });
            log.finest("FFDC files are: " + Arrays.toString(ffdcFiles));
        } while ((ffdcFiles == null || ffdcFiles.length == 0) && ++attempts <= 100);
        return ffdcFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File findStateChangeExceptionFfdcFileForApp(String appName, File[] ffdcFiles) {
        BufferedReader br = null;
        try {
            for (int i = 0; i < ffdcFiles.length; ++i) {
                String line;
                File ffdcFile = ffdcFiles[i];
                log.finest("Processing FFDC file: " + ffdcFile.getAbsolutePath());
                try {
                    br = new BufferedReader(new InputStreamReader(new FileInputStream(ffdcFile)));
                }
                catch (FileNotFoundException e) {
                    log.warning("File " + ffdcFile.getAbsolutePath() + " is no longer accessible");
                    continue;
                }
                boolean fileIsForStateChangeException = false;
                boolean fileIsForCorrectApplication = false;
                while ((line = br.readLine()) != null) {
                    fileIsForStateChangeException = fileIsForStateChangeException || line.contains("Stack Dump = com.ibm.ws.container.service.state.StateChangeException");
                    log.finest("fileIsForStateChangeException:" + fileIsForStateChangeException + " " + line);
                    fileIsForCorrectApplication = fileIsForCorrectApplication || line.contains("appName") && line.contains(appName);
                    log.finest("fileIsForCorrectApplication:" + fileIsForCorrectApplication + "(" + appName + ") " + line);
                    if (!fileIsForStateChangeException || !fileIsForCorrectApplication) continue;
                    log.finest("Found StateChangeExceptionFfdc for " + appName + ": " + ffdcFile.getAbsolutePath());
                    File file = ffdcFile;
                    return file;
                }
                try {
                    log.finest("Did not find StateChangeExceptionFfdc for " + appName + ": " + ffdcFile.getAbsolutePath() + "(file was scanned completely)");
                    continue;
                }
                catch (IOException e) {
                    log.warning("File " + ffdcFile.getAbsolutePath() + " is not readable");
                }
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    log.warning(e.getMessage());
                }
            }
        }
        log.finest("No StateChangeExceptionFfdc for " + appName + " was found ");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<NestedExceptionBuilder.ExMsg> getExceptionCausalChain(File ffdc) {
        ArrayList<NestedExceptionBuilder.ExMsg> result = new ArrayList<NestedExceptionBuilder.ExMsg>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(new FileInputStream(ffdc)));
            while ((line = br.readLine()) != null) {
                Pattern p = Pattern.compile("(Stack Dump = |Caused by: )([\\p{L}\\p{N}_$\\.]+?)(:|$)(.*)");
                Matcher m = p.matcher(line);
                if (m.matches()) {
                    NestedExceptionBuilder.ExMsg x = new NestedExceptionBuilder.ExMsg();
                    x.exName = m.group(2);
                    x.logMsg = line;
                    log.finest("match on line: " + line + " resolved to className " + x.exName);
                    result.add(x);
                    continue;
                }
                log.finest("no match found on line: " + line);
            }
        }
        catch (IOException e) {
            log.warning("FFDC file " + ffdc != null ? ffdc.getAbsolutePath() : "null IO Exception: " + e.toString());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    log.warning(e.getMessage());
                }
            }
        }
        log.finest("Exception stack found was: " + Arrays.deepToString(result.toArray()));
        return result;
    }
}

