/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.arquillian.managed.exceptions;

import io.openliberty.arquillian.managed.exceptions.DeploymentExceptionLocator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class SupportFeatureSerializedExceptionLocator
implements DeploymentExceptionLocator {
    private static final Logger log = Logger.getLogger(SupportFeatureSerializedExceptionLocator.class.getName());
    private final MBeanServerConnection mbsc;
    private final ObjectName on;

    public SupportFeatureSerializedExceptionLocator(MBeanServerConnection mbsc) {
        this.mbsc = mbsc;
        StringBuilder sb = new StringBuilder("LibertyArquillian:");
        sb.append("type=").append("DeploymentExceptionMBean");
        try {
            this.on = new ObjectName(sb.toString());
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid ObjectName: " + sb.toString() + " " + e, e);
        }
    }

    @Override
    public Throwable getException(String appName, String logLine, long deploymentTime) {
        Throwable result;
        block19: {
            result = null;
            try {
                Object[] response = (Object[])this.mbsc.invoke(this.on, "getDeploymentException", new String[]{appName, "serialize"}, new String[]{String.class.getName(), String.class.getName()});
                int status = (Integer)response[0];
                if (status == 400) {
                    log.warning("After " + appName + " failed to start, the server did not report an exception for that app");
                    break block19;
                }
                if (status != 200) {
                    log.info("Unable to receive serialized exception from server, is usr:arquillian-support-jakarta-2.1 installed?");
                    break block19;
                }
                try (ByteArrayInputStream inStream = new ByteArrayInputStream((byte[])response[1]);){
                    ObjectInputStream objStream = new ObjectInputStream(inStream);
                    Object readObject = objStream.readObject();
                    if (readObject instanceof Throwable) {
                        result = (Throwable)readObject;
                    }
                }
            }
            catch (IOException ex) {
                log.warning("IO Exception trying to get serialized exception: " + ex);
            }
            catch (ClassNotFoundException ex) {
                log.finer("Unable to find class for serialized exception: " + ex);
            }
            catch (Exception ex) {
                log.warning("Unexpected exception while trying to receive serialized exception: " + ex);
            }
        }
        return result;
    }
}

