/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.arquillian.managed.exceptions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class NestedExceptionBuilder {
    private static Logger log = Logger.getLogger(NestedExceptionBuilder.class.getName());
    private static final Map<String, String> exceptionMappings = new HashMap<String, String>();

    public static Throwable buildNestedException(List<ExMsg> exs) {
        Throwable causeSoFar = null;
        for (int nestLevel = exs.size() - 1; nestLevel >= 0; --nestLevel) {
            causeSoFar = NestedExceptionBuilder.createException(exs.get(nestLevel), causeSoFar);
        }
        return causeSoFar;
    }

    private static Throwable createException(ExMsg x, Throwable cause) {
        String mappedExName;
        Throwable t = NestedExceptionBuilder.attemptCreation(x.exName, x.logMsg, cause);
        if (t == null) {
            String superclass;
            Iterator<String> iterator = x.superclasses.iterator();
            while (iterator.hasNext() && (t = NestedExceptionBuilder.attemptCreation(superclass = iterator.next(), x.logMsg, cause)) == null) {
            }
        }
        if (t == null && (mappedExName = exceptionMappings.get(x.exName)) != null) {
            t = NestedExceptionBuilder.attemptCreation(mappedExName, x.logMsg, cause);
        }
        if (t == null) {
            log.warning("Unable to create an object for " + x.exName + ", falling back to UnloadableLogException");
            t = new UnloadableLogException("<" + x.exName + "> " + x.logMsg, cause);
        }
        log.finest("Actually created class= " + t.getClass().getName() + " instance msg=" + t.getMessage());
        return t;
    }

    private static Throwable attemptCreation(String className, String message, Throwable cause) {
        Class<? extends Throwable> clazz = null;
        try {
            clazz = NestedExceptionBuilder.loadThrowable(className);
        }
        catch (ClassNotFoundException e) {
            log.fine("Unable to load class " + className + ": " + e);
            return null;
        }
        Throwable t = null;
        if (cause == null) {
            t = NestedExceptionBuilder.attemptConstruction(clazz, message);
            if (t == null) {
                t = NestedExceptionBuilder.attemptConstruction(clazz, message, null);
            }
            if (t == null) {
                t = NestedExceptionBuilder.attemptConstruction(clazz);
            }
        } else {
            t = NestedExceptionBuilder.attemptConstruction(clazz, message, cause);
            if (t == null) {
                t = NestedExceptionBuilder.attemptConstructionAndInit(clazz, message, cause);
            }
            if (t == null) {
                t = NestedExceptionBuilder.attemptConstruction(clazz, cause);
            }
        }
        if (t == null) {
            log.fine("Unable to construct an instance of " + className);
        }
        return t;
    }

    private static Class<? extends Throwable> loadThrowable(String name) throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(name);
            return clazz.asSubclass(Throwable.class);
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (ClassCastException e) {
            throw new ClassNotFoundException("Loaded " + name + " successfully but it isn't a Throwable", e);
        }
        catch (Exception e) {
            throw new ClassNotFoundException("Unable to load " + name + " due to " + e, e);
        }
    }

    private static Throwable attemptConstruction(Class<? extends Throwable> clazz, String msg) {
        try {
            return clazz.getConstructor(String.class).newInstance(msg);
        }
        catch (Exception e) {
            log.finer("Arquillian container could not construct " + clazz.getName() + "(String): " + e);
            return null;
        }
    }

    private static Throwable attemptConstruction(Class<? extends Throwable> clazz, String msg, Throwable cause) {
        try {
            return clazz.getConstructor(String.class, Throwable.class).newInstance(msg, cause);
        }
        catch (Exception e) {
            log.finer("Arquillian container could not construct " + clazz.getName() + "(String, Throwable): " + e);
            return null;
        }
    }

    private static Throwable attemptConstructionAndInit(Class<? extends Throwable> clazz, String msg, Throwable cause) {
        try {
            Throwable t = clazz.getConstructor(String.class).newInstance(msg);
            t.initCause(cause);
            return t;
        }
        catch (Exception e) {
            log.finer("Arquillian container could not construct " + clazz.getName() + "(String) and invoke initCause(): " + e);
            return null;
        }
    }

    private static Throwable attemptConstruction(Class<? extends Throwable> clazz, Throwable cause) {
        try {
            return clazz.getConstructor(Throwable.class).newInstance(cause);
        }
        catch (Exception e) {
            log.finer("Arquillian container could not construct " + clazz.getName() + "(Throwable): " + e);
            return null;
        }
    }

    private static Throwable attemptConstruction(Class<? extends Throwable> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.finer("Arquillian container could not construct " + clazz.getName() + "(): " + e);
            return null;
        }
    }

    static {
        exceptionMappings.put("org.jboss.weld.exceptions.DeploymentException", "javax.enterprise.inject.spi.DeploymentException");
        exceptionMappings.put("org.jboss.weld.exceptions.InconsistentSpecializationException", "javax.enterprise.inject.spi.DeploymentException");
        exceptionMappings.put("org.jboss.weld.exceptions.UnserializableDependencyException", "javax.enterprise.inject.spi.DeploymentException");
        exceptionMappings.put("org.jboss.weld.exceptions.DefinitionException", "javax.enterprise.inject.spi.DefinitionException");
    }

    public static class UnloadableLogException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UnloadableLogException(String logLine) {
            super(logLine);
        }

        public UnloadableLogException(String logLine, Throwable cause) {
            super(logLine, cause);
        }
    }

    public static class ExMsg {
        String exName;
        String logMsg;
        List<String> superclasses = new ArrayList<String>();

        public String toString() {
            return this.exName + "(" + this.logMsg + ")";
        }
    }
}

