/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.arquillian.managed.exceptions;

import io.openliberty.arquillian.managed.exceptions.DeploymentExceptionLocator;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;

public class SupportFeatureSerializedExceptionLocator
implements DeploymentExceptionLocator {
    private static final Logger log = Logger.getLogger(SupportFeatureSerializedExceptionLocator.class.getName());
    private final URI uri;

    public SupportFeatureSerializedExceptionLocator(String host, int port) {
        try {
            this.uri = new URI("http", null, host, port, "/arquillian-support/deployment-exception", "format=serialize", null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI: " + e, e);
        }
    }

    @Override
    public Throwable getException(String appName, String logLine, long deploymentTime) {
        Throwable result;
        block19: {
            result = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(this.uri);
                uriBuilder.addParameter("appName", appName);
                HttpResponse resp = Request.Get((URI)uriBuilder.build()).execute().returnResponse();
                if (resp.getStatusLine().getStatusCode() == 400) {
                    log.warning("After " + appName + " failed to start, the server did not report an exception for that app");
                    break block19;
                }
                if (resp.getStatusLine().getStatusCode() != 200) {
                    log.info("Unable to recieve serialized exception from server, is usr:arquillian-support-1.0 installed?");
                    break block19;
                }
                try (InputStream inStream = resp.getEntity().getContent();){
                    ObjectInputStream objStream = new ObjectInputStream(inStream);
                    Object readObject = objStream.readObject();
                    if (readObject instanceof Throwable) {
                        result = (Throwable)readObject;
                    }
                }
            }
            catch (IOException ex) {
                log.warning("IO Exception trying to get serialized exception: " + ex);
            }
            catch (ClassNotFoundException ex) {
                log.finer("Unable to find class for serialized exception: " + ex);
            }
            catch (Exception ex) {
                log.warning("Unexpected exception while trying to recieve serialized exception: " + ex);
            }
        }
        return result;
    }
}

