/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.arquillian.managed.exceptions;

import io.openliberty.arquillian.managed.exceptions.DeploymentExceptionLocator;
import io.openliberty.arquillian.managed.exceptions.NestedExceptionBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;

public class SupportFeatureTextExceptionLocator
implements DeploymentExceptionLocator {
    private static final Logger log = Logger.getLogger(SupportFeatureTextExceptionLocator.class.getName());
    private final URI uri;
    private static final Pattern CLASS_PATTERN = Pattern.compile("exClass (.*)");
    private static final Pattern SUPERCLASS_PATTERN = Pattern.compile("exSuperclass (.*)");

    public SupportFeatureTextExceptionLocator(String host, int port) {
        try {
            this.uri = new URI("http", null, host, port, "/arquillian-support/deployment-exception", "format=text", null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI: " + e, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Throwable getException(String appName, String logLine, long deploymentTime) {
        try {
            URIBuilder uriBuilder = new URIBuilder(this.uri);
            uriBuilder.addParameter("appName", appName);
            HttpResponse resp = Request.Get((URI)uriBuilder.build()).execute().returnResponse();
            if (resp.getStatusLine().getStatusCode() == 400) {
                log.warning("After " + appName + " failed to start, the server did not report an exception for that app");
                return null;
            }
            if (resp.getStatusLine().getStatusCode() != 200) {
                log.info("Unable to recieve text format exception from server, is usr:arquillian-support-1.0?");
                return null;
            }
            log.finer("Reading exception returned from server");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resp.getEntity().getContent(), StandardCharsets.UTF_8));){
                Throwable throwable = this.readResponse(reader);
                return throwable;
            }
        }
        catch (IOException ex) {
            log.warning("IO Exception trying to get text exception: " + ex);
            return null;
        }
        catch (Exception ex) {
            log.warning("Unexpected exception thrown while trying to get text exception: " + ex);
        }
        return null;
    }

    private Throwable readResponse(BufferedReader reader) throws IOException {
        String line;
        ResponseReader responseReader = new ResponseReader();
        while ((line = reader.readLine()) != null) {
            Matcher classMatcher = CLASS_PATTERN.matcher(line);
            if (classMatcher.matches()) {
                responseReader.readClass(classMatcher.group(1));
                continue;
            }
            Matcher superclassMatcher = SUPERCLASS_PATTERN.matcher(line);
            if (superclassMatcher.matches()) {
                responseReader.readSuperclass(superclassMatcher.group(1));
                continue;
            }
            responseReader.readMessage(line);
        }
        responseReader.finishMsg();
        List msgs = responseReader.finish();
        return NestedExceptionBuilder.buildNestedException(msgs);
    }

    private static class ResponseReader {
        List<NestedExceptionBuilder.ExMsg> msgs = new ArrayList<NestedExceptionBuilder.ExMsg>();
        NestedExceptionBuilder.ExMsg currentMsg = null;
        StringBuilder messageBuilder = null;

        private ResponseReader() {
        }

        private void readClass(String className) {
            log.finer("Read class " + className);
            this.finishMsg();
            this.currentMsg.exName = className;
        }

        private void readSuperclass(String className) {
            log.finer("Read superclass" + className);
            this.currentMsg.superclasses.add(className);
        }

        private void readMessage(String message) {
            log.finer("Read message " + message);
            if (this.messageBuilder == null) {
                this.messageBuilder = new StringBuilder();
            } else {
                this.messageBuilder.append("\n");
            }
            this.messageBuilder.append(message);
        }

        private void finishMsg() {
            if (this.currentMsg != null) {
                this.msgs.add(this.currentMsg);
                if (this.messageBuilder != null) {
                    this.currentMsg.logMsg = this.messageBuilder.toString();
                }
            }
            this.currentMsg = new NestedExceptionBuilder.ExMsg();
            this.messageBuilder = null;
        }

        private List<NestedExceptionBuilder.ExMsg> finish() {
            return this.msgs;
        }
    }
}

