/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.arquillian.remote;

import io.openliberty.arquillian.remote.WLPRemoteContainerConfiguration;
import io.openliberty.arquillian.remote.WLPRestClient;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.ClientProtocolException;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class WLPRemoteContainer
implements DeployableContainer<WLPRemoteContainerConfiguration> {
    private static final String className = WLPRemoteContainer.class.getName();
    private static Logger log = Logger.getLogger(className);
    private WLPRemoteContainerConfiguration containerConfiguration;
    private WLPRestClient restClient;

    public Class<WLPRemoteContainerConfiguration> getConfigurationClass() {
        return WLPRemoteContainerConfiguration.class;
    }

    public void setup(WLPRemoteContainerConfiguration configuration) {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "setup");
        }
        this.containerConfiguration = configuration;
        this.restClient = new WLPRestClient(this.containerConfiguration);
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "setup");
        }
    }

    public void start() throws LifecycleException {
        try {
            String remoteServerName;
            boolean ready = this.restClient.isServerUp();
            if (!ready) {
                throw new LifecycleException("Remote server is not started");
            }
            String arqServerName = this.containerConfiguration.getServerName();
            if (!arqServerName.equals(remoteServerName = this.restClient.getServerName())) {
                throw new LifecycleException("The serverName (" + arqServerName + ") specified in arquillian.xml does not match the server name of the remote server (" + remoteServerName + ").");
            }
        }
        catch (ClientProtocolException e) {
            throw new LifecycleException("Could not determine remote server status : " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new LifecycleException("Could not determine remote server status : " + e.getMessage(), (Throwable)e);
        }
    }

    public void stop() throws LifecycleException {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "stop");
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "stop");
        }
    }

    public ProtocolDescription getDefaultProtocol() {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "getDefaultProtocol");
        }
        String defaultProtocol = "Servlet 5.0";
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "getDefaultProtocol", defaultProtocol);
        }
        return new ProtocolDescription(defaultProtocol);
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "deploy");
        }
        String archiveName = archive.getName();
        String archiveType = this.createDeploymentType(archiveName);
        String deployName = this.createDeploymentName(archiveName);
        if (!(archiveType.equalsIgnoreCase("ear") || archiveType.equalsIgnoreCase("war") || archiveType.equalsIgnoreCase("eba"))) {
            throw new DeploymentException("Invalid archive type: " + archiveType + ".  Valid archive types are ear, war, and eba.");
        }
        try {
            File exportedArchiveLocation = new File(System.getProperty("java.io.tmpdir"), archiveName);
            ((ZipExporter)archive.as(ZipExporter.class)).exportTo(exportedArchiveLocation, true);
            this.restClient.deploy(exportedArchiveLocation);
            exportedArchiveLocation.deleteOnExit();
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage());
        }
        this.waitForApplicationTargetState(deployName, true, this.containerConfiguration.getAppDeployTimeout());
        ProtocolMetaData metaData = new ProtocolMetaData();
        HTTPContext httpContext = new HTTPContext(this.containerConfiguration.getHostName(), this.containerConfiguration.getHttpPort());
        httpContext.add(new Servlet("ArquillianServletRunnerEE9", deployName));
        metaData.addContext((Object)httpContext);
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "deploy");
        }
        return metaData;
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "undeploy");
        }
        String archiveName = archive.getName();
        String deployName = this.createDeploymentName(archiveName);
        try {
            this.restClient.undeploy(archiveName);
        }
        catch (Exception e) {
            throw new DeploymentException("Error undeploying application " + archiveName + " " + e);
        }
        this.waitForApplicationTargetState(deployName, false, this.containerConfiguration.getAppUndeployTimeout());
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "undeploy");
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
    }

    private String createDeploymentName(String archiveName) {
        return archiveName.substring(0, archiveName.lastIndexOf("."));
    }

    private String createDeploymentType(String archiveName) {
        return archiveName.substring(archiveName.lastIndexOf(".") + 1);
    }

    private void waitForApplicationTargetState(String applicationName, boolean targetState, int timeout) throws DeploymentException {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "waitForApplicationTargetState", new Object[]{applicationName, targetState, timeout});
        }
        try {
            boolean curState;
            int timeleft = timeout * 1000;
            boolean bl = curState = !targetState;
            while (curState != targetState) {
                Thread.sleep(100L);
                curState = this.restClient.isApplicationStarted(applicationName);
                if (timeleft <= 0) {
                    throw new DeploymentException("Timeout while waiting for ApplicationState to reach 'STARTED'");
                }
                timeleft -= 100;
            }
        }
        catch (InterruptedException e) {
            throw new DeploymentException("Error occurred while while waiting for ApplicationState to reach STARTED " + e);
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "waitForApplicationTargetState");
        }
    }
}

