/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.arquillian.remote;

import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;

public class WLPRemoteContainerConfiguration
implements ContainerConfiguration {
    private String serverName = "defaultServer";
    private int serverStartTimeout = 30;
    private int appDeployTimeout = 20;
    private int appUndeployTimeout = 2;
    private String username;
    private String password;
    private String hostName;
    private int httpPort = 9080;
    private int httpsPort = 9443;
    private boolean outputToConsole = true;
    private String testProtocol = "servlet";

    public void validate() throws ConfigurationException {
        if (this.hostName == null || this.hostName.equals("")) {
            throw new ConfigurationException("hostName is required for initialization");
        }
        if (this.username == null) {
            throw new ConfigurationException("username is required for initialization");
        }
        if (this.password == null) {
            throw new ConfigurationException("password is required for initialization");
        }
        if (this.httpPort > 65535 || this.httpPort < 0) {
            throw new ConfigurationException("httpPort provided is not valid: " + this.httpPort);
        }
        if (this.httpsPort > 65535 || this.httpsPort < 0) {
            throw new ConfigurationException("httpsPort provided is not valid: " + this.httpPort);
        }
        if (!"rest".equalsIgnoreCase(this.testProtocol) && !"servlet".equalsIgnoreCase(this.testProtocol)) {
            throw new ConfigurationException("testProtocol must be set to rest or servlet");
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public boolean isOutputToConsole() {
        return this.outputToConsole;
    }

    public void setOutputToConsole(boolean outputToConsole) {
        this.outputToConsole = outputToConsole;
    }

    public int getServerStartTimeout() {
        return this.serverStartTimeout;
    }

    public void setServerStartTimeout(int serverStartTimeout) {
        this.serverStartTimeout = serverStartTimeout;
    }

    public int getAppDeployTimeout() {
        return this.appDeployTimeout;
    }

    public void setAppDeployTimeout(int appDeployTimeout) {
        this.appDeployTimeout = appDeployTimeout;
    }

    public int getAppUndeployTimeout() {
        return this.appUndeployTimeout;
    }

    public void setAppUndeployTimeout(int appUndeployTimeout) {
        this.appUndeployTimeout = appUndeployTimeout;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public String getTestProtocol() {
        return this.testProtocol;
    }

    public void setTestProtocol(String protocol) {
        this.testProtocol = protocol;
    }

    public boolean isServletTestProtocol() {
        return "servlet".equalsIgnoreCase(this.testProtocol);
    }
}

