/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.arquillian.support;

import io.openliberty.arquillian.support.IncidentListener;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;

@WebServlet(value={"/deployment-exception"})
public class DeploymentExceptionServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Set<Class<?>> topClasses = new HashSet();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        IncidentListener listener = this.getIncidentListener(req);
        resp.setContentType("text/plain;charset=UTF-8");
        IncidentListener.ExceptionInfo ex = listener.getLastException();
        String appName = req.getParameter("appName");
        if (appName == null) {
            resp.setStatus(400);
            resp.getWriter().println("No appName given");
            return;
        }
        if (ex == null) {
            resp.setStatus(400);
            resp.getWriter().println("No exception logged");
            return;
        }
        if (!appName.equals(ex.getAppName())) {
            resp.setStatus(400);
            resp.getWriter().println("Last exception was not thrown by the requested app");
            return;
        }
        String format = req.getParameter("format");
        if (format == null) {
            resp.setStatus(400);
            resp.getWriter().println("Format parameter not set");
        } else if (format.equals("text")) {
            this.printText(resp.getWriter(), ex.getException());
        } else if (format.equals("stack")) {
            ex.getException().printStackTrace(resp.getWriter());
        } else if (format.equals("serialize")) {
            resp.setContentType("application/java-serialized-object");
            try (ObjectOutputStream oos = new ObjectOutputStream((OutputStream)resp.getOutputStream());){
                oos.writeObject(ex.getException());
            }
        } else {
            resp.setStatus(400);
            resp.getWriter().println("Invalid format requested");
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!"true".equalsIgnoreCase(req.getParameter("clear"))) {
            throw new ServletException("Invalid command");
        }
        this.getIncidentListener(req).clear();
    }

    private IncidentListener getIncidentListener(HttpServletRequest req) {
        ServletContext context = req.getServletContext();
        IncidentListener listener = (IncidentListener)context.getAttribute("incident-listener");
        if (listener == null) {
            throw new RuntimeException("Incident listener is not set");
        }
        return listener;
    }

    private void printText(PrintWriter resp, Throwable exception) {
        HashSet<Throwable> processed = new HashSet<Throwable>();
        for (Throwable t = exception; t != null && !processed.contains(t); t = t.getCause()) {
            this.printClass(resp, t);
            processed.add(t);
        }
    }

    private void printClass(PrintWriter resp, Throwable exception) {
        resp.print("exClass ");
        resp.print(exception.getClass().getName());
        resp.println();
        for (Class<?> clazz = exception.getClass().getSuperclass(); clazz != null && !topClasses.contains(clazz); clazz = clazz.getSuperclass()) {
            resp.print("exSuperclass ");
            resp.print(clazz.getName());
            resp.println();
        }
        resp.println(exception.getMessage());
    }

    static {
        topClasses.add(Object.class);
        topClasses.add(Throwable.class);
        topClasses.add(Exception.class);
        topClasses.add(Error.class);
        topClasses.add(RuntimeException.class);
    }
}

