/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.arquillian.support;

import io.openliberty.arquillian.support.DeploymentExceptionMBean;
import io.openliberty.arquillian.support.IncidentListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;

public class DeploymentExceptionMBeanImpl
extends StandardMBean
implements DeploymentExceptionMBean {
    private static final Set<Class<?>> topClasses = new HashSet();
    private final IncidentListener listener;

    DeploymentExceptionMBeanImpl(IncidentListener listener) throws NotCompliantMBeanException {
        super(DeploymentExceptionMBean.class);
        this.listener = listener;
    }

    @Override
    public Object[] getDeploymentException(String appName, String format) throws MBeanException {
        IncidentListener.ExceptionInfo ex = this.listener.getLastException();
        if (appName == null) {
            return new Object[]{400, "No appName given"};
        }
        if (ex == null) {
            return new Object[]{400, "No exception logged"};
        }
        if (!appName.equals(ex.getAppName())) {
            return new Object[]{400, "Last exception was not thrown by the requested app"};
        }
        if (format == null) {
            return new Object[]{400, "Format parameter not set"};
        }
        if (format.equals("text")) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.printText(pw, ex.getException());
            pw.flush();
            return new Object[]{200, sw.toString()};
        }
        if (format.equals("stack")) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.getException().printStackTrace(pw);
            pw.flush();
            return new Object[]{200, sw.toString()};
        }
        if (format.equals("serialize")) {
            Object[] objectArray;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            try {
                oos.writeObject(ex.getException());
                oos.flush();
                objectArray = new Object[]{200, baos.toByteArray()};
            }
            catch (Throwable throwable) {
                try {
                    try {
                        oos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException io) {
                    throw new MBeanException(io);
                }
            }
            oos.close();
            return objectArray;
        }
        return new Object[]{400, "Invalid format requested"};
    }

    @Override
    public void clear() {
        this.listener.clear();
    }

    private void printText(PrintWriter resp, Throwable exception) {
        HashSet<Throwable> processed = new HashSet<Throwable>();
        for (Throwable t = exception; t != null && !processed.contains(t); t = t.getCause()) {
            this.printClass(resp, t);
            processed.add(t);
        }
    }

    private void printClass(PrintWriter resp, Throwable exception) {
        resp.print("exClass ");
        resp.print(exception.getClass().getName());
        resp.println();
        for (Class<?> clazz = exception.getClass().getSuperclass(); clazz != null && !topClasses.contains(clazz); clazz = clazz.getSuperclass()) {
            resp.print("exSuperclass ");
            resp.print(clazz.getName());
            resp.println();
        }
        resp.println(exception.getMessage());
    }

    static {
        topClasses.add(Object.class);
        topClasses.add(Throwable.class);
        topClasses.add(Exception.class);
        topClasses.add(Error.class);
        topClasses.add(RuntimeException.class);
    }
}

